/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class DroppedPropertiesSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(DroppedPropertiesSensor.class);
    private static final String REPORT_PATHS_PROPERTY = "sonar.jacoco.reportPaths";
    private static final String REPORT_PATH_PROPERTY = "sonar.jacoco.reportPath";
    private static final List<String> REMOVED_REPORT_PATH_PROPERTIES = Arrays.asList("sonar.jacoco.reportPath", "sonar.jacoco.reportPaths");
    private static final String IT_REPORT_PATH_PROPERTY = "sonar.jacoco.itReportPath";
    private static final String REPORT_MISSING_FORCE_ZERO = "sonar.jacoco.reportMissing.force.zero";
    private static final List<String> OTHER_REMOVED_PROPERTIES = Arrays.asList("sonar.jacoco.reportMissing.force.zero", "sonar.jacoco.itReportPath");
    private static final List<String> ALL_REMOVED_PROPERTIES = new ArrayList<String>();
    private final AnalysisWarnings analysisWarnings;

    public DroppedPropertiesSensor(AnalysisWarnings analysisWarnings) {
        this.analysisWarnings = analysisWarnings;
        ALL_REMOVED_PROPERTIES.addAll(REMOVED_REPORT_PATH_PROPERTIES);
        ALL_REMOVED_PROPERTIES.addAll(OTHER_REMOVED_PROPERTIES);
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").onlyWhenConfiguration(configuration -> ALL_REMOVED_PROPERTIES.stream().anyMatch(arg_0 -> ((Configuration)configuration).hasKey(arg_0))).name("Removed properties sensor");
    }

    public void execute(SensorContext context) {
        if (!context.config().hasKey(REPORT_PATHS_PROPERTY) || !context.config().hasKey(REPORT_PATH_PROPERTY)) {
            this.warnIfConfigHasKey(REMOVED_REPORT_PATH_PROPERTIES, context);
        }
        this.warnIfConfigHasKey(OTHER_REMOVED_PROPERTIES, context);
    }

    private void warnIfConfigHasKey(List<String> properties, SensorContext context) {
        properties.forEach(prop -> {
            if (context.config().hasKey(prop)) {
                String msg = "Property '" + prop + "' is no longer supported. Use JaCoCo's xml report and sonar-jacoco plugin.";
                this.analysisWarnings.addUnique(msg);
                LOG.warn(msg);
            }
        });
    }
}

