/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin.rules;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.css.plugin.rules.CssRule;
import org.sonar.css.plugin.rules.RuleUtils;

@Rule(key="S4654")
public class PropertyNoUnknown
implements CssRule {
    private static final String DEFAULT_IGNORED_PROPERTIES = "composes, /^mso-/";
    private static final String DEFAULT_IGNORED_SELECTORS = "/^:export.*/, /^:import.*/";
    @RuleProperty(key="ignoreTypes", description="Comma-separated list of strings and/or regular expressions for properties to consider as valid.", defaultValue="composes, /^mso-/")
    String ignoreProperties = "composes, /^mso-/";
    @RuleProperty(key="ignoreSelectors", description="Comma-separated list of strings and/or regular expressions for selectors to consider as valid.", defaultValue="/^:export.*/, /^:import.*/")
    String ignoreSelectors = "/^:export.*/, /^:import.*/";

    @Override
    public String stylelintKey() {
        return "property-no-unknown";
    }

    @Override
    public List<Object> stylelintOptions() {
        return Arrays.asList(true, new StylelintIgnoreOption(RuleUtils.splitAndTrim(this.ignoreProperties), RuleUtils.splitAndTrim(this.ignoreSelectors)));
    }

    private static class StylelintIgnoreOption {
        private final List<String> ignoreProperties;
        private final List<String> ignoreSelectors;

        private StylelintIgnoreOption(List<String> ignoreProperties, List<String> ignoreSelectors) {
            this.ignoreProperties = ignoreProperties;
            this.ignoreSelectors = ignoreSelectors;
        }
    }
}

