/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolTableBuilder;

public class PythonVisitorContext {
    private final FileInput rootTree;
    private final PythonFile pythonFile;
    private File workingDirectory = null;
    private final RecognitionException parsingException;
    private List<PythonCheck.PreciseIssue> issues = new ArrayList<PythonCheck.PreciseIssue>();

    public PythonVisitorContext(FileInput rootTree, PythonFile pythonFile, @Nullable File workingDirectory, @Nullable String packageName) {
        this.rootTree = rootTree;
        this.pythonFile = pythonFile;
        this.workingDirectory = workingDirectory;
        this.parsingException = null;
        SymbolTableBuilder symbolTableBuilder = packageName != null ? new SymbolTableBuilder(packageName, pythonFile) : new SymbolTableBuilder(pythonFile);
        symbolTableBuilder.visitFileInput(rootTree);
    }

    public PythonVisitorContext(FileInput rootTree, PythonFile pythonFile, @Nullable File workingDirectory, String packageName, ProjectLevelSymbolTable projectLevelSymbolTable) {
        this.rootTree = rootTree;
        this.pythonFile = pythonFile;
        this.workingDirectory = workingDirectory;
        this.parsingException = null;
        new SymbolTableBuilder(packageName, pythonFile, projectLevelSymbolTable).visitFileInput(rootTree);
    }

    public PythonVisitorContext(PythonFile pythonFile, RecognitionException parsingException) {
        this.rootTree = null;
        this.pythonFile = pythonFile;
        this.parsingException = parsingException;
    }

    public FileInput rootTree() {
        return this.rootTree;
    }

    public PythonFile pythonFile() {
        return this.pythonFile;
    }

    public RecognitionException parsingException() {
        return this.parsingException;
    }

    public void addIssue(PythonCheck.PreciseIssue issue) {
        this.issues.add(issue);
    }

    public List<PythonCheck.PreciseIssue> getIssues() {
        return this.issues;
    }

    @CheckForNull
    public File workingDirectory() {
        return this.workingDirectory;
    }
}

