/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;

@Rule(key="S1462")
public class HardcodedEventNameCheck
extends FlexCheck {
    private static final Pattern STRING_PATTERN = Pattern.compile("(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')");
    private static final State[][] TRANSITIONS = new State[State.values().length][Symbol.values().length];
    private State currentState;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.emptyList();
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        this.currentState = State.EXPECTING_ADD_EVENT;
    }

    @Override
    public void visitToken(Token token) {
        this.currentState = TRANSITIONS[this.currentState.ordinal()][HardcodedEventNameCheck.getSymbol(token.getValue()).ordinal()];
        if (this.currentState == State.FOUND_ISSUE) {
            this.addIssue(MessageFormat.format("The event name {0} should be defined in a constant variable.", token.getValue()), token);
            this.currentState = State.EXPECTING_ADD_EVENT;
        }
    }

    private static Symbol getSymbol(String value) {
        Symbol result = Symbol.OTHER;
        if ("(".equals(value)) {
            result = Symbol.BRACE;
        } else if ("addEventListener".equals(value)) {
            result = Symbol.ADD_EVENT;
        } else if (STRING_PATTERN.matcher(value).matches()) {
            result = Symbol.STRING;
        }
        return result;
    }

    static {
        for (int i = 0; i < TRANSITIONS.length; ++i) {
            for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                HardcodedEventNameCheck.TRANSITIONS[i][j] = State.EXPECTING_ADD_EVENT;
            }
        }
        HardcodedEventNameCheck.TRANSITIONS[State.EXPECTING_ADD_EVENT.ordinal()][Symbol.ADD_EVENT.ordinal()] = State.EXPECTING_BRACE;
        HardcodedEventNameCheck.TRANSITIONS[State.EXPECTING_BRACE.ordinal()][Symbol.BRACE.ordinal()] = State.EXPECTING_STRING;
        HardcodedEventNameCheck.TRANSITIONS[State.EXPECTING_STRING.ordinal()][Symbol.STRING.ordinal()] = State.FOUND_ISSUE;
    }

    private static enum Symbol {
        OTHER,
        ADD_EVENT,
        BRACE,
        STRING;

    }

    private static enum State {
        EXPECTING_ADD_EVENT,
        EXPECTING_BRACE,
        EXPECTING_STRING,
        FOUND_ISSUE;

    }
}

