/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.whitespace;

import java.io.IOException;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;

@Rule(key="IllegalTabCheck")
public class IllegalTabCheck
extends AbstractPageCheck {
    @Override
    public void startDocument(List<Node> nodes) {
        String content;
        try {
            content = this.getHtmlSourceCode().inputFile().contents();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        String[] lines = content.split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].contains("\t")) continue;
            this.createViolation(i + 1, "Replace all tab characters in this file by sequences of white-spaces.");
            break;
        }
    }
}

