/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SparseFixedBitSet;
import org.elasticsearch.Assertions;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.AutoCreateAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.IngestActionForwarder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.update.TransportUpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportBulkAction
extends HandledTransportAction<BulkRequest, BulkResponse> {
    private static final Logger logger = LogManager.getLogger(TransportBulkAction.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IngestService ingestService;
    private final TransportShardBulkAction shardBulkAction;
    private final LongSupplier relativeTimeProvider;
    private final IngestActionForwarder ingestForwarder;
    private final NodeClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private static final String DROPPED_ITEM_WITH_AUTO_GENERATED_ID = "auto-generated";
    private final IndexingPressure indexingPressure;
    private final SystemIndices systemIndices;

    @Inject
    public TransportBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, TransportShardBulkAction shardBulkAction, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices) {
        this(threadPool, transportService, clusterService, ingestService, shardBulkAction, client, actionFilters, indexNameExpressionResolver, indexingPressure, systemIndices, System::nanoTime);
    }

    public TransportBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, TransportShardBulkAction shardBulkAction, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices, LongSupplier relativeTimeProvider) {
        super("indices:data/write/bulk", transportService, actionFilters, BulkRequest::new, "same");
        Objects.requireNonNull(relativeTimeProvider);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.ingestService = ingestService;
        this.shardBulkAction = shardBulkAction;
        this.relativeTimeProvider = relativeTimeProvider;
        this.ingestForwarder = new IngestActionForwarder(transportService);
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indexingPressure = indexingPressure;
        this.systemIndices = systemIndices;
        clusterService.addStateApplier(this.ingestForwarder);
    }

    public static IndexRequest getIndexWriteRequest(DocWriteRequest<?> docWriteRequest) {
        IndexRequest indexRequest = null;
        if (docWriteRequest instanceof IndexRequest) {
            indexRequest = (IndexRequest)docWriteRequest;
        } else if (docWriteRequest instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)docWriteRequest;
            indexRequest = updateRequest.docAsUpsert() ? updateRequest.doc() : updateRequest.upsertRequest();
        }
        return indexRequest;
    }

    @Override
    protected void doExecute(Task task, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        long indexingBytes = bulkRequest.ramBytesUsed();
        boolean isOnlySystem = this.isOnlySystem(bulkRequest, this.clusterService.state().metadata().getIndicesLookup(), this.systemIndices);
        Releasable releasable = this.indexingPressure.markCoordinatingOperationStarted(indexingBytes, isOnlySystem);
        ActionListener<BulkResponse> releasingListener = ActionListener.runBefore(listener, () -> ((Releasable)releasable).close());
        String executorName = isOnlySystem ? "system_write" : "write";
        try {
            this.doInternalExecute(task, bulkRequest, executorName, releasingListener);
        }
        catch (Exception e) {
            releasingListener.onFailure(e);
        }
    }

    protected void doInternalExecute(final Task task, final BulkRequest bulkRequest, final String executorName, final ActionListener<BulkResponse> listener) {
        final long startTime = this.relativeTime();
        final AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        boolean hasIndexRequestsWithPipelines = false;
        Metadata metadata = this.clusterService.state().getMetadata();
        Version minNodeVersion = this.clusterService.state().getNodes().getMinNodeVersion();
        for (DocWriteRequest<?> actionRequest : bulkRequest.requests) {
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(actionRequest);
            if (indexRequest != null) {
                boolean indexRequestHasPipeline = IngestService.resolvePipelines(actionRequest, indexRequest, metadata);
                hasIndexRequestsWithPipelines |= indexRequestHasPipeline;
            }
            if (!(actionRequest instanceof IndexRequest)) continue;
            IndexRequest ir = (IndexRequest)actionRequest;
            ir.checkAutoIdWithOpTypeCreateSupportedByVersion(minNodeVersion);
            if (ir.getAutoGeneratedTimestamp() == -1L) continue;
            throw new IllegalArgumentException("autoGeneratedTimestamp should not be set externally");
        }
        if (hasIndexRequestsWithPipelines) {
            try {
                if (Assertions.ENABLED) {
                    boolean arePipelinesResolved = bulkRequest.requests().stream().map(TransportBulkAction::getIndexWriteRequest).filter(Objects::nonNull).allMatch(IndexRequest::isPipelineResolved);
                    assert (arePipelinesResolved) : bulkRequest;
                }
                if (this.clusterService.localNode().isIngestNode()) {
                    this.processBulkIndexIngestRequest(task, bulkRequest, executorName, listener);
                } else {
                    this.ingestForwarder.forwardIngestRequest(BulkAction.INSTANCE, bulkRequest, listener);
                }
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            return;
        }
        Map<String, Boolean> indices = bulkRequest.requests.stream().filter(request -> request.opType() != DocWriteRequest.OpType.DELETE || request.versionType() == VersionType.EXTERNAL || request.versionType() == VersionType.EXTERNAL_GTE).collect(Collectors.toMap(DocWriteRequest::index, DocWriteRequest::isRequireAlias, (v1, v2) -> v1 != false || v2 != false));
        final HashMap<String, IndexNotFoundException> indicesThatCannotBeCreated = new HashMap<String, IndexNotFoundException>();
        HashSet<String> autoCreateIndices = new HashSet<String>();
        ClusterState state = this.clusterService.state();
        for (Map.Entry<String, Boolean> indexAndFlag : indices.entrySet()) {
            final String index = indexAndFlag.getKey();
            boolean shouldAutoCreate = !this.indexNameExpressionResolver.hasIndexAbstraction(index, state);
            if (!shouldAutoCreate || indexAndFlag.getValue().booleanValue()) continue;
            autoCreateIndices.add(index);
        }
        if (autoCreateIndices.isEmpty()) {
            this.executeBulk(task, bulkRequest, startTime, listener, responses, indicesThatCannotBeCreated);
        } else {
            final AtomicInteger counter = new AtomicInteger(autoCreateIndices.size());
            for (final String index : autoCreateIndices) {
                this.createIndex(index, bulkRequest.timeout(), minNodeVersion, new ActionListener<CreateIndexResponse>(){

                    @Override
                    public void onResponse(CreateIndexResponse result) {
                        if (counter.decrementAndGet() == 0) {
                            TransportBulkAction.this.threadPool.executor(executorName).execute(new ActionRunnable<BulkResponse>(listener){

                                @Override
                                protected void doRun() {
                                    TransportBulkAction.this.executeBulk(task, bulkRequest, startTime, this.listener, responses, indicesThatCannotBeCreated);
                                }
                            });
                        }
                    }

                    @Override
                    public void onFailure(final Exception e) {
                        Throwable cause = ExceptionsHelper.unwrapCause(e);
                        if (cause instanceof IndexNotFoundException) {
                            indicesThatCannotBeCreated.put(index, (IndexNotFoundException)cause);
                        } else if (!(cause instanceof ResourceAlreadyExistsException)) {
                            for (int i = 0; i < bulkRequest.requests.size(); ++i) {
                                DocWriteRequest<?> request = bulkRequest.requests.get(i);
                                if (request == null || !TransportBulkAction.this.setResponseFailureIfIndexMatches(responses, i, request, index, e)) continue;
                                bulkRequest.requests.set(i, null);
                            }
                        }
                        if (counter.decrementAndGet() == 0) {
                            final ActionListener wrappedListener = ActionListener.wrap(listener::onResponse, inner -> {
                                inner.addSuppressed(e);
                                listener.onFailure((Exception)inner);
                            });
                            TransportBulkAction.this.threadPool.executor(executorName).execute(new ActionRunnable<BulkResponse>(wrappedListener){

                                @Override
                                protected void doRun() {
                                    TransportBulkAction.this.executeBulk(task, bulkRequest, startTime, wrappedListener, responses, indicesThatCannotBeCreated);
                                }

                                @Override
                                public void onRejection(Exception rejectedException) {
                                    rejectedException.addSuppressed(e);
                                    super.onRejection(rejectedException);
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    static void prohibitAppendWritesInBackingIndices(DocWriteRequest<?> writeRequest, Metadata metadata) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(writeRequest.index());
        if (indexAbstraction == null) {
            return;
        }
        if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
            return;
        }
        if (indexAbstraction.getParentDataStream() == null) {
            return;
        }
        DataStream dataStream = indexAbstraction.getParentDataStream().getDataStream();
        DocWriteRequest.OpType opType = writeRequest.opType();
        if (opType == DocWriteRequest.OpType.CREATE) {
            throw new IllegalArgumentException("index request with op_type=create targeting backing indices is disallowed, target corresponding data stream [" + dataStream.getName() + "] instead");
        }
        if (opType == DocWriteRequest.OpType.INDEX && writeRequest.ifPrimaryTerm() == 0L && writeRequest.ifSeqNo() == -2L) {
            throw new IllegalArgumentException("index request with op_type=index and no if_primary_term and if_seq_no set targeting backing indices is disallowed, target corresponding data stream [" + dataStream.getName() + "] instead");
        }
    }

    static void prohibitCustomRoutingOnDataStream(DocWriteRequest<?> writeRequest, Metadata metadata) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(writeRequest.index());
        if (indexAbstraction == null) {
            return;
        }
        if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) {
            return;
        }
        if (writeRequest.routing() != null) {
            IndexAbstraction.DataStream dataStream = (IndexAbstraction.DataStream)indexAbstraction;
            throw new IllegalArgumentException("index request targeting data stream [" + dataStream.getName() + "] specifies a custom routing. target the backing indices directly or remove the custom routing.");
        }
    }

    boolean isOnlySystem(BulkRequest request, SortedMap<String, IndexAbstraction> indicesLookup, SystemIndices systemIndices) {
        return request.getIndices().stream().allMatch(indexName -> this.isSystemIndex(indicesLookup, systemIndices, (String)indexName));
    }

    private boolean isSystemIndex(SortedMap<String, IndexAbstraction> indicesLookup, SystemIndices systemIndices, String indexName) {
        IndexAbstraction abstraction = (IndexAbstraction)indicesLookup.get(indexName);
        if (abstraction != null) {
            return abstraction.isSystem();
        }
        return systemIndices.isSystemIndex(indexName);
    }

    void createIndex(String index, TimeValue timeout, Version minNodeVersion, ActionListener<CreateIndexResponse> listener) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest();
        createIndexRequest.index(index);
        createIndexRequest.cause("auto(bulk api)");
        createIndexRequest.masterNodeTimeout(timeout);
        if (minNodeVersion.onOrAfter(Version.V_7_8_0)) {
            this.client.execute(AutoCreateAction.INSTANCE, createIndexRequest, listener);
        } else {
            this.client.admin().indices().create(createIndexRequest, listener);
        }
    }

    private boolean setResponseFailureIfIndexMatches(AtomicArray<BulkItemResponse> responses, int idx, DocWriteRequest<?> request, String index, Exception e) {
        if (index.equals(request.index())) {
            responses.set(idx, new BulkItemResponse(idx, request.opType(), new BulkItemResponse.Failure(request.index(), request.type(), request.id(), e)));
            return true;
        }
        return false;
    }

    private long buildTookInMillis(long startTimeNanos) {
        return TimeUnit.NANOSECONDS.toMillis(this.relativeTime() - startTimeNanos);
    }

    void executeBulk(Task task, BulkRequest bulkRequest, long startTimeNanos, ActionListener<BulkResponse> listener, AtomicArray<BulkItemResponse> responses, Map<String, IndexNotFoundException> indicesThatCannotBeCreated) {
        new BulkOperation(task, bulkRequest, listener, responses, startTimeNanos, indicesThatCannotBeCreated).run();
    }

    private long relativeTime() {
        return this.relativeTimeProvider.getAsLong();
    }

    private void processBulkIndexIngestRequest(final Task task, BulkRequest original, final String executorName, ActionListener<BulkResponse> listener) {
        long ingestStartTimeInNanos = System.nanoTime();
        BulkRequestModifier bulkRequestModifier = new BulkRequestModifier(original);
        this.ingestService.executeBulkRequest(original.numberOfActions(), () -> bulkRequestModifier, bulkRequestModifier::markItemAsFailed, (originalThread, exception) -> {
            if (exception != null) {
                logger.debug("failed to execute pipeline for a bulk request", (Throwable)exception);
                listener.onFailure((Exception)exception);
            } else {
                long ingestTookInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - ingestStartTimeInNanos);
                final BulkRequest bulkRequest = bulkRequestModifier.getBulkRequest();
                final ActionListener<BulkResponse> actionListener = bulkRequestModifier.wrapActionListenerIfNeeded(ingestTookInMillis, listener);
                if (bulkRequest.requests().isEmpty()) {
                    actionListener.onResponse(new BulkResponse(new BulkItemResponse[0], 0L));
                } else if (originalThread == Thread.currentThread()) {
                    assert (Thread.currentThread().getName().contains(executorName));
                    this.doInternalExecute(task, bulkRequest, executorName, actionListener);
                } else {
                    this.threadPool.executor(executorName).execute(new ActionRunnable<BulkResponse>(listener){

                        @Override
                        protected void doRun() {
                            TransportBulkAction.this.doInternalExecute(task, bulkRequest, executorName, actionListener);
                        }

                        @Override
                        public boolean isForceExecution() {
                            return true;
                        }
                    });
                }
            }
        }, bulkRequestModifier::markItemAsDropped, executorName);
    }

    private final class BulkOperation
    extends ActionRunnable<BulkResponse> {
        private final Task task;
        private BulkRequest bulkRequest;
        private final AtomicArray<BulkItemResponse> responses;
        private final long startTimeNanos;
        private final ClusterStateObserver observer;
        private final Map<String, IndexNotFoundException> indicesThatCannotBeCreated;

        BulkOperation(Task task, BulkRequest bulkRequest, ActionListener<BulkResponse> listener, AtomicArray<BulkItemResponse> responses, long startTimeNanos, Map<String, IndexNotFoundException> indicesThatCannotBeCreated) {
            super(listener);
            this.task = task;
            this.bulkRequest = bulkRequest;
            this.responses = responses;
            this.startTimeNanos = startTimeNanos;
            this.indicesThatCannotBeCreated = indicesThatCannotBeCreated;
            this.observer = new ClusterStateObserver(TransportBulkAction.this.clusterService, bulkRequest.timeout(), logger, TransportBulkAction.this.threadPool.getThreadContext());
        }

        @Override
        protected void doRun() {
            ShardId shardId;
            assert (this.bulkRequest != null);
            ClusterState clusterState = this.observer.setAndGetObservedState();
            if (this.handleBlockExceptions(clusterState)) {
                return;
            }
            final ConcreteIndices concreteIndices = new ConcreteIndices(clusterState, TransportBulkAction.this.indexNameExpressionResolver);
            Metadata metadata = clusterState.metadata();
            HashMap<ShardId, List> requestsByShard = new HashMap<ShardId, List>();
            for (int i = 0; i < this.bulkRequest.requests.size(); ++i) {
                DocWriteRequest<?> docWriteRequest = this.bulkRequest.requests.get(i);
                if (docWriteRequest == null || this.addFailureIfRequiresAliasAndAliasIsMissing(docWriteRequest, i, metadata) || this.addFailureIfIndexIsUnavailable(docWriteRequest, i, concreteIndices, metadata)) continue;
                Index concreteIndex = concreteIndices.resolveIfAbsent(docWriteRequest);
                try {
                    IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(concreteIndex.getName());
                    if (indexAbstraction.getParentDataStream() != null && !concreteIndex.getName().equals(docWriteRequest.index()) && docWriteRequest.opType() != DocWriteRequest.OpType.CREATE) {
                        throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams");
                    }
                    switch (docWriteRequest.opType()) {
                        case CREATE: 
                        case INDEX: {
                            TransportBulkAction.prohibitAppendWritesInBackingIndices(docWriteRequest, metadata);
                            TransportBulkAction.prohibitCustomRoutingOnDataStream(docWriteRequest, metadata);
                            IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                            IndexMetadata indexMetadata = metadata.index(concreteIndex);
                            MappingMetadata mappingMd = indexMetadata.mappingOrDefault();
                            Version indexCreated = indexMetadata.getCreationVersion();
                            indexRequest.resolveRouting(metadata);
                            indexRequest.process(indexCreated, mappingMd, concreteIndex.getName());
                            break;
                        }
                        case UPDATE: {
                            TransportUpdateAction.resolveAndValidateRouting(metadata, concreteIndex.getName(), (UpdateRequest)docWriteRequest);
                            break;
                        }
                        case DELETE: {
                            docWriteRequest.routing(metadata.resolveWriteIndexRouting(docWriteRequest.routing(), docWriteRequest.index()));
                            if (docWriteRequest.routing() != null || !metadata.routingRequired(concreteIndex.getName())) break;
                            throw new RoutingMissingException(concreteIndex.getName(), docWriteRequest.type(), docWriteRequest.id());
                        }
                        default: {
                            throw new AssertionError((Object)("request type not supported: [" + (Object)((Object)docWriteRequest.opType()) + "]"));
                        }
                    }
                    shardId = TransportBulkAction.this.clusterService.operationRouting().indexShards(clusterState, concreteIndex.getName(), docWriteRequest.id(), docWriteRequest.routing()).shardId();
                    List shardRequests = requestsByShard.computeIfAbsent(shardId, shard -> new ArrayList());
                    shardRequests.add(new BulkItemRequest(i, docWriteRequest));
                    continue;
                }
                catch (IllegalArgumentException | ElasticsearchParseException | RoutingMissingException e) {
                    BulkItemResponse.Failure failure = new BulkItemResponse.Failure(concreteIndex.getName(), docWriteRequest.type(), docWriteRequest.id(), e);
                    BulkItemResponse bulkItemResponse = new BulkItemResponse(i, docWriteRequest.opType(), failure);
                    this.responses.set(i, bulkItemResponse);
                    this.bulkRequest.requests.set(i, null);
                }
            }
            if (requestsByShard.isEmpty()) {
                this.listener.onResponse(new BulkResponse(this.responses.toArray((BulkItemResponse[])new BulkItemResponse[this.responses.length()]), TransportBulkAction.this.buildTookInMillis(this.startTimeNanos)));
                return;
            }
            final AtomicInteger counter = new AtomicInteger(requestsByShard.size());
            String nodeId = TransportBulkAction.this.clusterService.localNode().getId();
            for (Map.Entry entry : requestsByShard.entrySet()) {
                shardId = (ShardId)entry.getKey();
                final List requests = (List)entry.getValue();
                BulkShardRequest bulkShardRequest = new BulkShardRequest(shardId, this.bulkRequest.getRefreshPolicy(), requests.toArray(new BulkItemRequest[requests.size()]));
                bulkShardRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
                bulkShardRequest.timeout(this.bulkRequest.timeout());
                bulkShardRequest.routedBasedOnClusterVersion(clusterState.version());
                if (this.task != null) {
                    bulkShardRequest.setParentTask(nodeId, this.task.getId());
                }
                TransportBulkAction.this.shardBulkAction.execute(bulkShardRequest, new ActionListener<BulkShardResponse>(){

                    @Override
                    public void onResponse(BulkShardResponse bulkShardResponse) {
                        for (BulkItemResponse bulkItemResponse : bulkShardResponse.getResponses()) {
                            if (bulkItemResponse.getResponse() != null) {
                                ((ReplicationResponse)bulkItemResponse.getResponse()).setShardInfo(bulkShardResponse.getShardInfo());
                            }
                            BulkOperation.this.responses.set(bulkItemResponse.getItemId(), bulkItemResponse);
                        }
                        if (counter.decrementAndGet() == 0) {
                            this.finishHim();
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        for (BulkItemRequest request : requests) {
                            String indexName = concreteIndices.getConcreteIndex(request.index()).getName();
                            DocWriteRequest<?> docWriteRequest = request.request();
                            BulkOperation.this.responses.set(request.id(), new BulkItemResponse(request.id(), docWriteRequest.opType(), new BulkItemResponse.Failure(indexName, docWriteRequest.type(), docWriteRequest.id(), e)));
                        }
                        if (counter.decrementAndGet() == 0) {
                            this.finishHim();
                        }
                    }

                    private void finishHim() {
                        BulkOperation.this.listener.onResponse(new BulkResponse(BulkOperation.this.responses.toArray(new BulkItemResponse[BulkOperation.this.responses.length()]), TransportBulkAction.this.buildTookInMillis(BulkOperation.this.startTimeNanos)));
                    }
                });
            }
            this.bulkRequest = null;
        }

        private boolean handleBlockExceptions(ClusterState state) {
            ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
            if (blockException != null) {
                if (blockException.retryable()) {
                    logger.trace("cluster is blocked, scheduling a retry", (Throwable)blockException);
                    this.retry(blockException);
                } else {
                    this.onFailure(blockException);
                }
                return true;
            }
            return false;
        }

        void retry(Exception failure) {
            assert (failure != null);
            if (this.observer.isTimedOut()) {
                this.onFailure(failure);
                return;
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    BulkOperation.this.run();
                }

                @Override
                public void onClusterServiceClose() {
                    BulkOperation.this.onFailure(new NodeClosedException(TransportBulkAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    BulkOperation.this.run();
                }
            });
        }

        private boolean addFailureIfRequiresAliasAndAliasIsMissing(DocWriteRequest<?> request, int idx, Metadata metadata) {
            if (request.isRequireAlias() && !metadata.hasAlias(request.index())) {
                IndexNotFoundException exception = new IndexNotFoundException("[require_alias] request flag is [true] and [" + request.index() + "] is not an alias", request.index());
                this.addFailure(request, idx, exception);
                return true;
            }
            return false;
        }

        private boolean addFailureIfIndexIsUnavailable(DocWriteRequest<?> request, int idx, ConcreteIndices concreteIndices, Metadata metadata) {
            IndexMetadata indexMetadata;
            IndexNotFoundException cannotCreate = this.indicesThatCannotBeCreated.get(request.index());
            if (cannotCreate != null) {
                this.addFailure(request, idx, cannotCreate);
                return true;
            }
            Index concreteIndex = concreteIndices.getConcreteIndex(request.index());
            if (concreteIndex == null) {
                try {
                    concreteIndex = concreteIndices.resolveIfAbsent(request);
                }
                catch (IllegalArgumentException | IndexNotFoundException | IndexClosedException ex) {
                    this.addFailure(request, idx, ex);
                    return true;
                }
            }
            if ((indexMetadata = metadata.getIndexSafe(concreteIndex)).getState() == IndexMetadata.State.CLOSE) {
                this.addFailure(request, idx, new IndexClosedException(concreteIndex));
                return true;
            }
            return false;
        }

        private void addFailure(DocWriteRequest<?> request, int idx, Exception unavailableException) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(request.index(), request.type(), request.id(), unavailableException);
            BulkItemResponse bulkItemResponse = new BulkItemResponse(idx, request.opType(), failure);
            this.responses.set(idx, bulkItemResponse);
            this.bulkRequest.requests.set(idx, null);
        }
    }

    static final class BulkRequestModifier
    implements Iterator<DocWriteRequest<?>> {
        final BulkRequest bulkRequest;
        final SparseFixedBitSet failedSlots;
        final List<BulkItemResponse> itemResponses;
        final AtomicIntegerArray originalSlots;
        volatile int currentSlot = -1;

        BulkRequestModifier(BulkRequest bulkRequest) {
            this.bulkRequest = bulkRequest;
            this.failedSlots = new SparseFixedBitSet(bulkRequest.requests().size());
            this.itemResponses = new ArrayList<BulkItemResponse>(bulkRequest.requests().size());
            this.originalSlots = new AtomicIntegerArray(bulkRequest.requests().size());
        }

        @Override
        public DocWriteRequest<?> next() {
            return this.bulkRequest.requests().get(++this.currentSlot);
        }

        @Override
        public boolean hasNext() {
            return this.currentSlot + 1 < this.bulkRequest.requests().size();
        }

        BulkRequest getBulkRequest() {
            if (this.itemResponses.isEmpty()) {
                return this.bulkRequest;
            }
            BulkRequest modifiedBulkRequest = new BulkRequest();
            modifiedBulkRequest.setRefreshPolicy(this.bulkRequest.getRefreshPolicy());
            modifiedBulkRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
            modifiedBulkRequest.timeout(this.bulkRequest.timeout());
            int slot = 0;
            List<DocWriteRequest<?>> requests = this.bulkRequest.requests();
            for (int i = 0; i < requests.size(); ++i) {
                DocWriteRequest<?> request = requests.get(i);
                if (this.failedSlots.get(i)) continue;
                modifiedBulkRequest.add(request);
                this.originalSlots.set(slot++, i);
            }
            return modifiedBulkRequest;
        }

        ActionListener<BulkResponse> wrapActionListenerIfNeeded(long ingestTookInMillis, ActionListener<BulkResponse> actionListener) {
            if (this.itemResponses.isEmpty()) {
                return actionListener.map(response -> new BulkResponse(response.getItems(), response.getTook().getMillis(), ingestTookInMillis));
            }
            return actionListener.map(response -> {
                BulkItemResponse[] items = response.getItems();
                for (int i = 0; i < items.length; ++i) {
                    this.itemResponses.add(this.originalSlots.get(i), response.getItems()[i]);
                }
                return new BulkResponse(this.itemResponses.toArray(new BulkItemResponse[0]), response.getTook().getMillis(), ingestTookInMillis);
            });
        }

        synchronized void markItemAsDropped(int slot) {
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(this.bulkRequest.requests().get(slot));
            this.failedSlots.set(slot);
            String id = indexRequest.id() == null ? TransportBulkAction.DROPPED_ITEM_WITH_AUTO_GENERATED_ID : indexRequest.id();
            this.itemResponses.add(new BulkItemResponse(slot, indexRequest.opType(), new UpdateResponse(new ShardId(indexRequest.index(), "_na_", 0), indexRequest.type(), id, -2L, 0L, indexRequest.version(), DocWriteResponse.Result.NOOP)));
        }

        synchronized void markItemAsFailed(int slot, Exception e) {
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(this.bulkRequest.requests().get(slot));
            logger.debug(String.format(Locale.ROOT, "failed to execute pipeline [%s] for document [%s/%s/%s]", indexRequest.getPipeline(), indexRequest.index(), indexRequest.type(), indexRequest.id()), (Throwable)e);
            this.failedSlots.set(slot);
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), e);
            this.itemResponses.add(new BulkItemResponse(slot, indexRequest.opType(), failure));
        }
    }

    private static class ConcreteIndices {
        private final ClusterState state;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final Map<String, Index> indices = new HashMap<String, Index>();

        ConcreteIndices(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver) {
            this.state = state;
            this.indexNameExpressionResolver = indexNameExpressionResolver;
        }

        Index getConcreteIndex(String indexOrAlias) {
            return this.indices.get(indexOrAlias);
        }

        Index resolveIfAbsent(DocWriteRequest<?> request) {
            Index concreteIndex = this.indices.get(request.index());
            if (concreteIndex == null) {
                boolean includeDataStreams = request.opType() == DocWriteRequest.OpType.CREATE;
                try {
                    concreteIndex = this.indexNameExpressionResolver.concreteWriteIndex(this.state, request.indicesOptions(), request.indices()[0], false, includeDataStreams);
                }
                catch (IndexNotFoundException e) {
                    if (!includeDataStreams && e.getMetadataKeys().contains("es.excluded_ds")) {
                        throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams");
                    }
                    throw e;
                }
                this.indices.put(request.index(), concreteIndex);
            }
            return concreteIndex;
        }
    }
}

