/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.IntervalFilterScript;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.script.BooleanFieldScript;
import org.elasticsearch.script.BucketAggregationScript;
import org.elasticsearch.script.BucketAggregationSelectorScript;
import org.elasticsearch.script.DateFieldScript;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.FieldScript;
import org.elasticsearch.script.FilterScript;
import org.elasticsearch.script.GeoPointFieldScript;
import org.elasticsearch.script.IngestConditionalScript;
import org.elasticsearch.script.IngestScript;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.LongFieldScript;
import org.elasticsearch.script.NumberSortScript;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptedMetricAggContexts;
import org.elasticsearch.script.SignificantTermsHeuristicScoreScript;
import org.elasticsearch.script.SimilarityScript;
import org.elasticsearch.script.SimilarityWeightScript;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.script.StringSortScript;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.script.TermsSetQueryScript;
import org.elasticsearch.script.UpdateScript;
import org.elasticsearch.search.aggregations.pipeline.MovingFunctionScript;

public class ScriptModule {
    public static final Set<ScriptContext<?>> RUNTIME_FIELDS_CONTEXTS = org.elasticsearch.common.collect.Set.of((Object[])new ScriptContext[]{BooleanFieldScript.CONTEXT, DateFieldScript.CONTEXT, DoubleFieldScript.CONTEXT, LongFieldScript.CONTEXT, StringFieldScript.CONTEXT, GeoPointFieldScript.CONTEXT, IpFieldScript.CONTEXT});
    public static final Map<String, ScriptContext<?>> CORE_CONTEXTS = Stream.concat(Stream.of(FieldScript.CONTEXT, AggregationScript.CONTEXT, ScoreScript.CONTEXT, NumberSortScript.CONTEXT, StringSortScript.CONTEXT, TermsSetQueryScript.CONTEXT, UpdateScript.CONTEXT, BucketAggregationScript.CONTEXT, BucketAggregationSelectorScript.CONTEXT, SignificantTermsHeuristicScoreScript.CONTEXT, IngestScript.CONTEXT, IngestConditionalScript.CONTEXT, FilterScript.CONTEXT, SimilarityScript.CONTEXT, SimilarityWeightScript.CONTEXT, TemplateScript.CONTEXT, TemplateScript.INGEST_CONTEXT, MovingFunctionScript.CONTEXT, ScriptedMetricAggContexts.InitScript.CONTEXT, ScriptedMetricAggContexts.MapScript.CONTEXT, ScriptedMetricAggContexts.CombineScript.CONTEXT, ScriptedMetricAggContexts.ReduceScript.CONTEXT, IntervalFilterScript.CONTEXT), RUNTIME_FIELDS_CONTEXTS.stream()).collect(Collectors.toMap(c -> c.name, Function.identity()));
    public final Map<String, ScriptEngine> engines;
    public final Map<String, ScriptContext<?>> contexts;

    public ScriptModule(Settings settings, List<ScriptPlugin> scriptPlugins) {
        HashMap<String, ScriptEngine> engines = new HashMap<String, ScriptEngine>();
        HashMap contexts = new HashMap(CORE_CONTEXTS);
        for (ScriptPlugin plugin : scriptPlugins) {
            for (ScriptContext<?> context : plugin.getContexts()) {
                ScriptContext<?> oldContext = contexts.put(context.name, context);
                if (oldContext == null) continue;
                throw new IllegalArgumentException("Context name [" + context.name + "] defined twice");
            }
        }
        for (ScriptPlugin plugin : scriptPlugins) {
            ScriptEngine existing;
            ScriptEngine engine = plugin.getScriptEngine(settings, contexts.values());
            if (engine == null || (existing = engines.put(engine.getType(), engine)) == null) continue;
            throw new IllegalArgumentException("scripting language [" + engine.getType() + "] defined for engine [" + existing.getClass().getName() + "] and [" + engine.getClass().getName());
        }
        this.engines = Collections.unmodifiableMap(engines);
        this.contexts = Collections.unmodifiableMap(contexts);
    }

    public void registerClusterSettingsListeners(ScriptService scriptService, ClusterSettings clusterSettings) {
        scriptService.registerClusterSettingsListeners(clusterSettings);
    }
}

