/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.DocCountProvider;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilters;
import org.elasticsearch.search.aggregations.bucket.filter.QueryToFilterAdapter;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class FiltersAggregator
extends BucketsAggregator {
    public static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    public static final ParseField OTHER_BUCKET_FIELD = new ParseField("other_bucket", new String[0]);
    public static final ParseField OTHER_BUCKET_KEY_FIELD = new ParseField("other_bucket_key", new String[0]);
    private final List<QueryToFilterAdapter<?>> filters;
    private final boolean keyed;
    protected final String otherBucketKey;

    public static FiltersAggregator build(String name, AggregatorFactories factories, List<QueryToFilterAdapter<?>> filters, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        FilterByFilter filterByFilter;
        if (FiltersAggregator.canUseFilterByFilter(parent, otherBucketKey) && !(filterByFilter = FiltersAggregator.buildFilterByFilter(name, factories, filters, keyed, otherBucketKey, context, parent, cardinality, metadata)).scoreMode().needsScores()) {
            return filterByFilter;
        }
        return new Compatible(name, factories, filters, keyed, otherBucketKey, context, parent, cardinality, metadata);
    }

    public static boolean canUseFilterByFilter(Aggregator parent, String otherBucketKey) {
        return parent == null && otherBucketKey == null;
    }

    public static FilterByFilter buildFilterByFilter(String name, AggregatorFactories factories, List<QueryToFilterAdapter<?>> filters, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (!FiltersAggregator.canUseFilterByFilter(parent, otherBucketKey)) {
            throw new IllegalStateException("Can't execute filter-by-filter");
        }
        ArrayList filtersWithTopLevel = new ArrayList(filters.size());
        for (QueryToFilterAdapter<?> f : filters) {
            filtersWithTopLevel.add(f.union(context.query()));
        }
        return new FilterByFilter(name, factories, filtersWithTopLevel, keyed, context, parent, cardinality, metadata);
    }

    private FiltersAggregator(String name, AggregatorFactories factories, List<QueryToFilterAdapter<?>> filters, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality.multiply(filters.size() + (otherBucketKey == null ? 0 : 1)), metadata);
        this.filters = org.elasticsearch.common.collect.List.copyOf(filters);
        this.keyed = keyed;
        this.otherBucketKey = otherBucketKey;
    }

    List<QueryToFilterAdapter<?>> filters() {
        return this.filters;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForFixedBucketCount(owningBucketOrds, this.filters.size() + (this.otherBucketKey == null ? 0 : 1), (offsetInOwningOrd, docCount, subAggregationResults) -> {
            if (offsetInOwningOrd < this.filters.size()) {
                return new InternalFilters.InternalBucket(this.filters.get(offsetInOwningOrd).key().toString(), docCount, subAggregationResults, this.keyed);
            }
            return new InternalFilters.InternalBucket(this.otherBucketKey, docCount, subAggregationResults, this.keyed);
        }, buckets -> new InternalFilters(this.name, (List<InternalFilters.InternalBucket>)buckets, this.keyed, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList<InternalFilters.InternalBucket> buckets = new ArrayList<InternalFilters.InternalBucket>(this.filters.size() + this.otherBucketKey == null ? 0 : 1);
        for (QueryToFilterAdapter<?> filter : this.filters) {
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(filter.key().toString(), 0L, subAggs, this.keyed);
            buckets.add(bucket);
        }
        if (this.otherBucketKey != null) {
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(this.otherBucketKey, 0L, subAggs, this.keyed);
            buckets.add(bucket);
        }
        return new InternalFilters(this.name, buckets, this.keyed, this.metadata());
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        ArrayList filtersDebug = new ArrayList(this.filters.size());
        for (QueryToFilterAdapter<?> filter : this.filters) {
            HashMap debug = new HashMap();
            filter.collectDebugInfo(debug::put);
            filtersDebug.add(debug);
        }
        add.accept("filters", filtersDebug);
    }

    public static class FilterByFilter
    extends FiltersAggregator {
        private final boolean profiling;
        private long estimatedCost = -1L;
        private long maxCost = -1L;
        private long estimateCostTime;
        private int segmentsWithDeletedDocs;
        private int segmentsWithDocCountField;
        private int segmentsCollected;
        private int segmentsCounted;

        private FilterByFilter(String name, AggregatorFactories factories, List<QueryToFilterAdapter<?>> filters, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, factories, filters, keyed, null, context, parent, cardinality, metadata);
            this.profiling = context.profiling();
        }

        public long estimateCost(long maxCost) throws IOException {
            assert (!this.scoreMode().needsScores());
            this.maxCost = maxCost;
            if (this.estimatedCost != -1L) {
                return this.estimatedCost;
            }
            long start = this.profiling ? System.nanoTime() : 0L;
            this.estimatedCost = 0L;
            for (LeafReaderContext ctx : this.searcher().getIndexReader().leaves()) {
                CheckedSupplier<Boolean, IOException> canUseMetadata = this.canUseMetadata(ctx);
                for (QueryToFilterAdapter<?> filter : this.filters()) {
                    this.estimatedCost += this.subAggregators().length > 0 ? filter.estimateCollectCost(ctx) : filter.estimateCountCost(ctx, canUseMetadata);
                    if (this.estimatedCost < 0L) {
                        this.estimatedCost = Long.MAX_VALUE;
                        if (this.profiling && this.estimateCostTime == 0L) {
                            this.estimateCostTime = System.nanoTime() - start;
                        }
                        return this.estimatedCost;
                    }
                    if (this.estimatedCost <= maxCost) continue;
                    if (this.profiling) {
                        if (this.estimateCostTime != 0L) continue;
                        this.estimateCostTime = System.nanoTime() - start;
                        continue;
                    }
                    return this.estimatedCost;
                }
            }
            if (this.profiling && this.estimateCostTime == 0L) {
                this.estimateCostTime = System.nanoTime() - start;
            }
            return this.estimatedCost;
        }

        @Override
        protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
            assert (!this.scoreMode().needsScores());
            if (this.filters().size() == 0) {
                return LeafBucketCollector.NO_OP_COLLECTOR;
            }
            Bits live = ctx.reader().getLiveDocs();
            if (!this.docCountProvider.alwaysOne()) {
                ++this.segmentsWithDocCountField;
            }
            if (this.subAggregators.length == 0) {
                ++this.segmentsCounted;
                this.collectCount(ctx, live);
            } else {
                ++this.segmentsCollected;
                this.collectSubs(ctx, live, sub);
            }
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }

        private void collectCount(LeafReaderContext ctx, Bits live) throws IOException {
            Counter counter = new Counter(this.docCountProvider);
            for (int filterOrd = 0; filterOrd < this.filters().size(); ++filterOrd) {
                this.incrementBucketDocCount(filterOrd, this.filters().get(filterOrd).count(ctx, counter, live));
            }
        }

        private void collectSubs(LeafReaderContext ctx, Bits live, final LeafBucketCollector sub) throws IOException {
            class MatchCollector
            implements LeafCollector {
                LeafBucketCollector subCollector;
                int filterOrd;

                MatchCollector() {
                    this.subCollector = sub;
                }

                public void collect(int docId) throws IOException {
                    FilterByFilter.this.collectBucket(this.subCollector, docId, this.filterOrd);
                }

                public void setScorer(Scorable scorer) throws IOException {
                }
            }
            MatchCollector collector = new MatchCollector();
            this.filters().get(0).collect(ctx, collector, live);
            for (int filterOrd = 1; filterOrd < this.filters().size(); ++filterOrd) {
                collector.subCollector = this.collectableSubAggregators.getLeafCollector(ctx);
                collector.filterOrd = filterOrd;
                this.filters().get(filterOrd).collect(ctx, collector, live);
            }
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("segments_counted", this.segmentsCounted);
            add.accept("segments_collected", this.segmentsCollected);
            add.accept("segments_with_deleted_docs", this.segmentsWithDeletedDocs);
            add.accept("segments_with_doc_count_field", this.segmentsWithDocCountField);
            if (this.estimatedCost != -1L) {
                add.accept("estimated_cost", this.estimatedCost);
                add.accept("max_cost", this.maxCost);
                add.accept("estimate_cost_time", this.estimateCostTime);
            }
        }

        CheckedSupplier<Boolean, IOException> canUseMetadata(final LeafReaderContext ctx) {
            return new CheckedSupplier<Boolean, IOException>(){
                Boolean canUse;

                @Override
                public Boolean get() throws IOException {
                    if (this.canUse == null) {
                        this.canUse = this.canUse();
                    }
                    return this.canUse;
                }

                private boolean canUse() throws IOException {
                    if (ctx.reader().getLiveDocs() != null) {
                        return false;
                    }
                    docCountProvider.setLeafReaderContext(ctx);
                    return docCountProvider.alwaysOne();
                }
            };
        }
    }

    private static class Compatible
    extends FiltersAggregator {
        private final int totalNumKeys;

        Compatible(String name, AggregatorFactories factories, List<QueryToFilterAdapter<?>> filters, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, factories, filters, keyed, otherBucketKey, context, parent, cardinality, metadata);
            this.totalNumKeys = otherBucketKey == null ? filters.size() : filters.size() + 1;
        }

        @Override
        protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
            final IntPredicate[] docFilters = new IntPredicate[this.filters().size()];
            for (int filterOrd = 0; filterOrd < this.filters().size(); ++filterOrd) {
                docFilters[filterOrd] = this.filters().get(filterOrd).matchingDocIds(ctx);
            }
            return new LeafBucketCollectorBase(sub, null){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    boolean matched = false;
                    for (int i = 0; i < docFilters.length; ++i) {
                        if (!docFilters[i].test(doc)) continue;
                        this.collectBucket(sub, doc, this.bucketOrd(bucket, i));
                        matched = true;
                    }
                    if (otherBucketKey != null && !matched) {
                        this.collectBucket(sub, doc, this.bucketOrd(bucket, docFilters.length));
                    }
                }
            };
        }

        final long bucketOrd(long owningBucketOrdinal, int filterOrd) {
            return owningBucketOrdinal * (long)this.totalNumKeys + (long)filterOrd;
        }
    }

    static class Counter
    implements LeafCollector {
        final DocCountProvider docCount;
        private long count;

        Counter(DocCountProvider docCount) {
            this.docCount = docCount;
        }

        public long readAndReset(LeafReaderContext ctx) throws IOException {
            long result = this.count;
            this.count = 0L;
            this.docCount.setLeafReaderContext(ctx);
            return result;
        }

        public void collect(int doc) throws IOException {
            this.count += (long)this.docCount.getDocCount(doc);
        }

        public void setScorer(Scorable scorer) throws IOException {
        }
    }

    public static class KeyedFilter
    implements Writeable,
    ToXContentFragment {
        private final String key;
        private final QueryBuilder filter;

        public KeyedFilter(String key, QueryBuilder filter) {
            if (key == null) {
                throw new IllegalArgumentException("[key] must not be null");
            }
            if (filter == null) {
                throw new IllegalArgumentException("[filter] must not be null");
            }
            this.key = key;
            this.filter = filter;
        }

        public KeyedFilter(StreamInput in) throws IOException {
            this.key = in.readString();
            this.filter = in.readNamedWriteable(QueryBuilder.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeNamedWriteable(this.filter);
        }

        public String key() {
            return this.key;
        }

        public QueryBuilder filter() {
            return this.filter;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(this.key, (ToXContent)this.filter);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.filter);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyedFilter other = (KeyedFilter)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.filter, other.filter);
        }
    }
}

