/*
 * Copyright 2022 The TensorFlow Runtime Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef TFRT_BACKENDS_JITRT_INCLUDE_TFRT_JITRT_ASYNC_TASK_RUNNER_H_
#define TFRT_BACKENDS_JITRT_INCLUDE_TFRT_JITRT_ASYNC_TASK_RUNNER_H_

#include <utility>

#include "tfrt/host_context/async_dispatch.h"
#include "tfrt/host_context/host_context.h"
#include "third_party/tensorflow/compiler/xla/runtime/async_runtime.h"

namespace tfrt {
namespace jitrt {

using xla::runtime::AsyncTaskRunner;

// Runs async tasks by enqueing them into the host context work queue.
class HostContextAsyncTaskRunner : public AsyncTaskRunner {
 public:
  explicit HostContextAsyncTaskRunner(tfrt::HostContext* host) : host_(host) {}
  void Schedule(Task task) override { EnqueueWork(host_, std::move(task)); }

 private:
  HostContext* host_;
};

}  // namespace jitrt
}  // namespace tfrt

#endif  // TFRT_BACKENDS_JITRT_INCLUDE_TFRT_JITRT_ASYNC_TASK_RUNNER_H_
