import * as ts from 'typescript';
import { NormalizedMessage } from './NormalizedMessage';
import { CancellationToken } from './CancellationToken';
import * as minimatch from 'minimatch';
import { IncrementalCheckerInterface, IncrementalCheckerParams } from './IncrementalCheckerInterface';
export declare class IncrementalChecker implements IncrementalCheckerInterface {
    private linterConfigs;
    private files;
    private linter?;
    private linterConfig?;
    private linterExclusions;
    protected program?: ts.Program;
    protected programConfig?: ts.ParsedCommandLine;
    private watcher?;
    private readonly hasFixedConfig;
    private readonly typescript;
    private readonly context;
    private readonly programConfigFile;
    private readonly compilerOptions;
    private readonly createNormalizedMessageFromDiagnostic;
    private readonly linterConfigFile;
    private readonly linterAutoFix;
    private readonly createNormalizedMessageFromRuleFailure;
    private readonly eslinter;
    private readonly watchPaths;
    private readonly workNumber;
    private readonly workDivision;
    private readonly vue;
    private readonly checkSyntacticErrors;
    private readonly resolveModuleName;
    private readonly resolveTypeReferenceDirective;
    constructor({ typescript, context, programConfigFile, compilerOptions, createNormalizedMessageFromDiagnostic, linterConfigFile, linterAutoFix, createNormalizedMessageFromRuleFailure, eslinter, watchPaths, workNumber, workDivision, vue, checkSyntacticErrors, resolveModuleName, resolveTypeReferenceDirective }: IncrementalCheckerParams);
    static loadProgramConfig(typescript: typeof ts, configFile: string, compilerOptions: object): ts.ParsedCommandLine;
    private getLinterConfig;
    private static createProgram;
    private createLinter;
    hasLinter(): boolean;
    hasEsLinter(): boolean;
    static isFileExcluded(filePath: string, linterExclusions: minimatch.IMinimatch[]): boolean;
    nextIteration(): void;
    private loadVueProgram;
    private loadDefaultProgram;
    getDiagnostics(cancellationToken: CancellationToken): Promise<NormalizedMessage[]>;
    getLints(cancellationToken: CancellationToken): NormalizedMessage[];
    getEsLints(cancellationToken: CancellationToken): NormalizedMessage[];
}
