Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var React = require('react');
var React__default = _interopDefault(React);
var ui = require('@grafana/ui');
var data = require('@grafana/data');

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

var standardRegions = [
    'af-south-1',
    'ap-east-1',
    'ap-northeast-1',
    'ap-northeast-2',
    'ap-northeast-3',
    'ap-south-1',
    'ap-southeast-1',
    'ap-southeast-2',
    'ca-central-1',
    'cn-north-1',
    'cn-northwest-1',
    'eu-central-1',
    'eu-north-1',
    'eu-west-1',
    'eu-west-2',
    'eu-west-3',
    'me-south-1',
    'sa-east-1',
    'us-east-1',
    'us-east-2',
    'us-gov-east-1',
    'us-gov-west-1',
    'us-iso-east-1',
    'us-isob-east-1',
    'us-west-1',
    'us-west-2',
];

(function (AwsAuthType) {
    AwsAuthType["Keys"] = "keys";
    AwsAuthType["Credentials"] = "credentials";
    AwsAuthType["Default"] = "default";
    AwsAuthType["EC2IAMRole"] = "ec2_iam_role";
    /**
     * @deprecated use default
     */
    AwsAuthType["ARN"] = "arn";
})(exports.AwsAuthType || (exports.AwsAuthType = {}));

var awsAuthProviderOptions = [
    {
        label: 'Workspace IAM Role',
        value: exports.AwsAuthType.EC2IAMRole,
    },
    {
        label: 'AWS SDK Default',
        value: exports.AwsAuthType.Default,
    },
    {
        label: 'Access & secret key',
        value: exports.AwsAuthType.Keys,
    },
    {
        label: 'Credentials file',
        value: exports.AwsAuthType.Credentials,
    },
];

var toOption = function (value) { return ({ value: value, label: value }); };
var ConnectionConfig = function (props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    var _k = __read(React.useState((props.standardRegions || standardRegions).map(toOption)), 2), regions = _k[0], setRegions = _k[1];
    var loadRegions = props.loadRegions, onOptionsChange = props.onOptionsChange, _l = props.skipHeader, skipHeader = _l === void 0 ? false : _l, _m = props.skipEndpoint, skipEndpoint = _m === void 0 ? false : _m;
    var options = props.options;
    var profile = options.jsonData.profile;
    if (profile === undefined) {
        profile = options.database;
    }
    var settings = window.grafanaBootData.settings;
    var awsAllowedAuthProviders = (_a = settings.awsAllowedAuthProviders) !== null && _a !== void 0 ? _a : [
        exports.AwsAuthType.Default,
        exports.AwsAuthType.Keys,
        exports.AwsAuthType.Credentials,
    ];
    var awsAssumeRoleEnabled = (_b = settings.awsAssumeRoleEnabled) !== null && _b !== void 0 ? _b : true;
    var currentProvider = awsAuthProviderOptions.find(function (p) { return p.value === options.jsonData.authType; });
    React.useEffect(function () {
        // Make sure a authType exists in the current model
        if (!currentProvider && awsAllowedAuthProviders.length) {
            onOptionsChange(__assign(__assign({}, options), { jsonData: __assign(__assign({}, options.jsonData), { authType: awsAllowedAuthProviders[0] }) }));
        }
    }, [currentProvider, options, onOptionsChange]);
    React.useEffect(function () {
        if (!loadRegions) {
            return;
        }
        loadRegions().then(function (regions) { return setRegions(regions.map(toOption)); });
    }, [loadRegions]);
    return (React__default.createElement(ui.FieldSet, { label: skipHeader ? '' : 'Connection Details', "data-testid": "connection-config" },
        React__default.createElement(ui.InlineField, { label: "Authentication Provider", labelWidth: 28, tooltip: "Specify which AWS credentials chain to use." },
            React__default.createElement(ui.Select, { className: "width-30", value: currentProvider, options: awsAuthProviderOptions.filter(function (opt) { return awsAllowedAuthProviders.includes(opt.value); }), defaultValue: options.jsonData.authType, onChange: function (option) {
                    data.onUpdateDatasourceJsonDataOptionSelect(props, 'authType')(option);
                } })),
        options.jsonData.authType === 'credentials' && (React__default.createElement(ui.InlineField, { label: "Credentials Profile Name", labelWidth: 28, tooltip: "Credentials profile name, as specified in ~/.aws/credentials, leave blank for default." },
            React__default.createElement(ui.Input, { className: "width-30", placeholder: "default", value: profile, onChange: data.onUpdateDatasourceJsonDataOption(props, 'profile') }))),
        options.jsonData.authType === 'keys' && (React__default.createElement(React__default.Fragment, null,
            React__default.createElement(ui.InlineField, { label: "Access Key ID", labelWidth: 28 }, ((_c = props.options.secureJsonFields) === null || _c === void 0 ? void 0 : _c.accessKey) ? (React__default.createElement(ui.ButtonGroup, { className: "width-30" },
                React__default.createElement(ui.Input, { disabled: true, placeholder: "Configured" }),
                React__default.createElement(ui.ToolbarButton, { icon: "edit", tooltip: "Edit Access Key ID", type: "button", onClick: data.onUpdateDatasourceResetOption(props, 'accessKey') }))) : (React__default.createElement(ui.Input, { className: "width-30", value: (_e = (_d = options.secureJsonData) === null || _d === void 0 ? void 0 : _d.accessKey) !== null && _e !== void 0 ? _e : '', onChange: data.onUpdateDatasourceSecureJsonDataOption(props, 'accessKey') }))),
            React__default.createElement(ui.InlineField, { label: "Secret Access Key", labelWidth: 28 }, ((_f = props.options.secureJsonFields) === null || _f === void 0 ? void 0 : _f.secretKey) ? (React__default.createElement(ui.ButtonGroup, { className: "width-30" },
                React__default.createElement(ui.Input, { disabled: true, placeholder: "Configured" }),
                React__default.createElement(ui.ToolbarButton, { icon: "edit", type: "button", tooltip: "Edit Secret Access Key", onClick: data.onUpdateDatasourceResetOption(props, 'secretKey') }))) : (React__default.createElement(ui.Input, { className: "width-30", value: (_h = (_g = options.secureJsonData) === null || _g === void 0 ? void 0 : _g.secretKey) !== null && _h !== void 0 ? _h : '', onChange: data.onUpdateDatasourceSecureJsonDataOption(props, 'secretKey') }))))),
        awsAssumeRoleEnabled && (React__default.createElement(React__default.Fragment, null,
            React__default.createElement(ui.InlineField, { label: "Assume Role ARN", labelWidth: 28, tooltip: "Optionally, specify the ARN of a role to assume. Specifying a role here will ensure that the selected authentication provider is used to assume the specified role rather than using the credentials directly. Leave blank if you don't need to assume a role at all" },
                React__default.createElement(ui.Input, { className: "width-30", placeholder: "arn:aws:iam:*", value: options.jsonData.assumeRoleArn || '', onChange: data.onUpdateDatasourceJsonDataOption(props, 'assumeRoleArn') })),
            React__default.createElement(ui.InlineField, { label: "External ID", labelWidth: 28, tooltip: "If you are assuming a role in another account, that has been created with an external ID, specify the external ID here." },
                React__default.createElement(ui.Input, { className: "width-30", placeholder: "External ID", value: options.jsonData.externalId || '', onChange: data.onUpdateDatasourceJsonDataOption(props, 'externalId') })))),
        !skipEndpoint && (React__default.createElement(ui.InlineField, { label: "Endpoint", labelWidth: 28, tooltip: "Optionally, specify a custom endpoint for the service" },
            React__default.createElement(ui.Input, { className: "width-30", placeholder: (_j = props.defaultEndpoint) !== null && _j !== void 0 ? _j : 'https://{service}.{region}.amazonaws.com', value: options.jsonData.endpoint || '', onChange: data.onUpdateDatasourceJsonDataOption(props, 'endpoint') }))),
        React__default.createElement(ui.InlineField, { label: "Default Region", labelWidth: 28, tooltip: "Specify the region, such as for US West (Oregon) use ` us-west-2 ` as the region." },
            React__default.createElement(ui.Select, { className: "width-30", value: regions.find(function (region) { return region.value === options.jsonData.defaultRegion; }), options: regions, defaultValue: options.jsonData.defaultRegion, allowCustomValue: true, onChange: data.onUpdateDatasourceJsonDataOptionSelect(props, 'defaultRegion'), formatCreateLabel: function (r) { return "Use region: " + r; } })),
        props.children));
};

exports.ConnectionConfig = ConnectionConfig;
exports.awsAuthProviderOptions = awsAuthProviderOptions;
exports.standardRegions = standardRegions;
//# sourceMappingURL=index.development.js.map
