documentation_complete: true

hidden: true

title: Default Profile for UnionTech OS Server 20

description: |-
    This profile contains all the rules that once belonged to the
    uos20 product via 'prodtype'. This profile won't
    be rendered into an XCCDF Profile entity, nor it will select any
    of these rules by default. The only purpose of this profile
    is to keep a rule in the product's XCCDF Benchmark.

selections:
    - grub2_enable_iommu_force
    - gid_passwd_group_same
    - auditd_data_disk_full_action
    - kernel_config_debug_list
    - audit_rules_sysadmin_actions
    - audit_rules_media_export
    - rsyslog_encrypt_offload_defaultnetstreamdriver
    - file_ownership_library_dirs
    - coredump_disable_storage
    - kernel_config_seccomp
    - auditd_data_retention_max_log_file_action_stig
    - sudoers_no_command_negation
    - file_owner_backup_etc_shadow
    - file_groupowner_var_log
    - set_ip6tables_default_rule
    - sudo_require_authentication
    - kernel_config_security
    - audit_rules_dac_modification_umount2
    - kernel_config_security_dmesg_restrict
    - accounts_umask_etc_profile
    - sshd_set_max_sessions
    - sudoers_no_root_target
    - disable_host_auth
    - file_owner_backup_etc_gshadow
    - kernel_config_kexec
    - file_owner_backup_etc_passwd
    - package_chrony_installed
    - package_ntpdate_removed
    - file_groupownership_sshd_pub_key
    - directory_permissions_var_log_audit
    - file_groupowner_var_log_syslog
    - service_netfs_disabled
    - file_groupownership_audit_configuration
    - file_ownership_sshd_pub_key
    - package_ntp_installed
    - sshd_disable_compression
    - package_cron_installed
    - sshd_print_last_log
    - kernel_config_module_sig_hash
    - grub2_nosmap_argument_absent
    - mount_option_dev_shm_nodev
    - sshd_disable_tcp_forwarding
    - kernel_config_debug_notifiers
    - auditd_overflow_action
    - sshd_allow_only_protocol2
    - file_permissions_home_dirs
    - no_netrc_files
    - postfix_client_configure_mail_alias_postmaster
    - accounts_password_minlen_login_defs
    - account_unique_name
    - sudo_add_use_pty
    - kernel_config_bug
    - file_groupowner_etc_passwd
    - service_iptables_enabled
    - file_permissions_backup_etc_group
    - partition_for_home
    - chronyd_server_directive
    - partition_for_var_log_audit
    - kernel_config_unmap_kernel_at_el0
    - audit_rules_time_adjtimex
    - partition_for_srv
    - auditd_log_format
    - accounts_minimum_age_login_defs
    - partition_for_var_log
    - audit_rules_dac_modification_setxattr
    - service_sshd_disabled
    - sysctl_kernel_panic_on_oops
    - file_permissions_audit_configuration
    - sshd_disable_empty_passwords
    - file_permissions_backup_etc_shadow
    - package_audit_installed
    - sshd_disable_pubkey_auth
    - audit_privileged_commands_reboot
    - sshd_set_idle_timeout
    - auditd_freq
    - kernel_module_tipc_disabled
    - package_syslogng_installed
    - kernel_config_module_sig_all
    - kernel_config_ia32_emulation
    - file_permissions_sshd_pub_key
    - chronyd_specify_remote_server
    - grub2_slab_nomerge_argument
    - audit_rules_mac_modification_usr_share
    - sysctl_kernel_randomize_va_space
    - sshd_limit_user_access
    - file_permissions_backup_etc_passwd
    - accounts_umask_etc_login_defs
    - kernel_config_module_sig_key
    - accounts_polyinstantiated_var_tmp
    - file_owner_etc_passwd
    - kernel_config_module_sig_sha512
    - kernel_config_slub_debug
    - kernel_config_page_poisoning_no_sanity
    - file_permissions_library_dirs
    - file_groupowner_etc_shadow
    - sshd_set_loglevel_verbose
    - package_bind_removed
    - kernel_module_uvcvideo_disabled
    - sshd_disable_user_known_hosts
    - file_groupowner_etc_gshadow
    - kernel_config_default_mmap_min_addr
    - account_use_centralized_automated_auth
    - partition_for_var
    - audit_rules_dac_modification_lremovexattr
    - sysctl_net_ipv6_conf_all_disable_ipv6
    - sudo_vdsm_nopasswd
    - rsyslog_files_ownership
    - package_rsyslog_installed
    - file_permissions_etc_passwd
    - file_groupowner_etc_group
    - coredump_disable_backtraces
    - package_inetutils-telnetd_removed
    - auditd_data_retention_action_mail_acct
    - avahi_disable_publishing
    - sudo_custom_logfile
    - account_passwords_pam_faillock_dir
    - kernel_config_devkmem
    - file_permissions_backup_etc_gshadow
    - kernel_config_legacy_ptys
    - audit_rules_dac_modification_fchmod
    - file_permissions_etc_gshadow
    - file_groupownership_sshd_private_key
    - kernel_module_ipv6_option_disabled
    - audit_rules_privileged_commands
    - kernel_config_randomize_memory
    - sshd_disable_gssapi_auth
    - dir_ownership_library_dirs
    - file_groupowner_backup_etc_shadow
    - audit_rules_dac_modification_fremovexattr
    - sysctl_net_ipv4_conf_default_shared_media
    - audit_rules_immutable
    - audit_rules_file_deletion_events_unlinkat
    - kernel_config_x86_vsyscall_emulation
    - kernel_config_proc_kcore
    - service_systemd-journald_enabled
    - auditd_data_retention_max_log_file_action
    - grub2_spectre_v2_argument
    - file_permissions_var_log_messages
    - no_direct_root_logins
    - package_nss-tools_installed
    - sshd_enable_strictmodes
    - sudo_remove_nopasswd
    - kernel_config_page_poisoning_zero
    - package_logrotate_installed
    - audit_rules_dac_modification_fchmodat
    - kernel_config_compat_vdso
    - postfix_client_configure_relayhost
    - audit_privileged_commands_init
    - iptables_sshd_disabled
    - auditd_data_retention_max_log_file
    - sshd_disable_root_login
    - accounts_no_uid_except_zero
    - package_openssh-server_removed
    - kernel_config_retpoline
    - audit_rules_dac_modification_fchown
    - sshd_set_maxstartups
    - accounts_max_concurrent_login_sessions
    - file_owner_var_log
    - service_cron_enabled
    - ensure_logrotate_activated
    - file_permissions_etc_group
    - no_all_squash_exports
    - sshd_disable_kerb_auth
    - service_ufw_enabled
    - dir_permissions_binary_dirs
    - file_groupowner_backup_etc_passwd
    - package_nis_removed
    - package_gnutls-utils_installed
    - dhcp_client_restrict_options
    - file_permissions_binary_dirs
    - file_permissions_etc_shadow
    - accounts_password_last_change_is_in_past
    - accounts_password_all_shadowed
    - file_permissions_var_log_syslog
    - kernel_config_module_sig_force
    - file_owner_var_log_syslog
    - service_ip6tables_enabled
    - rsyslog_files_permissions
    - audit_rules_dac_modification_chown
    - grub2_nosmep_argument_absent
    - configure_user_data_backups
    - dir_ownership_binary_dirs
    - accounts_password_warn_age_login_defs
    - audit_rules_dac_modification_fchownat
    - sysctl_net_ipv6_conf_default_disable_ipv6
    - kernel_config_security_yama
    - file_owner_backup_etc_group
    - no_empty_passwords
    - accounts_maximum_age_login_defs
    - restrict_serial_port_logins
    - auditd_local_events
    - audit_rules_dac_modification_chmod
    - kernel_config_seccomp_filter
    - sshd_rekey_limit
    - auditd_data_retention_space_left_action
    - kernel_config_security_writable_hooks
    - fapolicyd_prevent_home_folder_access
    - kernel_config_binfmt_misc
    - sysctl_net_ipv4_conf_all_accept_local
    - sysctl_kernel_kptr_restrict
    - audit_rules_file_deletion_events_unlink
    - dir_perms_world_writable_sticky_bits
    - rsyslog_remote_loghost
    - kernel_module_rds_disabled
    - audit_rules_time_settimeofday
    - audit_rules_dac_modification_lsetxattr
    - kernel_config_panic_timeout
    - kernel_config_debug_credentials
    - file_permissions_var_log
    - file_ownership_sshd_private_key
    - kernel_config_panic_on_oops
    - grub2_systemd_debug-shell_argument_absent
    - file_owner_etc_group
    - auditd_data_disk_full_action_stig
    - sudo_add_requiretty
    - sysctl_fs_protected_hardlinks
    - rsyslog_files_groupownership
    - sshd_enable_gssapi_auth
    - kernel_config_debug_sg
    - partition_for_dev_shm
    - grub2_l1tf_argument
    - auditd_data_disk_error_action
    - audit_rules_dac_modification_removexattr
    - auditd_data_retention_admin_space_left_action
    - file_permissions_systemmap
    - kernel_config_ipv6
    - file_ownership_binary_dirs
    - grub2_disable_recovery
    - package_telnetd_removed
    - service_auditd_enabled
    - sshd_set_login_grace_time
    - audit_rules_dac_modification_lchown
    - sshd_enable_pubkey_auth
    - postfix_client_configure_mail_alias
    - no_empty_passwords_etc_shadow
    - kernel_config_compat_brk
    - sshd_enable_pam
    - audit_rules_time_clock_settime
    - grub2_spec_store_bypass_disable_argument
    - partition_for_tmp
    - service_syslogng_enabled
    - account_passwords_pam_faillock_audit
    - sudoers_explicit_command_args
    - accounts_root_gid_zero
    - auditd_data_retention_num_logs
    - file_permissions_sshd_private_key
    - mount_option_dev_shm_nosuid
    - dhcp_server_minimize_served_info
    - package_openssh-server_installed
    - accounts_logon_fail_delay
    - selinux_state
    - file_groupowner_var_log_messages
    - auditd_audispd_syslog_plugin_activated
    - kernel_config_acpi_custom_method
    - file_groupowner_backup_etc_group
    - kernel_config_syn_cookies
    - auditd_data_disk_error_action_stig
    - file_owner_var_log_messages
    - sshd_disable_root_password_login
    - file_ownership_audit_configuration
    - package_telnetd-ssl_removed
    - service_chronyd_enabled
    - grub2_rng_core_default_quality_argument
    - gnome_gdm_disable_xdmcp
    - package_MFEhiplsm_installed
    - audit_rules_session_events
    - kernel_config_page_table_isolation
    - audit_rules_usergroup_modification
    - sshd_set_keepalive
    - audit_rules_dac_modification_umount
    - audit_rules_file_deletion_events_rename
    - file_groupowner_backup_etc_gshadow
    - sysctl_net_ipv4_conf_all_arp_filter
    - kernel_config_hibernation
    - set_iptables_default_rule_forward
    - display_login_attempts
    - sshd_enable_warning_banner
    - package_postfix_installed
    - audit_privileged_commands_poweroff
    - auditd_write_logs
    - grub2_mce_argument
    - audit_rules_time_stime
    - file_owner_etc_gshadow
    - sshd_do_not_permit_user_env
    - accounts_polyinstantiated_tmp
    - kernel_disable_entropy_contribution_for_solid_state_drives
    - sshd_use_priv_separation
    - audit_privileged_commands_shutdown
    - dir_permissions_library_dirs
    - file_ownership_var_log_audit
    - sshd_enable_warning_banner_net
    - sysctl_fs_protected_symlinks
    - ftp_limit_users
    - rsyslog_accept_remote_messages_tcp
    - file_permissions_unauthorized_world_writable
    - service_rsyslog_enabled
    - kernel_config_randomize_base
    - sshd_set_loglevel_info
    - ftp_configure_firewall
    - package_libreswan_installed
    - audit_rules_file_deletion_events_rmdir
    - audit_rules_networkconfig_modification
    - sysctl_net_ipv4_conf_all_arp_ignore
    - securetty_root_login_console_only
    - sshd_set_keepalive_0
    - selinux_not_disabled
    - accounts_root_path_dirs_no_write
    - sysctl_net_ipv4_conf_all_shared_media
    - file_owner_etc_shadow
    - root_path_no_dot
    - no_rsh_trust_files
    - sudo_remove_no_authenticate
    - sudo_add_noexec
    - sysctl_net_ipv4_conf_all_route_localnet
    - kernel_config_debug_fs
    - disallow_bypass_password_sudo
    - prefer_64bit_os
    - sshd_disable_x11_forwarding
    - sshd_enable_x11_forwarding
    - sshd_disable_rhosts_rsa
    - harden_ssh_client_crypto_policy
    - sshd_set_max_auth_tries
    - sshd_disable_rhosts
    - audit_rules_file_deletion_events_renameat
    - audit_rules_dac_modification_fsetxattr
    - set_iptables_default_rule
    - sysctl_fs_suid_dumpable
    - accounts_passwords_pam_faillock_audit
    - rsyslog_encrypt_offload_actionsendstreamdrivermode
    - rsyslog_encrypt_offload_actionsendstreamdriverauthmode
    - rsyslog_accept_remote_messages_udp
    - kernel_config_module_sig
    - audit_rules_mac_modification
    - audit_rules_time_watch_localtime
