/*
 * Copyright (c) 2022, NVIDIA CORPORATION. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#pragma once

#include <iostream>
#include <inttypes.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <cuda_runtime.h>
#include <assert.h>
#include <tuple>
#include <functional>

#include <cudnn.h>
#include "fp16_dev.h"
#include "fp16_emu.h"
#include "helpers.h"

#if (CUDNN_VERSION >= 8900)

void 
run_f16_flash_attention_fprop(int64_t b, 
              int64_t h, 
              int64_t s_q,
              int64_t s_kv,
              int64_t d,
              MHA_Layout layout,
              float scaling_factor,
              bool isTraining,
              double dropout_probability,
              void* devPtrQ, 
              void* devPtrK,   
              void* devPtrV,
              void* devPtrSoftmaxStats,   
              void* devPtrO,
              void* devPtrDropoutSeed,
              void* devPtrDropoutOffset,
              cudnnDataType_t tensorType);

void 
run_f16_flash_attention_bprop(int64_t b, 
              int64_t h, 
              int64_t s_q,
              int64_t s_kv,
              int64_t d,
              MHA_Layout layout,
              float scaling_factor,
              float dropout_probability,
              void* devPtrQ, 
              void* devPtrKTranspose,   
              void* devPtrVTranspose,
              void* devPtrO,
              void* devPtrSoftmaxStats,
              void* devPtrSoftmaxSum,
              void* devPtrdQAccumulator,
              void* devPtrdQ, 
              void* devPtrdK,
              void* devPtrdV,   
              void* devPtrdO,
              void* devPtrDropoutSeed,
              void* devPtrDropoutOffset,
              cudnnDataType_t tensorType);

#endif
