"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.now = exports.clear = exports.advanceTo = exports.advanceBy = void 0;

/**
 * Created by hustcc 18/05/27.
 * Contract: i@hust.cc
 */
// undefined means unmock.
var DEFAULT = undefined; // current Date of timestamp

var nowDate = DEFAULT;
/**
 * move date by offset `ms`
 * @param ms
 */

var advanceBy = function advanceBy(ms) {
  return nowDate = (nowDate === undefined ? +new Date() : nowDate) + (ms || 0);
};
/**
 * reset Date
 * if no parameter, then set to 0
 * @param ms
 * @returns {*}
 */


exports.advanceBy = advanceBy;

var advanceTo = function advanceTo(ms) {
  return nowDate = ms ? +new Date(ms) : 0;
};
/**
 * clear mock
 * @returns {undefined}
 */


exports.advanceTo = advanceTo;

var clear = function clear() {
  return nowDate = DEFAULT;
};
/**
 * current
 * @returns {number}
 */


exports.clear = clear;

var now = function now() {
  return nowDate;
};

exports.now = now;