"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getErrorDetails = void 0;
var agent_core_1 = require("@grafana/agent-core");
var const_1 = require("./const");
var stackFrames_1 = require("./stackFrames");
function getErrorDetails(event) {
    var value;
    var type;
    var stackFrames = [];
    var isDomErrorRes;
    var isEventRes;
    if ((0, agent_core_1.isErrorEvent)(event) && event.error) {
        value = event.error.message;
        type = event.error.name;
        stackFrames = (0, stackFrames_1.getStackFramesFromError)(event.error);
    }
    else if ((isDomErrorRes = (0, agent_core_1.isDomError)(event)) || (0, agent_core_1.isDomException)(event)) {
        var name_1 = event.name, message = event.message;
        type = name_1 !== null && name_1 !== void 0 ? name_1 : (isDomErrorRes ? const_1.domErrorType : const_1.domExceptionType);
        value = message ? "".concat(type, ": ").concat(message) : type;
    }
    else if ((0, agent_core_1.isError)(event)) {
        value = event.message;
        stackFrames = (0, stackFrames_1.getStackFramesFromError)(event);
    }
    else if ((0, agent_core_1.isObject)(event) || (isEventRes = (0, agent_core_1.isEvent)(event))) {
        type = isEventRes ? event.constructor.name : undefined;
        value = "".concat(const_1.objectEventValue, " ").concat(Object.keys(event));
    }
    return [value, type, stackFrames];
}
exports.getErrorDetails = getErrorDetails;
//# sourceMappingURL=getErrorDetails.js.map