; RUN: llc -march=amdgcn -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,FUNC %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=kaveri -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,FUNC %s
; RUN: llc -march=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,FUNC %s
; RUN: llc -march=r600 -mcpu=redwood < %s | FileCheck --check-prefixes=EG,FUNC %s


; FUNC-LABEL: {{^}}constant_load_i64:
; GCN: s_load_dwordx2 {{s\[[0-9]+:[0-9]+\]}}, {{s\[[0-9]+:[0-9]+\]}}, 0x0{{$}}
; EG: VTX_READ_64
define amdgpu_kernel void @constant_load_i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
  %ld = load i64, ptr addrspace(4) %in
  store i64 %ld, ptr addrspace(1) %out
  ret void
}

; FUNC-LABEL: {{^}}constant_load_v2i64:
; GCN: s_load_dwordx4

; EG: VTX_READ_128
define amdgpu_kernel void @constant_load_v2i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
entry:
  %ld = load <2 x i64>, ptr addrspace(4) %in
  store <2 x i64> %ld, ptr addrspace(1) %out
  ret void
}

; FUNC-LABEL: {{^}}constant_load_v3i64:
; GCN-DAG: s_load_dwordx4 {{s\[[0-9]+:[0-9]+\]}}, {{s\[[0-9]+:[0-9]+\]}}, 0x0{{$}}
; GCN-DAG: s_load_dwordx2 {{s\[[0-9]+:[0-9]+\]}}, {{s\[[0-9]+:[0-9]+\]}}, 0x{{[0-9]+}}{{$}}

; EG-DAG: VTX_READ_128
; EG-DAG: VTX_READ_128
define amdgpu_kernel void @constant_load_v3i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
entry:
  %ld = load <3 x i64>, ptr addrspace(4) %in
  store <3 x i64> %ld, ptr addrspace(1) %out
  ret void
}

; FUNC-LABEL: {{^}}constant_load_v4i64
; GCN: s_load_dwordx8

; EG: VTX_READ_128
; EG: VTX_READ_128
define amdgpu_kernel void @constant_load_v4i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
entry:
  %ld = load <4 x i64>, ptr addrspace(4) %in
  store <4 x i64> %ld, ptr addrspace(1) %out
  ret void
}

; FUNC-LABEL: {{^}}constant_load_v8i64:
; GCN: s_load_dwordx16

; EG: VTX_READ_128
; EG: VTX_READ_128
; EG: VTX_READ_128
; EG: VTX_READ_128
define amdgpu_kernel void @constant_load_v8i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
entry:
  %ld = load <8 x i64>, ptr addrspace(4) %in
  store <8 x i64> %ld, ptr addrspace(1) %out
  ret void
}

; FUNC-LABEL: {{^}}constant_load_v16i64:
; GCN: s_load_dwordx16
; GCN: s_load_dwordx16

; EG: VTX_READ_128
; EG: VTX_READ_128
; EG: VTX_READ_128
; EG: VTX_READ_128
; EG: VTX_READ_128
; EG: VTX_READ_128
; EG: VTX_READ_128
; EG: VTX_READ_128
define amdgpu_kernel void @constant_load_v16i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
entry:
  %ld = load <16 x i64>, ptr addrspace(4) %in
  store <16 x i64> %ld, ptr addrspace(1) %out
  ret void
}

attributes #0 = { nounwind }
