import { TransportItemType } from '../../transports';
import { getCurrentTimestamp } from '../../utils';
import { defaultLogLevel, originalConsoleMethods } from './const';
export function initializeLogs(transports, metas, tracesApi) {
  var pushLog = function (args, _a) {
    var _b = _a === void 0 ? {} : _a,
      context = _b.context,
      level = _b.level;
    try {
      var item = {
        type: TransportItemType.LOG,
        payload: {
          message: args
            .map(function (arg) {
              try {
                return String(arg);
              } catch (err) {
                return '';
              }
            })
            .join(' '),
          level: level !== null && level !== void 0 ? level : defaultLogLevel,
          context: context !== null && context !== void 0 ? context : {},
          timestamp: getCurrentTimestamp(),
          trace: tracesApi.getTraceContext(),
        },
        meta: metas.value,
      };
      transports.execute(item);
    } catch (err) {
      // TODO: Add proper logging when debug is enabled
    }
  };
  var callOriginalConsoleMethod = function (level) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
      args[_i - 1] = arguments[_i];
    }
    originalConsoleMethods[level].apply(console, args);
  };
  return {
    callOriginalConsoleMethod: callOriginalConsoleMethod,
    pushLog: pushLog,
  };
}
//# sourceMappingURL=initialize.js.map
