"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bundleManagedTask = void 0;
const tslib_1 = require("tslib");
const execa = require("execa");
const fs_1 = require("fs");
const task_1 = require("../task");
const MANAGED_PLUGINS_PATH = `${process.cwd()}/plugins-bundled`;
const MANAGED_PLUGINS_SCOPES = ['internal', 'external'];
const bundleManagedPluginsRunner = () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    yield Promise.all(MANAGED_PLUGINS_SCOPES.map((scope) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        try {
            const plugins = yield fs_1.promises.readdir(`${MANAGED_PLUGINS_PATH}/${scope}`);
            if (plugins.length > 0) {
                for (const plugin of plugins) {
                    try {
                        console.log(`[${scope}]: ${plugin} building...`);
                        yield execa('yarn', ['build'], { cwd: `${MANAGED_PLUGINS_PATH}/${scope}/${plugin}` });
                        console.log(`[${scope}]: ${plugin} bundled`);
                    }
                    catch (e) {
                        console.log(e.stdout);
                    }
                }
            }
        }
        catch (e) {
            console.log(e);
        }
    })));
});
exports.bundleManagedTask = new task_1.Task('Bundle managed plugins', bundleManagedPluginsRunner);
//# sourceMappingURL=bundle.managed.js.map