/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cert.Extension;

public class ListCerts {
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: ListCerts <dbdir> <nickname>");
                return;
            }
            String nickname = args[1];
            CryptoManager cm = CryptoManager.getInstance();
            org.mozilla.jss.crypto.X509Certificate[] certs = cm.findCertsByNickname(nickname);
            System.out.println(certs.length + " certs found with this nickname.");
            for (int i = 0; i < certs.length; ++i) {
                System.out.println("\nSubject: " + certs[i].getSubjectDN());
                Certificate cert = (Certificate)ASN1Util.decode((ASN1Template)Certificate.getTemplate(), (byte[])certs[i].getEncoded());
                CertificateInfo info = cert.getInfo();
                OBJECT_IDENTIFIER sigalg = info.getSignatureAlgId().getOID();
                System.out.println("Signature oid " + info.getSignatureAlgId().getOID());
                SEQUENCE extensions = info.getExtensions();
                for (int j = 0; j < extensions.size(); ++j) {
                    Extension ext = (Extension)extensions.elementAt(i);
                    OBJECT_IDENTIFIER oid = ext.getExtnId();
                    OCTET_STRING value = ext.getExtnValue();
                    System.out.println("Extension " + oid.toString());
                    if (ext.getCritical()) {
                        System.out.println("Critical extension: " + oid.toString());
                        continue;
                    }
                    System.out.println("NON Critical extension: " + oid.toString());
                }
                System.out.println("Convert to JDK cert");
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream bais = new ByteArrayInputStream(certs[i].getEncoded());
                X509Certificate jdkCert = (X509Certificate)cf.generateCertificate(bais);
                bais.close();
                System.out.println("Subject " + jdkCert.getSubjectX500Principal());
                System.out.println("Signature oid " + jdkCert.getSigAlgName());
                Set<String> nonCritSet = jdkCert.getNonCriticalExtensionOIDs();
                if (nonCritSet != null && !nonCritSet.isEmpty()) {
                    for (String oid : nonCritSet) {
                        System.out.println(oid);
                    }
                } else {
                    System.out.println("no NON Critical Extensions");
                }
                Set<String> critSet = jdkCert.getCriticalExtensionOIDs();
                if (critSet != null && !critSet.isEmpty()) {
                    System.out.println("Set of critical extensions:");
                    for (String oid : critSet) {
                        System.out.println(oid);
                    }
                    continue;
                }
                System.out.println("no Critical Extensions");
            }
            System.out.println("END");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

