/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPFilter;

public class JDAPFilterExtensible
extends JDAPFilter {
    private int m_tag = 169;
    private String m_type = null;
    private String m_value = null;

    public JDAPFilterExtensible(String type, String match) {
        this.m_type = type;
        this.m_value = match;
    }

    @Override
    public BERElement getBERElement() {
        BERTag tag;
        String value = this.m_value;
        String defs = this.m_type;
        int colonIndex = defs.lastIndexOf(58);
        if (colonIndex == -1) {
            return null;
        }
        boolean isDN = false;
        String oid = null;
        if (defs.regionMatches(true, colonIndex + 1, "dn", 0, 2)) {
            isDN = true;
        } else {
            oid = defs.substring(colonIndex + 1);
        }
        defs = defs.substring(0, colonIndex);
        colonIndex = defs.lastIndexOf(58);
        if (colonIndex >= 0) {
            if (defs.regionMatches(true, colonIndex + 1, "dn", 0, 2)) {
                isDN = true;
            } else {
                oid = defs.substring(colonIndex + 1);
            }
        }
        BERSequence seq = new BERSequence();
        if (oid != null) {
            tag = new BERTag(129, new BEROctetString(oid), true);
            seq.addElement(tag);
        }
        if (defs.length() > 0) {
            tag = new BERTag(130, new BEROctetString(defs), true);
            seq.addElement(tag);
        }
        tag = new BERTag(131, new BEROctetString(value), true);
        seq.addElement(tag);
        tag = new BERTag(132, new BERBoolean(isDN), true);
        seq.addElement(tag);
        BERTag element = new BERTag(this.m_tag, seq, true);
        return element;
    }

    @Override
    public String toString() {
        return "JDAPFilterExtensible {" + this.m_value + "}";
    }
}

