package nl

// All the following constants are coming from:
// https://github.com/torvalds/linux/blob/master/include/uapi/linux/devlink.h

const (
	GENL_DEVLINK_VERSION = 1
	GENL_DEVLINK_NAME    = "devlink"
)

const (
	DEVLINK_CMD_GET         = 1
	DEVLINK_CMD_PORT_GET    = 5
	DEVLINK_CMD_PORT_SET    = 6
	DEVLINK_CMD_PORT_NEW    = 7
	DEVLINK_CMD_PORT_DEL    = 8
	DEVLINK_CMD_ESWITCH_GET = 29
	DEVLINK_CMD_ESWITCH_SET = 30
	DEVLINK_CMD_INFO_GET    = 51
)

const (
	DEVLINK_ATTR_BUS_NAME               = 1
	DEVLINK_ATTR_DEV_NAME               = 2
	DEVLINK_ATTR_PORT_INDEX             = 3
	DEVLINK_ATTR_PORT_TYPE              = 4
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX    = 6
	DEVLINK_ATTR_PORT_NETDEV_NAME       = 7
	DEVLINK_ATTR_PORT_IBDEV_NAME        = 8
	DEVLINK_ATTR_ESWITCH_MODE           = 25
	DEVLINK_ATTR_ESWITCH_INLINE_MODE    = 26
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE     = 62
	DEVLINK_ATTR_PORT_FLAVOUR           = 77
	DEVLINK_ATTR_INFO_DRIVER_NAME       = 98
	DEVLINK_ATTR_INFO_SERIAL_NUMBER     = 99
	DEVLINK_ATTR_INFO_VERSION_FIXED     = 100
	DEVLINK_ATTR_INFO_VERSION_RUNNING   = 101
	DEVLINK_ATTR_INFO_VERSION_STORED    = 102
	DEVLINK_ATTR_INFO_VERSION_NAME      = 103
	DEVLINK_ATTR_INFO_VERSION_VALUE     = 104
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER     = 127
	DEVLINK_ATTR_PORT_FUNCTION          = 145
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER = 150
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER     = 164
)

const (
	DEVLINK_ESWITCH_MODE_LEGACY    = 0
	DEVLINK_ESWITCH_MODE_SWITCHDEV = 1
)

const (
	DEVLINK_ESWITCH_INLINE_MODE_NONE      = 0
	DEVLINK_ESWITCH_INLINE_MODE_LINK      = 1
	DEVLINK_ESWITCH_INLINE_MODE_NETWORK   = 2
	DEVLINK_ESWITCH_INLINE_MODE_TRANSPORT = 3
)

const (
	DEVLINK_ESWITCH_ENCAP_MODE_NONE  = 0
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1
)

const (
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0
	DEVLINK_PORT_FLAVOUR_CPU      = 1
	DEVLINK_PORT_FLAVOUR_DSA      = 2
	DEVLINK_PORT_FLAVOUR_PCI_PF   = 3
	DEVLINK_PORT_FLAVOUR_PCI_VF   = 4
	DEVLINK_PORT_FLAVOUR_VIRTUAL  = 5
	DEVLINK_PORT_FLAVOUR_UNUSED   = 6
	DEVLINK_PORT_FLAVOUR_PCI_SF   = 7
)

const (
	DEVLINK_PORT_TYPE_NOTSET = 0
	DEVLINK_PORT_TYPE_AUTO   = 1
	DEVLINK_PORT_TYPE_ETH    = 2
	DEVLINK_PORT_TYPE_IB     = 3
)

const (
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR = 1
	DEVLINK_PORT_FN_ATTR_STATE         = 2
	DEVLINK_PORT_FN_ATTR_OPSTATE       = 3
)

const (
	DEVLINK_PORT_FN_STATE_INACTIVE = 0
	DEVLINK_PORT_FN_STATE_ACTIVE   = 1
)

const (
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1
)
