import { FieldConfigEditorProps, FieldConfigPropertyItem, FieldConfigEditorConfig } from '../types/fieldOverrides';
import { OptionsUIRegistryBuilder } from '../types/OptionsUIRegistryBuilder';
import { PanelOptionsEditorConfig, PanelOptionsEditorItem } from '../types/panel';
import { SelectFieldConfigSettings, StandardEditorProps, StringFieldConfigSettings, NumberFieldConfigSettings, SliderFieldConfigSettings, UnitFieldConfigSettings } from '../field';
/**
 * Fluent API for declarative creation of field config option editors
 */
export declare class FieldConfigEditorBuilder<TOptions> extends OptionsUIRegistryBuilder<TOptions, FieldConfigEditorProps<any, any>, FieldConfigPropertyItem<TOptions>> {
    addNumberInput<TSettings>(config: FieldConfigEditorConfig<TOptions, TSettings & NumberFieldConfigSettings, number>): this;
    addSliderInput<TSettings>(config: FieldConfigEditorConfig<TOptions, TSettings & SliderFieldConfigSettings, number>): this;
    addTextInput<TSettings>(config: FieldConfigEditorConfig<TOptions, TSettings & StringFieldConfigSettings, string>): this;
    addSelect<TOption, TSettings extends SelectFieldConfigSettings<TOption>>(config: FieldConfigEditorConfig<TOptions, TSettings, TOption>): this;
    addRadio<TOption, TSettings = any>(config: FieldConfigEditorConfig<TOptions, TSettings, TOption>): this;
    addBooleanSwitch<TSettings = any>(config: FieldConfigEditorConfig<TOptions, TSettings, boolean>): this;
    addColorPicker<TSettings = any>(config: FieldConfigEditorConfig<TOptions, TSettings, string>): this;
    addUnitPicker<TSettings = any>(config: FieldConfigEditorConfig<TOptions, TSettings & UnitFieldConfigSettings, string>): this;
}
/**
 * Fluent API for declarative creation of panel options
 */
export declare class PanelOptionsEditorBuilder<TOptions> extends OptionsUIRegistryBuilder<TOptions, StandardEditorProps, PanelOptionsEditorItem<TOptions>> {
    addNumberInput<TSettings>(config: PanelOptionsEditorConfig<TOptions, TSettings & NumberFieldConfigSettings, number>): this;
    addSliderInput<TSettings>(config: PanelOptionsEditorConfig<TOptions, TSettings & SliderFieldConfigSettings, number>): this;
    addTextInput<TSettings>(config: PanelOptionsEditorConfig<TOptions, TSettings & StringFieldConfigSettings, string>): this;
    addStringArray<TSettings>(config: PanelOptionsEditorConfig<TOptions, TSettings & StringFieldConfigSettings, string[]>): this;
    addSelect<TOption, TSettings extends SelectFieldConfigSettings<TOption>>(config: PanelOptionsEditorConfig<TOptions, TSettings, TOption>): this;
    addMultiSelect<TOption, TSettings extends SelectFieldConfigSettings<TOption>>(config: PanelOptionsEditorConfig<TOptions, TSettings, TOption>): this;
    addRadio<TOption, TSettings extends SelectFieldConfigSettings<TOption>>(config: PanelOptionsEditorConfig<TOptions, TSettings, TOption>): this;
    addBooleanSwitch<TSettings = any>(config: PanelOptionsEditorConfig<TOptions, TSettings, boolean>): this;
    addColorPicker<TSettings = any>(config: PanelOptionsEditorConfig<TOptions, TSettings, string>): this;
    addTimeZonePicker<TSettings = any>(config: PanelOptionsEditorConfig<TOptions, TSettings, string>): this;
    addUnitPicker<TSettings = any>(config: PanelOptionsEditorConfig<TOptions, TSettings & UnitFieldConfigSettings, string>): this;
}
