import * as React from 'react';
export interface Options {
    actions?: Action[];
    index?: number;
    level?: number;
    nodeOnly?: boolean;
    randomKey?: boolean;
    selector?: string;
    type?: string;
}
export interface Action {
    condition: (node: Node, key: string, level: number) => boolean;
    post?: (node: Node, key: string, level: number) => React.ReactNode;
    pre?: (node: Node, key: string, level: number) => Node;
}
export declare function convertFromNode(input: Node, options?: Options): React.ReactNode;
export declare function convertFromString(input: string, options?: Options): React.ReactNode | Node;
export default function convert(input: Node | string, options?: Options): React.ReactNode | Node;
