"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.omit = exports.randomString = exports.supportsInlineSVG = exports.isSupportedEnvironment = exports.canUseDOM = exports.STATUS = void 0;
var exenv_1 = require("exenv");
exports.STATUS = {
    FAILED: 'failed',
    LOADED: 'loaded',
    LOADING: 'loading',
    PENDING: 'pending',
    READY: 'ready',
    UNSUPPORTED: 'unsupported',
};
function canUseDOM() {
    return exenv_1.canUseDOM;
}
exports.canUseDOM = canUseDOM;
function isSupportedEnvironment() {
    return supportsInlineSVG() && typeof window !== 'undefined' && window !== null;
}
exports.isSupportedEnvironment = isSupportedEnvironment;
function supportsInlineSVG() {
    /* istanbul ignore next */
    if (!document) {
        return false;
    }
    var div = document.createElement('div');
    div.innerHTML = '<svg />';
    var svg = div.firstChild;
    return !!svg && svg.namespaceURI === 'http://www.w3.org/2000/svg';
}
exports.supportsInlineSVG = supportsInlineSVG;
function randomCharacter(character) {
    return character[Math.floor(Math.random() * character.length)];
}
function randomString(length) {
    var letters = 'abcdefghijklmnopqrstuvwxyz';
    var numbers = '1234567890';
    var charset = "".concat(letters).concat(letters.toUpperCase()).concat(numbers);
    var R = '';
    for (var index = 0; index < length; index++) {
        R += randomCharacter(charset);
    }
    return R;
}
exports.randomString = randomString;
/**
 *  Remove properties from an object
 */
function omit(input) {
    var filter = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        filter[_i - 1] = arguments[_i];
    }
    var output = {};
    for (var key in input) {
        /* istanbul ignore else */
        if ({}.hasOwnProperty.call(input, key)) {
            if (!filter.includes(key)) {
                output[key] = input[key];
            }
        }
    }
    return output;
}
exports.omit = omit;
//# sourceMappingURL=helpers.js.map