"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertRootUrlIsValid = exports.getPluginJson = exports.validatePluginJson = void 0;
const validatePluginJson = (pluginJson) => {
    if (!pluginJson.id) {
        throw new Error('Plugin id is missing in plugin.json');
    }
    if (!pluginJson.info) {
        throw new Error('Plugin info node is missing in plugin.json');
    }
    if (!pluginJson.info.version) {
        throw new Error('Plugin info.version is missing in plugin.json');
    }
    const types = ['panel', 'datasource', 'app'];
    const type = pluginJson.type;
    if (!types.includes(type)) {
        throw new Error('Invalid plugin type in plugin.json: ' + type);
    }
    if (!pluginJson.id.endsWith('-' + type)) {
        throw new Error('[plugin.json] id should end with: -' + type);
    }
};
exports.validatePluginJson = validatePluginJson;
const getPluginJson = (path) => {
    let pluginJson;
    try {
        pluginJson = require(path);
    }
    catch (e) {
        throw new Error('Unable to find: ' + path);
    }
    (0, exports.validatePluginJson)(pluginJson);
    return pluginJson;
};
exports.getPluginJson = getPluginJson;
const assertRootUrlIsValid = (rootUrl) => {
    try {
        new URL(rootUrl);
    }
    catch (err) {
        throw new Error(`${rootUrl} is not a valid URL`);
    }
};
exports.assertRootUrlIsValid = assertRootUrlIsValid;
//# sourceMappingURL=pluginValidation.js.map