"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerOnerror = void 0;
var agent_core_1 = require("@grafana/agent-core");
var const_1 = require("./const");
var getErrorDetails_1 = require("./getErrorDetails");
var getValueAndTypeFromMessage_1 = require("./getValueAndTypeFromMessage");
var stackFrames_1 = require("./stackFrames");
function registerOnerror(agent) {
    // The error event is a little bit different than other events when it comes to the listener
    // window.addEventListener does not provide all parameters, hence we need to use the window.onerror syntax
    // TODO: investigate https://developer.mozilla.org/en-US/docs/Web/API/GlobalEventHandlers/onerror
    var oldonerror = window.onerror;
    window.onerror = function () {
        var _a, _b;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        try {
            var event_1 = args[0], source = args[1], lineno = args[2], colno = args[3], error = args[4];
            var value = void 0;
            var type = void 0;
            var stackFrames = [];
            var eventIsString = (0, agent_core_1.isString)(event_1);
            var initialStackFrame = (0, stackFrames_1.buildStackFrame)(source, const_1.unknownString, lineno, colno);
            if (error || !eventIsString) {
                _a = (0, getErrorDetails_1.getErrorDetails)((error !== null && error !== void 0 ? error : event_1)), value = _a[0], type = _a[1], stackFrames = _a[2];
                if (stackFrames.length === 0) {
                    stackFrames = [initialStackFrame];
                }
            }
            else if (eventIsString) {
                _b = (0, getValueAndTypeFromMessage_1.getValueAndTypeFromMessage)(event_1), value = _b[0], type = _b[1];
                stackFrames = [initialStackFrame];
            }
            if (value) {
                agent.api.pushError(new Error(value), { type: type, stackFrames: stackFrames });
            }
        }
        finally {
            oldonerror === null || oldonerror === void 0 ? void 0 : oldonerror.apply(window, args);
        }
    };
}
exports.registerOnerror = registerOnerror;
//# sourceMappingURL=registerOnerror.js.map