/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSyntaxSchemaElement;

public class LDAPMatchingRuleSchema
extends LDAPAttributeSchema {
    static final long serialVersionUID = 6466155218986944131L;
    static final String[] EXPLICIT = new String[]{"OBSOLETE", "SYNTAX"};
    private String[] attributes = null;

    public LDAPMatchingRuleSchema(String name, String oid, String description, String[] attributes, int syntax) {
        this(name, oid, description, attributes, "1.3.6.1.4.1.1466.115.121.1.15");
        this.syntaxElement.syntax = syntax;
        String syntaxType = LDAPSyntaxSchemaElement.internalSyntaxToString(syntax);
        if (syntaxType != null) {
            this.syntaxElement.syntaxString = syntaxType;
        }
        this.setQualifier("SYNTAX", this.syntaxElement.syntaxString);
    }

    public LDAPMatchingRuleSchema(String name, String oid, String description, String[] attributes, String syntaxString) {
        this(name, oid, description, attributes, syntaxString, null);
    }

    public LDAPMatchingRuleSchema(String name, String oid, String description, String[] attributes, String syntaxString, String[] aliases) {
        if (oid == null || oid.trim().length() < 1) {
            throw new IllegalArgumentException("OID required");
        }
        this.name = name;
        this.oid = oid;
        this.description = description;
        this.attrName = "matchingrules";
        this.syntaxElement.syntax = this.syntaxElement.syntaxCheck(syntaxString);
        this.syntaxElement.syntaxString = syntaxString;
        this.setQualifier("SYNTAX", this.syntaxElement.syntaxString);
        this.attributes = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            this.attributes[i] = attributes[i];
        }
        if (aliases != null && aliases.length > 0) {
            this.aliases = aliases;
        }
    }

    public LDAPMatchingRuleSchema(String raw, String use) {
        Object p;
        this.attrName = "matchingrules";
        if (raw != null) {
            this.parseValue(raw);
        }
        if (use != null) {
            this.parseValue(use);
        }
        if ((p = this.properties.get("APPLIES")) instanceof Vector) {
            Vector v = (Vector)p;
            if (v != null) {
                this.attributes = new String[v.size()];
                v.copyInto(this.attributes);
                v.removeAllElements();
            }
        } else if (p instanceof String) {
            this.attributes = new String[1];
            this.attributes[0] = (String)p;
        }
        String val = (String)this.properties.get("SYNTAX");
        if (val != null) {
            this.syntaxElement.syntaxString = val;
            this.syntaxElement.syntax = this.syntaxElement.syntaxCheck(val);
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    @Override
    String getValue(boolean quotingBug) {
        String val;
        Object s = this.getValuePrefix();
        if (this.syntaxElement.syntaxString != null) {
            s = (String)s + "SYNTAX ";
            if (quotingBug) {
                s = (String)s + "'";
            }
            s = (String)s + this.syntaxElement.syntaxString;
            if (quotingBug) {
                s = (String)s + "'";
            }
            s = (String)s + " ";
        }
        if ((val = this.getCustomValues()).length() > 0) {
            s = (String)s + val + " ";
        }
        s = (String)s + ")";
        return s;
    }

    @Override
    public String getValue() {
        return this.getValue(false);
    }

    public String getUseValue() {
        Object s = this.getValuePrefix();
        if (this.attributes != null && this.attributes.length > 0) {
            s = (String)s + "APPLIES ( ";
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    s = (String)s + " $ ";
                }
                s = (String)s + this.attributes[i];
            }
            s = (String)s + " ) ";
        }
        s = (String)s + ")";
        return s;
    }

    @Override
    protected void update(LDAPConnection ld, int op, String name, String dn) throws LDAPException {
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute("matchingRules", this.getValue()), new LDAPAttribute("matchingRuleUse", this.getUseValue())};
        this.update(ld, op, attrs, dn);
    }

    @Override
    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid + "; Type: ";
        s = s + this.syntaxElement.syntaxToString();
        s = s + "; Description: " + this.description;
        if (this.attributes != null) {
            s = s + "; Applies to: ";
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    s = s + ", ";
                }
                s = s + this.attributes[i];
            }
        }
        s = s + this.getQualifierString(EXPLICIT);
        s = s + this.getAliasString();
        return s;
    }
}

