/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.MimeBase64Encoder;

public abstract class LDAPWriter
implements Serializable {
    protected PrintWriter m_pw;
    private static MimeBase64Encoder m_encoder = new MimeBase64Encoder();

    public LDAPWriter(PrintWriter pw) {
        this.m_pw = pw;
    }

    public void printEntry(LDAPEntry entry) throws IOException {
        this.printEntryStart(entry.getDN());
        LDAPAttributeSet attrs = entry.getAttributeSet();
        Enumeration<LDAPAttribute> enumAttrs = attrs.getAttributes();
        while (enumAttrs.hasMoreElements()) {
            LDAPAttribute anAttr = enumAttrs.nextElement();
            this.printAttribute(anAttr);
        }
        this.printEntryEnd(entry.getDN());
    }

    public void printSchema(LDAPEntry entry) throws IOException {
        this.printEntry(entry);
    }

    protected abstract void printAttribute(LDAPAttribute var1);

    protected abstract void printEntryStart(String var1);

    protected abstract void printEntryEnd(String var1);

    protected String getPrintableValue(byte[] b) {
        String s = "";
        ByteBuf inBuf = new ByteBuf(b, 0, b.length);
        ByteBuf encodedBuf = new ByteBuf();
        m_encoder.translate(inBuf, encodedBuf);
        int nBytes = encodedBuf.length();
        if (nBytes > 0) {
            s = new String(encodedBuf.toBytes(), 0, nBytes);
        }
        return s;
    }
}

