/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"os"
	"reflect"
)


// PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI service
type PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService service

type PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService
	distroBasePath string
	path string
	name *string
	company *string
	email *string
	description *string
	resources *string
	links *[]NamespaceLink
	avatar *os.File
}

// Required named, only accepts lowercase, numbers and underscores.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest) Name(name string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest {
	r.name = &name
	return r
}

// Optional namespace company owner.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest) Company(company string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest {
	r.company = &company
	return r
}

// Optional namespace contact email.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest) Email(email string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest {
	r.email = &email
	return r
}

// Optional short description.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest) Description(description string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest {
	r.description = &description
	return r
}

// Optional resource page in markdown format.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest) Resources(resources string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest {
	r.resources = &resources
	return r
}

// Labeled related links.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest) Links(links []NamespaceLink) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest {
	r.links = &links
	return r
}

// Optional avatar image for Namespace
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest) Avatar(avatar *os.File) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest {
	r.avatar = avatar
	return r
}

func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateExecute(r)
}

/*
PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreate Method for PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreate

Custom exception handler mixin class.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param distroBasePath
 @param path
 @return PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest
*/
func (a *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService) PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreate(ctx context.Context, distroBasePath string, path string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest {
	return PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest{
		ApiService: a,
		ctx: ctx,
		distroBasePath: distroBasePath,
		path: path,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService) PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateExecute(r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService.PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/"
	localVarPath = strings.Replace(localVarPath, "{"+"distro_base_path"+"}", parameterValueToString(r.distroBasePath, "distroBasePath"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.name == nil {
		return localVarReturnValue, nil, reportError("name is required and must be specified")
	}
	if strlen(*r.name) < 3 {
		return localVarReturnValue, nil, reportError("name must have at least 3 elements")
	}
	if strlen(*r.name) > 64 {
		return localVarReturnValue, nil, reportError("name must have less than 64 elements")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	parameterAddToHeaderOrQuery(localVarFormParams, "name", r.name, "")
	if r.company != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "company", r.company, "")
	}
	if r.email != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "email", r.email, "")
	}
	if r.description != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "description", r.description, "")
	}
	if r.resources != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "resources", r.resources, "")
	}
	if r.links != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "links", r.links, "csv")
	}
	var avatarLocalVarFormFileName string
	var avatarLocalVarFileName     string
	var avatarLocalVarFileBytes    []byte

	avatarLocalVarFormFileName = "avatar"


	avatarLocalVarFile := r.avatar

	if avatarLocalVarFile != nil {
		fbs, _ := io.ReadAll(avatarLocalVarFile)

		avatarLocalVarFileBytes = fbs
		avatarLocalVarFileName = avatarLocalVarFile.Name()
		avatarLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: avatarLocalVarFileBytes, fileName: avatarLocalVarFileName, formFileName: avatarLocalVarFormFileName})
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDeleteRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService
	distroBasePath string
	name string
	path string
}

func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDeleteExecute(r)
}

/*
PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDelete Method for PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDelete

Try to remove the Namespace if no Collections under Namespace are present.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param distroBasePath
 @param name
 @param path
 @return PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDeleteRequest
*/
func (a *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService) PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDelete(ctx context.Context, distroBasePath string, name string, path string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDeleteRequest {
	return PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDeleteRequest{
		ApiService: a,
		ctx: ctx,
		distroBasePath: distroBasePath,
		name: name,
		path: path,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService) PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDeleteExecute(r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService.PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/"
	localVarPath = strings.Replace(localVarPath, "{"+"distro_base_path"+"}", parameterValueToString(r.distroBasePath, "distroBasePath"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", parameterValueToString(r.name, "name"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService
	distroBasePath string
	path string
	company *string
	companyContains *string
	companyIcontains *string
	companyIn *[]string
	companyStartswith *string
	limit *int32
	metadataSha256 *string
	metadataSha256In *[]string
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Filter results where company matches value
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) Company(company string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.company = &company
	return r
}

// Filter results where company contains value
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) CompanyContains(companyContains string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.companyContains = &companyContains
	return r
}

// Filter results where company contains value
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) CompanyIcontains(companyIcontains string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.companyIcontains = &companyIcontains
	return r
}

// Filter results where company is in a comma-separated list of values
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) CompanyIn(companyIn []string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.companyIn = &companyIn
	return r
}

// Filter results where company starts with value
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) CompanyStartswith(companyStartswith string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.companyStartswith = &companyStartswith
	return r
}

// Number of results to return per page.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) Limit(limit int32) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.limit = &limit
	return r
}

// Filter results where metadata_sha256 matches value
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) MetadataSha256(metadataSha256 string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.metadataSha256 = &metadataSha256
	return r
}

// Filter results where metadata_sha256 is in a comma-separated list of values
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) MetadataSha256In(metadataSha256In []string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.metadataSha256In = &metadataSha256In
	return r
}

// Filter results where name matches value
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) Name(name string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) NameContains(nameContains string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) NameIcontains(nameIcontains string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) NameIn(nameIn []string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) NameStartswith(nameStartswith string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) Offset(offset int32) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;company&#x60; - Company * &#x60;-company&#x60; - Company (descending) * &#x60;email&#x60; - Email * &#x60;-email&#x60; - Email (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;resources&#x60; - Resources * &#x60;-resources&#x60; - Resources (descending) * &#x60;links&#x60; - Links * &#x60;-links&#x60; - Links (descending) * &#x60;avatar_sha256&#x60; - Avatar sha256 * &#x60;-avatar_sha256&#x60; - Avatar sha256 (descending) * &#x60;metadata_sha256&#x60; - Metadata sha256 * &#x60;-metadata_sha256&#x60; - Metadata sha256 (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) Ordering(ordering []string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) PulpHrefIn(pulpHrefIn []string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) PulpIdIn(pulpIdIn []string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) Fields(fields []string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) ExcludeFields(excludeFields []string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) Execute() (*PaginatedansibleAnsibleNamespaceMetadataResponseList, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListExecute(r)
}

/*
PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesList Method for PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesList

Custom exception handler mixin class.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param distroBasePath
 @param path
 @return PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest
*/
func (a *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService) PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesList(ctx context.Context, distroBasePath string, path string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest {
	return PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest{
		ApiService: a,
		ctx: ctx,
		distroBasePath: distroBasePath,
		path: path,
	}
}

// Execute executes the request
//  @return PaginatedansibleAnsibleNamespaceMetadataResponseList
func (a *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService) PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListExecute(r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesListRequest) (*PaginatedansibleAnsibleNamespaceMetadataResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedansibleAnsibleNamespaceMetadataResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService.PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/"
	localVarPath = strings.Replace(localVarPath, "{"+"distro_base_path"+"}", parameterValueToString(r.distroBasePath, "distroBasePath"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.company != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "company", r.company, "")
	}
	if r.companyContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "company__contains", r.companyContains, "")
	}
	if r.companyIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "company__icontains", r.companyIcontains, "")
	}
	if r.companyIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "company__in", r.companyIn, "csv")
	}
	if r.companyStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "company__startswith", r.companyStartswith, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.metadataSha256 != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "metadata_sha256", r.metadataSha256, "")
	}
	if r.metadataSha256In != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "metadata_sha256__in", r.metadataSha256In, "csv")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService
	distroBasePath string
	name string
	path string
	name2 *string
	company *string
	email *string
	description *string
	resources *string
	links *[]NamespaceLink
	avatar *os.File
}

// Required named, only accepts lowercase, numbers and underscores.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest) Name2(name2 string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest {
	r.name2 = &name2
	return r
}

// Optional namespace company owner.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest) Company(company string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest {
	r.company = &company
	return r
}

// Optional namespace contact email.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest) Email(email string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest {
	r.email = &email
	return r
}

// Optional short description.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest) Description(description string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest {
	r.description = &description
	return r
}

// Optional resource page in markdown format.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest) Resources(resources string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest {
	r.resources = &resources
	return r
}

// Labeled related links.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest) Links(links []NamespaceLink) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest {
	r.links = &links
	return r
}

// Optional avatar image for Namespace
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest) Avatar(avatar *os.File) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest {
	r.avatar = avatar
	return r
}

func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateExecute(r)
}

/*
PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdate Method for PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdate

Custom exception handler mixin class.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param distroBasePath
 @param name
 @param path
 @return PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest
*/
func (a *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService) PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdate(ctx context.Context, distroBasePath string, name string, path string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest {
	return PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		distroBasePath: distroBasePath,
		name: name,
		path: path,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService) PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateExecute(r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService.PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/"
	localVarPath = strings.Replace(localVarPath, "{"+"distro_base_path"+"}", parameterValueToString(r.distroBasePath, "distroBasePath"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", parameterValueToString(r.name, "name"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.name2 != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "name", r.name2, "")
	}
	if r.company != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "company", r.company, "")
	}
	if r.email != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "email", r.email, "")
	}
	if r.description != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "description", r.description, "")
	}
	if r.resources != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "resources", r.resources, "")
	}
	if r.links != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "links", r.links, "csv")
	}
	var avatarLocalVarFormFileName string
	var avatarLocalVarFileName     string
	var avatarLocalVarFileBytes    []byte

	avatarLocalVarFormFileName = "avatar"


	avatarLocalVarFile := r.avatar

	if avatarLocalVarFile != nil {
		fbs, _ := io.ReadAll(avatarLocalVarFile)

		avatarLocalVarFileBytes = fbs
		avatarLocalVarFileName = avatarLocalVarFile.Name()
		avatarLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: avatarLocalVarFileBytes, fileName: avatarLocalVarFileName, formFileName: avatarLocalVarFormFileName})
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService
	distroBasePath string
	name string
	path string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadRequest) Fields(fields []string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadRequest) ExcludeFields(excludeFields []string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadRequest) Execute() (*AnsibleAnsibleNamespaceMetadataResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadExecute(r)
}

/*
PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesRead Method for PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesRead

Custom exception handler mixin class.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param distroBasePath
 @param name
 @param path
 @return PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadRequest
*/
func (a *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService) PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesRead(ctx context.Context, distroBasePath string, name string, path string) PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadRequest {
	return PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadRequest{
		ApiService: a,
		ctx: ctx,
		distroBasePath: distroBasePath,
		name: name,
		path: path,
	}
}

// Execute executes the request
//  @return AnsibleAnsibleNamespaceMetadataResponse
func (a *PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService) PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadExecute(r PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIPulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesReadRequest) (*AnsibleAnsibleNamespaceMetadataResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleAnsibleNamespaceMetadataResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleApiV3PluginAnsibleContentNamespacesAPIService.PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/"
	localVarPath = strings.Replace(localVarPath, "{"+"distro_base_path"+"}", parameterValueToString(r.distroBasePath, "distroBasePath"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", parameterValueToString(r.name, "name"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
