/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the OstreeImportCommitsToRef type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &OstreeImportCommitsToRef{}

// OstreeImportCommitsToRef A Serializer class for appending child commits to a repository.
type OstreeImportCommitsToRef struct {
	// An artifact representing OSTree content compressed as a tarball.
	Artifact string `json:"artifact"`
	// The name of a repository that contains the compressed OSTree content.
	RepositoryName string `json:"repository_name"`
	// The name of a ref branch that holds the reference to the last commit.
	Ref string `json:"ref"`
	AdditionalProperties map[string]interface{}
}

type _OstreeImportCommitsToRef OstreeImportCommitsToRef

// NewOstreeImportCommitsToRef instantiates a new OstreeImportCommitsToRef object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewOstreeImportCommitsToRef(artifact string, repositoryName string, ref string) *OstreeImportCommitsToRef {
	this := OstreeImportCommitsToRef{}
	this.Artifact = artifact
	this.RepositoryName = repositoryName
	this.Ref = ref
	return &this
}

// NewOstreeImportCommitsToRefWithDefaults instantiates a new OstreeImportCommitsToRef object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewOstreeImportCommitsToRefWithDefaults() *OstreeImportCommitsToRef {
	this := OstreeImportCommitsToRef{}
	return &this
}

// GetArtifact returns the Artifact field value
func (o *OstreeImportCommitsToRef) GetArtifact() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value
// and a boolean to check if the value has been set.
func (o *OstreeImportCommitsToRef) GetArtifactOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Artifact, true
}

// SetArtifact sets field value
func (o *OstreeImportCommitsToRef) SetArtifact(v string) {
	o.Artifact = v
}

// GetRepositoryName returns the RepositoryName field value
func (o *OstreeImportCommitsToRef) GetRepositoryName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.RepositoryName
}

// GetRepositoryNameOk returns a tuple with the RepositoryName field value
// and a boolean to check if the value has been set.
func (o *OstreeImportCommitsToRef) GetRepositoryNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.RepositoryName, true
}

// SetRepositoryName sets field value
func (o *OstreeImportCommitsToRef) SetRepositoryName(v string) {
	o.RepositoryName = v
}

// GetRef returns the Ref field value
func (o *OstreeImportCommitsToRef) GetRef() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Ref
}

// GetRefOk returns a tuple with the Ref field value
// and a boolean to check if the value has been set.
func (o *OstreeImportCommitsToRef) GetRefOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Ref, true
}

// SetRef sets field value
func (o *OstreeImportCommitsToRef) SetRef(v string) {
	o.Ref = v
}

func (o OstreeImportCommitsToRef) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o OstreeImportCommitsToRef) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["artifact"] = o.Artifact
	toSerialize["repository_name"] = o.RepositoryName
	toSerialize["ref"] = o.Ref

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *OstreeImportCommitsToRef) UnmarshalJSON(bytes []byte) (err error) {
	varOstreeImportCommitsToRef := _OstreeImportCommitsToRef{}

	if err = json.Unmarshal(bytes, &varOstreeImportCommitsToRef); err == nil {
		*o = OstreeImportCommitsToRef(varOstreeImportCommitsToRef)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "repository_name")
		delete(additionalProperties, "ref")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableOstreeImportCommitsToRef struct {
	value *OstreeImportCommitsToRef
	isSet bool
}

func (v NullableOstreeImportCommitsToRef) Get() *OstreeImportCommitsToRef {
	return v.value
}

func (v *NullableOstreeImportCommitsToRef) Set(val *OstreeImportCommitsToRef) {
	v.value = val
	v.isSet = true
}

func (v NullableOstreeImportCommitsToRef) IsSet() bool {
	return v.isSet
}

func (v *NullableOstreeImportCommitsToRef) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableOstreeImportCommitsToRef(val *OstreeImportCommitsToRef) *NullableOstreeImportCommitsToRef {
	return &NullableOstreeImportCommitsToRef{value: val, isSet: true}
}

func (v NullableOstreeImportCommitsToRef) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableOstreeImportCommitsToRef) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


