/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.provider.javax.crypto.JSSKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSSTokenKeyManager
implements JSSKeyManager {
    static final Logger logger = LoggerFactory.getLogger(JSSTokenKeyManager.class);
    private KeyStore jks;
    private CryptoManager cm;
    private char[] password;

    public JSSTokenKeyManager(KeyStore jssKeyStore, char[] password) {
        this.jks = jssKeyStore;
        this.password = password;
        try {
            this.cm = CryptoManager.getInstance();
        }
        catch (NotInitializedException nie) {
            Object msg = "CryptoManager reported as not initialized but have ";
            msg = (String)msg + "a working KeyStore instance! " + nie.getMessage();
            throw new RuntimeException((String)msg, nie);
        }
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        logger.debug("JSSKeyManager: chooseClientAlias() - not implemented");
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        logger.debug("JSSKeyManager: chooseServerAlias() - not implemented");
        return null;
    }

    @Override
    public org.mozilla.jss.crypto.X509Certificate getCertificate(String alias) {
        try {
            if (this.jks == null) {
                return this.cm.findCertByNickname(alias);
            }
            return (org.mozilla.jss.crypto.X509Certificate)((Object)this.jks.getCertificate(alias));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        logger.debug("JSSKeyManager: getCertificateChain(" + alias + ")");
        try {
            org.mozilla.jss.crypto.X509Certificate cert = this.getCertificate(alias);
            org.mozilla.jss.crypto.X509Certificate[] chain = this.cm.buildCertificateChain(cert);
            logger.debug("JSSKeyManager: cert chain:");
            ArrayList<PK11Cert> list = new ArrayList<PK11Cert>();
            for (org.mozilla.jss.crypto.X509Certificate c : chain) {
                logger.debug("JSSKeyManager: - " + c.getSubjectDN());
                list.add((PK11Cert)c);
            }
            return list.toArray(new X509Certificate[list.size()]);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        logger.debug("JSSKeyManager: getClientAliases() - not implemented");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PrivateKey getPrivateKey(String alias) {
        org.mozilla.jss.crypto.PrivateKey privateKey;
        logger.debug("JSSKeyManager: getPrivateKey(" + alias + ")");
        if (this.jks != null) return (PrivateKey)this.jks.getKey(alias, this.password);
        PK11Cert cert = (PK11Cert)this.cm.findCertByNickname(alias);
        try {
            org.mozilla.jss.crypto.PrivateKey key;
            privateKey = key = this.cm.findPrivKeyByCert(cert);
            if (cert == null) return privateKey;
        }
        catch (Throwable throwable) {
            try {
                if (cert == null) throw throwable;
                try {
                    cert.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        cert.close();
        return privateKey;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        logger.debug("JSSKeyManager: getServerAliases() - not implemented");
        return null;
    }
}

