/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KBKDFByteArrayParam;
import org.mozilla.jss.crypto.KBKDFCounterParams;
import org.mozilla.jss.crypto.KBKDFDataParameter;
import org.mozilla.jss.crypto.KBKDFFeedbackParams;
import org.mozilla.jss.crypto.KBKDFIterationVariableParam;
import org.mozilla.jss.crypto.KBKDFOptionalCounterParam;
import org.mozilla.jss.crypto.KBKDFPipelineParams;
import org.mozilla.jss.crypto.PKCS11Algorithm;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenSupplier;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.pkcs11.PK11Token;

public class TestKBKDF {
    public static void main(String[] args) throws Exception {
        CryptoManager cm = CryptoManager.getInstance();
        TokenSupplier ts = TokenSupplierManager.getTokenSupplier();
        ts.setThreadToken(cm.getInternalCryptoToken());
        TestKBKDF.testCounterKDFNistCMAC();
        TestKBKDF.testFeedbackKDFNistCMAC();
        TestKBKDF.testPipelineKDFNistCMAC();
    }

    public static void testCounterKDFNistCMAC() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("KbkdfCounterData", "Mozilla-JSS");
        SecretKeyFactory skf = SecretKeyFactory.getInstance("AES", "Mozilla-JSS");
        byte[] prf_key_bytes = Base64.getDecoder().decode("3/HlCsC2ncQPEFHUbCsGnA==");
        SecretKey prf_key = skf.generateSecret(new SecretKeySpec(prf_key_bytes, "AES"));
        SymmetricKey smkey = ((SecretKeyFacade)prf_key).key;
        CryptoToken token = smkey.getOwningToken();
        PK11Token tkn = (PK11Token)token;
        KBKDFCounterParams kcp = new KBKDFCounterParams();
        kcp.setPRF(PKCS11Algorithm.CKM_AES_CMAC);
        kcp.setPRFKey(prf_key);
        kcp.setKeySize(16);
        kcp.setDerivedKeyAlgorithm(PKCS11Algorithm.CKM_SHA_512_HMAC);
        kcp.addParameter((KBKDFDataParameter)new KBKDFIterationVariableParam(true, 8L));
        byte[] byte_array_param = Base64.getDecoder().decode("wW5uAsWj3MjXi5rBMGh3dhMQRVtOQUaZUdnmwiRaBksz/Yw7ASA6eCRIW/CmQGDEZItwfSYHk1aZMW6l");
        kcp.addParameter((KBKDFDataParameter)new KBKDFByteArrayParam(byte_array_param));
        kg.init((AlgorithmParameterSpec)kcp);
        SecretKey key = kg.generateKey();
        assert (key != null);
        byte[] encoded = key.getEncoded();
        byte[] expected = Base64.getDecoder().decode("i+jwhps8C6l7cYY9G594Ew==");
        assert (Arrays.equals(encoded, expected));
    }

    public static void testFeedbackKDFNistCMAC() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("KbkdfFeedbackData", "Mozilla-JSS");
        SecretKeyFactory skf = SecretKeyFactory.getInstance("AES", "Mozilla-JSS");
        byte[] prf_key_bytes = Base64.getDecoder().decode("ILu+NunIPFGETNMenCCUMQ==");
        SecretKey prf_key = skf.generateSecret(new SecretKeySpec(prf_key_bytes, "AES"));
        SymmetricKey smkey = ((SecretKeyFacade)prf_key).key;
        CryptoToken token = smkey.getOwningToken();
        PK11Token tkn = (PK11Token)token;
        KBKDFFeedbackParams kfp = new KBKDFFeedbackParams();
        kfp.setPRF(PKCS11Algorithm.CKM_AES_CMAC);
        kfp.setPRFKey(prf_key);
        kfp.setKeySize(64);
        kfp.setDerivedKeyAlgorithm(PKCS11Algorithm.CKM_SHA_512_HMAC);
        kfp.addParameter((KBKDFDataParameter)new KBKDFOptionalCounterParam(true, 8L));
        kfp.addParameter((KBKDFDataParameter)new KBKDFIterationVariableParam());
        byte[] byte_array_param = Base64.getDecoder().decode("61B6/2n3fqtqugQgNKXLGZDXenzXKkmE8/skL7RM4PuUnpnZXYHlcQm31c03RqMhbEej");
        kfp.addParameter((KBKDFDataParameter)new KBKDFByteArrayParam(byte_array_param));
        byte[] iv = Base64.getDecoder().decode("KPKKUyw744XXLsUyE2f4tg==");
        kfp.setInitialValue(iv);
        kg.init((AlgorithmParameterSpec)kfp);
        SecretKey key = kg.generateKey();
        assert (key != null);
        byte[] encoded = key.getEncoded();
        byte[] expected = Base64.getDecoder().decode("J3pHPT9RSvP3YKI4M0PA63mfeanI8fMds34RBHhtO6IMn7KkLSmXzKt/eaXBnwlHBtMuCbzk93rtYWKvCNidHQ==");
        assert (Arrays.equals(encoded, expected));
    }

    public static void testPipelineKDFNistCMAC() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("KbkdfPipelineData", "Mozilla-JSS");
        SecretKeyFactory skf = SecretKeyFactory.getInstance("AES", "Mozilla-JSS");
        byte[] prf_key_bytes = Base64.getDecoder().decode("xiVNld0QjpuyngBT3e7DUQ==");
        SecretKey prf_key = skf.generateSecret(new SecretKeySpec(prf_key_bytes, "AES"));
        SymmetricKey smkey = ((SecretKeyFacade)prf_key).key;
        CryptoToken token = smkey.getOwningToken();
        PK11Token tkn = (PK11Token)token;
        KBKDFPipelineParams kcp = new KBKDFPipelineParams();
        kcp.setPRF(PKCS11Algorithm.CKM_AES_CMAC);
        kcp.setPRFKey(prf_key);
        kcp.setKeySize(64);
        kcp.setDerivedKeyAlgorithm(PKCS11Algorithm.CKM_SHA_512_HMAC);
        kcp.addParameter((KBKDFDataParameter)new KBKDFOptionalCounterParam(true, 8L));
        kcp.addParameter((KBKDFDataParameter)new KBKDFIterationVariableParam());
        byte[] byte_array_param = Base64.getDecoder().decode("IvSY/JuNS3IYi84wuph1/CsOs/52h02FQm5uWzsjfJ9EXy2iCmCrGJgC4sFSxKNgKqNC");
        kcp.addParameter((KBKDFDataParameter)new KBKDFByteArrayParam(byte_array_param));
        kg.init((AlgorithmParameterSpec)kcp);
        SecretKey key = kg.generateKey();
        assert (key != null);
        byte[] encoded = key.getEncoded();
        byte[] expected = Base64.getDecoder().decode("HhM6lS31WhHuA4EgN19h58AWKELIFxYGk7HzncC3lbxvNpHbd1zzr0sKn2n+y+mWef1LSHPdp0P1xqLS6HPybQ==");
        assert (Arrays.equals(encoded, expected));
    }
}

