/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.TeletexString;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.asn1.UniversalString;

public class DirectoryString
implements ASN1Value {
    private CharacterString asn1String;
    private static final Template templateInstance = new Template();

    public DirectoryString(String s) throws CharConversionException {
        try {
            try {
                this.asn1String = new PrintableString(s);
            }
            catch (CharConversionException e) {
                this.asn1String = new TeletexString(s);
            }
        }
        catch (CharConversionException e) {
            this.asn1String = new UniversalString(s);
        }
    }

    public DirectoryString(CharacterString s) {
        if (!(s instanceof PrintableString || s instanceof BMPString || s instanceof UTF8String || s instanceof TeletexString || s instanceof UniversalString)) {
            throw new IllegalArgumentException("DirectoryString must be TeletexString, PrintableString, UniversalString, UTF8STring, or BMPString");
        }
        this.asn1String = s;
    }

    public String toString() {
        return this.asn1String.toString();
    }

    @Override
    public Tag getTag() {
        return this.asn1String.getTag();
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.asn1String.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.asn1String.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(PrintableString.getTemplate());
            this.choicet.addElement(BMPString.getTemplate());
            this.choicet.addElement(UTF8String.getTemplate());
            this.choicet.addElement(TeletexString.getTemplate());
            this.choicet.addElement(UniversalString.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE choice = (CHOICE)this.choicet.decode(istream);
            return new DirectoryString((CharacterString)choice.getValue());
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            assert (this.tagMatch(implicitTag));
            return this.decode(istream);
        }
    }
}

