/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaElement;
import com.netscape.jndi.ldap.schema.SchemaManager;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPObjectClassSchema;

public class SchemaObjectClass
extends SchemaElement {
    LDAPObjectClassSchema m_ldapObjectClass;
    private static String[] m_allAttrIds = new String[]{"NUMERICOID", "NAME", "DESC", "OBSOLETE", "SUP", "ABSTRACT", "STRUCTURAL", "AUXILIARY", "MUST", "MAY"};

    public SchemaObjectClass(LDAPObjectClassSchema ldapObjectClass, SchemaManager schemaManager) {
        super(schemaManager);
        this.m_ldapObjectClass = ldapObjectClass;
        this.m_path = "ClassDefinition/" + this.m_ldapObjectClass.getName();
    }

    public SchemaObjectClass(Attributes attrs, SchemaManager schemaManager) throws NamingException {
        super(schemaManager);
        this.m_ldapObjectClass = SchemaObjectClass.parseDefAttributes(attrs);
        this.m_path = "ClassDefinition/" + this.m_ldapObjectClass.getName();
    }

    static LDAPObjectClassSchema parseDefAttributes(Attributes attrs) throws NamingException {
        String name = null;
        String oid = null;
        String desc = null;
        String sup = null;
        boolean obsolete = false;
        boolean abs = false;
        boolean structural = false;
        boolean aux = false;
        Vector<Object> must = new Vector<Object>();
        Vector<Object> may = new Vector<Object>();
        NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
        while (attrEnum.hasMoreElements()) {
            NamingEnumeration<?> valEnum;
            Attribute attr = (Attribute)attrEnum.nextElement();
            String attrName = attr.getID();
            if (attrName.equals("NAME")) {
                name = SchemaObjectClass.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("NUMERICOID")) {
                oid = SchemaObjectClass.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("SUP")) {
                sup = SchemaObjectClass.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("DESC")) {
                desc = SchemaObjectClass.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("MAY")) {
                valEnum = attr.getAll();
                while (valEnum.hasMoreElements()) {
                    may.addElement(valEnum.nextElement());
                }
                continue;
            }
            if (attrName.equals("MUST")) {
                valEnum = attr.getAll();
                while (valEnum.hasMoreElements()) {
                    must.addElement(valEnum.nextElement());
                }
                continue;
            }
            if (attrName.equals("OBSOLETE")) {
                obsolete = SchemaObjectClass.parseTrueFalseValue(attr);
                continue;
            }
            if (attrName.equals("ABSTRACT")) {
                abs = SchemaObjectClass.parseTrueFalseValue(attr);
                continue;
            }
            if (attrName.equals("STRUCTURAL")) {
                structural = SchemaObjectClass.parseTrueFalseValue(attr);
                continue;
            }
            if (attrName.equals("AUXILIARY")) {
                aux = SchemaObjectClass.parseTrueFalseValue(attr);
                continue;
            }
            throw new NamingException("Invalid schema attribute type for object class definition " + attrName);
        }
        LDAPObjectClassSchema objectClass = new LDAPObjectClassSchema(name, oid, sup, desc, SchemaObjectClass.vectorToStringAry(must), SchemaObjectClass.vectorToStringAry(may));
        if (obsolete) {
            objectClass.setQualifier("OBSOLETE", "");
        }
        if (abs) {
            objectClass.setQualifier("ABSTRACT", "");
        }
        if (structural) {
            objectClass.setQualifier("STRUCTURAL", "");
        }
        if (aux) {
            objectClass.setQualifier("AUXILIARY", "");
        }
        return objectClass;
    }

    Attributes extractAttributeIds(String[] attrIds) throws NamingException {
        BasicAttributes attrs = new BasicAttributes();
        String val = null;
        Object multiVal = null;
        for (int i = 0; i < attrIds.length; ++i) {
            Enumeration e;
            if (attrIds[i].equals("NUMERICOID")) {
                val = this.m_ldapObjectClass.getID();
                if (val == null) continue;
                attrs.put(new BasicAttribute("NUMERICOID", val));
                continue;
            }
            if (attrIds[i].equals("NAME")) {
                val = this.m_ldapObjectClass.getName();
                if (val == null) continue;
                attrs.put(new BasicAttribute("NAME", val));
                continue;
            }
            if (attrIds[i].equals("DESC")) {
                val = this.m_ldapObjectClass.getDescription();
                if (val == null) continue;
                attrs.put(new BasicAttribute("DESC", val));
                continue;
            }
            if (attrIds[i].equals("SUP")) {
                val = this.m_ldapObjectClass.getSuperior();
                if (val == null) continue;
                attrs.put(new BasicAttribute("SUP", val));
                continue;
            }
            if (attrIds[i].equals("MAY")) {
                BasicAttribute optional = new BasicAttribute("MAY");
                e = this.m_ldapObjectClass.getOptionalAttributes();
                while (e.hasMoreElements()) {
                    optional.add(e.nextElement());
                }
                if (optional.size() == 0) continue;
                attrs.put(optional);
                continue;
            }
            if (attrIds[i].equals("MUST")) {
                BasicAttribute required = new BasicAttribute("MUST");
                e = this.m_ldapObjectClass.getRequiredAttributes();
                while (e.hasMoreElements()) {
                    required.add(e.nextElement());
                }
                if (required.size() == 0) continue;
                attrs.put(required);
                continue;
            }
            if (attrIds[i].equals("OBSOLETE")) {
                if (this.m_ldapObjectClass.getQualifier("OBSOLETE") == null) continue;
                attrs.put(new BasicAttribute("OBSOLETE", "true"));
                continue;
            }
            if (attrIds[i].equals("ABSTRACT")) {
                if (this.m_ldapObjectClass.getQualifier("ABSTRACT") == null) continue;
                attrs.put(new BasicAttribute("ABSTRACT", "true"));
                continue;
            }
            if (attrIds[i].equals("STRUCTURAL")) {
                if (this.m_ldapObjectClass.getQualifier("STRUCTURAL") == null) continue;
                attrs.put(new BasicAttribute("STRUCTURAL", "true"));
                continue;
            }
            if (attrIds[i].equals("AUXILIARY")) {
                if (this.m_ldapObjectClass.getQualifier("AUXILIARY") == null) continue;
                attrs.put(new BasicAttribute("AUXILIARY", "true"));
                continue;
            }
            throw new NamingException("Invalid schema attribute type for object class definition " + attrIds[i]);
        }
        return attrs;
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        return this.extractAttributeIds(m_allAttrIds);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        return this.extractAttributeIds(attrIds);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        Attributes modAttrs = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(modAttrs, mod_op, attrs);
        LDAPObjectClassSchema modLdapObjectClass = SchemaObjectClass.parseDefAttributes(modAttrs);
        this.m_schemaMgr.modifyObjectClass(this.m_ldapObjectClass, modLdapObjectClass);
        this.m_ldapObjectClass = modLdapObjectClass;
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        Attributes modAttrs = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(modAttrs, mods);
        LDAPObjectClassSchema modLdapObjectClass = SchemaObjectClass.parseDefAttributes(modAttrs);
        this.m_schemaMgr.modifyObjectClass(this.m_ldapObjectClass, modLdapObjectClass);
        this.m_ldapObjectClass = modLdapObjectClass;
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(name.toString(), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(name.toString(), mods);
    }
}

