/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// RemotesOstreeAPIService RemotesOstreeAPI service
type RemotesOstreeAPIService service

type RemotesOstreeAPIRemotesOstreeOstreeCreateRequest struct {
	ctx context.Context
	ApiService *RemotesOstreeAPIService
	ostreeOstreeRemote *OstreeOstreeRemote
}

func (r RemotesOstreeAPIRemotesOstreeOstreeCreateRequest) OstreeOstreeRemote(ostreeOstreeRemote OstreeOstreeRemote) RemotesOstreeAPIRemotesOstreeOstreeCreateRequest {
	r.ostreeOstreeRemote = &ostreeOstreeRemote
	return r
}

func (r RemotesOstreeAPIRemotesOstreeOstreeCreateRequest) Execute() (*OstreeOstreeRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesOstreeOstreeCreateExecute(r)
}

/*
RemotesOstreeOstreeCreate Create an ostree remote

A ViewSet class for OSTree remote repositories.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesOstreeAPIRemotesOstreeOstreeCreateRequest
*/
func (a *RemotesOstreeAPIService) RemotesOstreeOstreeCreate(ctx context.Context) RemotesOstreeAPIRemotesOstreeOstreeCreateRequest {
	return RemotesOstreeAPIRemotesOstreeOstreeCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return OstreeOstreeRemoteResponse
func (a *RemotesOstreeAPIService) RemotesOstreeOstreeCreateExecute(r RemotesOstreeAPIRemotesOstreeOstreeCreateRequest) (*OstreeOstreeRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *OstreeOstreeRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesOstreeAPIService.RemotesOstreeOstreeCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/ostree/ostree/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ostreeOstreeRemote == nil {
		return localVarReturnValue, nil, reportError("ostreeOstreeRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ostreeOstreeRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesOstreeAPIRemotesOstreeOstreeDeleteRequest struct {
	ctx context.Context
	ApiService *RemotesOstreeAPIService
	ostreeOstreeRemoteHref string
}

func (r RemotesOstreeAPIRemotesOstreeOstreeDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesOstreeOstreeDeleteExecute(r)
}

/*
RemotesOstreeOstreeDelete Delete an ostree remote

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRemoteHref
 @return RemotesOstreeAPIRemotesOstreeOstreeDeleteRequest
*/
func (a *RemotesOstreeAPIService) RemotesOstreeOstreeDelete(ctx context.Context, ostreeOstreeRemoteHref string) RemotesOstreeAPIRemotesOstreeOstreeDeleteRequest {
	return RemotesOstreeAPIRemotesOstreeOstreeDeleteRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRemoteHref: ostreeOstreeRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesOstreeAPIService) RemotesOstreeOstreeDeleteExecute(r RemotesOstreeAPIRemotesOstreeOstreeDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesOstreeAPIService.RemotesOstreeOstreeDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_remote_href"+"}", parameterValueToString(r.ostreeOstreeRemoteHref, "ostreeOstreeRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesOstreeAPIRemotesOstreeOstreeListRequest struct {
	ctx context.Context
	ApiService *RemotesOstreeAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	pulpLastUpdated *time.Time
	pulpLastUpdatedGt *time.Time
	pulpLastUpdatedGte *time.Time
	pulpLastUpdatedLt *time.Time
	pulpLastUpdatedLte *time.Time
	pulpLastUpdatedRange *[]time.Time
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) Limit(limit int32) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) Name(name string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) NameContains(nameContains string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) NameIcontains(nameIcontains string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) NameIn(nameIn []string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) NameStartswith(nameStartswith string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) Offset(offset int32) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;url&#x60; - Url * &#x60;-url&#x60; - Url (descending) * &#x60;ca_cert&#x60; - Ca cert * &#x60;-ca_cert&#x60; - Ca cert (descending) * &#x60;client_cert&#x60; - Client cert * &#x60;-client_cert&#x60; - Client cert (descending) * &#x60;client_key&#x60; - Client key * &#x60;-client_key&#x60; - Client key (descending) * &#x60;tls_validation&#x60; - Tls validation * &#x60;-tls_validation&#x60; - Tls validation (descending) * &#x60;username&#x60; - Username * &#x60;-username&#x60; - Username (descending) * &#x60;password&#x60; - Password * &#x60;-password&#x60; - Password (descending) * &#x60;proxy_url&#x60; - Proxy url * &#x60;-proxy_url&#x60; - Proxy url (descending) * &#x60;proxy_username&#x60; - Proxy username * &#x60;-proxy_username&#x60; - Proxy username (descending) * &#x60;proxy_password&#x60; - Proxy password * &#x60;-proxy_password&#x60; - Proxy password (descending) * &#x60;download_concurrency&#x60; - Download concurrency * &#x60;-download_concurrency&#x60; - Download concurrency (descending) * &#x60;max_retries&#x60; - Max retries * &#x60;-max_retries&#x60; - Max retries (descending) * &#x60;policy&#x60; - Policy * &#x60;-policy&#x60; - Policy (descending) * &#x60;total_timeout&#x60; - Total timeout * &#x60;-total_timeout&#x60; - Total timeout (descending) * &#x60;connect_timeout&#x60; - Connect timeout * &#x60;-connect_timeout&#x60; - Connect timeout (descending) * &#x60;sock_connect_timeout&#x60; - Sock connect timeout * &#x60;-sock_connect_timeout&#x60; - Sock connect timeout (descending) * &#x60;sock_read_timeout&#x60; - Sock read timeout * &#x60;-sock_read_timeout&#x60; - Sock read timeout (descending) * &#x60;headers&#x60; - Headers * &#x60;-headers&#x60; - Headers (descending) * &#x60;rate_limit&#x60; - Rate limit * &#x60;-rate_limit&#x60; - Rate limit (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) Ordering(ordering []string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) PulpHrefIn(pulpHrefIn []string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) PulpIdIn(pulpIdIn []string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) PulpLabelSelect(pulpLabelSelect string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Filter results where pulp_last_updated matches value
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) PulpLastUpdated(pulpLastUpdated time.Time) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.pulpLastUpdated = &pulpLastUpdated
	return r
}

// Filter results where pulp_last_updated is greater than value
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) PulpLastUpdatedGt(pulpLastUpdatedGt time.Time) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.pulpLastUpdatedGt = &pulpLastUpdatedGt
	return r
}

// Filter results where pulp_last_updated is greater than or equal to value
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) PulpLastUpdatedGte(pulpLastUpdatedGte time.Time) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.pulpLastUpdatedGte = &pulpLastUpdatedGte
	return r
}

// Filter results where pulp_last_updated is less than value
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) PulpLastUpdatedLt(pulpLastUpdatedLt time.Time) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.pulpLastUpdatedLt = &pulpLastUpdatedLt
	return r
}

// Filter results where pulp_last_updated is less than or equal to value
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) PulpLastUpdatedLte(pulpLastUpdatedLte time.Time) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.pulpLastUpdatedLte = &pulpLastUpdatedLte
	return r
}

// Filter results where pulp_last_updated is between two comma separated values
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) PulpLastUpdatedRange(pulpLastUpdatedRange []time.Time) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.pulpLastUpdatedRange = &pulpLastUpdatedRange
	return r
}

// A list of fields to include in the response.
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) Fields(fields []string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) ExcludeFields(excludeFields []string) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesOstreeAPIRemotesOstreeOstreeListRequest) Execute() (*PaginatedostreeOstreeRemoteResponseList, *http.Response, error) {
	return r.ApiService.RemotesOstreeOstreeListExecute(r)
}

/*
RemotesOstreeOstreeList List ostree remotes

A ViewSet class for OSTree remote repositories.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesOstreeAPIRemotesOstreeOstreeListRequest
*/
func (a *RemotesOstreeAPIService) RemotesOstreeOstreeList(ctx context.Context) RemotesOstreeAPIRemotesOstreeOstreeListRequest {
	return RemotesOstreeAPIRemotesOstreeOstreeListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedostreeOstreeRemoteResponseList
func (a *RemotesOstreeAPIService) RemotesOstreeOstreeListExecute(r RemotesOstreeAPIRemotesOstreeOstreeListRequest) (*PaginatedostreeOstreeRemoteResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedostreeOstreeRemoteResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesOstreeAPIService.RemotesOstreeOstreeList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/ostree/ostree/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.pulpLastUpdated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated", r.pulpLastUpdated, "")
	}
	if r.pulpLastUpdatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__gt", r.pulpLastUpdatedGt, "")
	}
	if r.pulpLastUpdatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__gte", r.pulpLastUpdatedGte, "")
	}
	if r.pulpLastUpdatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__lt", r.pulpLastUpdatedLt, "")
	}
	if r.pulpLastUpdatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__lte", r.pulpLastUpdatedLte, "")
	}
	if r.pulpLastUpdatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__range", r.pulpLastUpdatedRange, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesOstreeAPIRemotesOstreeOstreePartialUpdateRequest struct {
	ctx context.Context
	ApiService *RemotesOstreeAPIService
	ostreeOstreeRemoteHref string
	patchedostreeOstreeRemote *PatchedostreeOstreeRemote
}

func (r RemotesOstreeAPIRemotesOstreeOstreePartialUpdateRequest) PatchedostreeOstreeRemote(patchedostreeOstreeRemote PatchedostreeOstreeRemote) RemotesOstreeAPIRemotesOstreeOstreePartialUpdateRequest {
	r.patchedostreeOstreeRemote = &patchedostreeOstreeRemote
	return r
}

func (r RemotesOstreeAPIRemotesOstreeOstreePartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesOstreeOstreePartialUpdateExecute(r)
}

/*
RemotesOstreeOstreePartialUpdate Update an ostree remote

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRemoteHref
 @return RemotesOstreeAPIRemotesOstreeOstreePartialUpdateRequest
*/
func (a *RemotesOstreeAPIService) RemotesOstreeOstreePartialUpdate(ctx context.Context, ostreeOstreeRemoteHref string) RemotesOstreeAPIRemotesOstreeOstreePartialUpdateRequest {
	return RemotesOstreeAPIRemotesOstreeOstreePartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRemoteHref: ostreeOstreeRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesOstreeAPIService) RemotesOstreeOstreePartialUpdateExecute(r RemotesOstreeAPIRemotesOstreeOstreePartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesOstreeAPIService.RemotesOstreeOstreePartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_remote_href"+"}", parameterValueToString(r.ostreeOstreeRemoteHref, "ostreeOstreeRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedostreeOstreeRemote == nil {
		return localVarReturnValue, nil, reportError("patchedostreeOstreeRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedostreeOstreeRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesOstreeAPIRemotesOstreeOstreeReadRequest struct {
	ctx context.Context
	ApiService *RemotesOstreeAPIService
	ostreeOstreeRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesOstreeAPIRemotesOstreeOstreeReadRequest) Fields(fields []string) RemotesOstreeAPIRemotesOstreeOstreeReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesOstreeAPIRemotesOstreeOstreeReadRequest) ExcludeFields(excludeFields []string) RemotesOstreeAPIRemotesOstreeOstreeReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesOstreeAPIRemotesOstreeOstreeReadRequest) Execute() (*OstreeOstreeRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesOstreeOstreeReadExecute(r)
}

/*
RemotesOstreeOstreeRead Inspect an ostree remote

A ViewSet class for OSTree remote repositories.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRemoteHref
 @return RemotesOstreeAPIRemotesOstreeOstreeReadRequest
*/
func (a *RemotesOstreeAPIService) RemotesOstreeOstreeRead(ctx context.Context, ostreeOstreeRemoteHref string) RemotesOstreeAPIRemotesOstreeOstreeReadRequest {
	return RemotesOstreeAPIRemotesOstreeOstreeReadRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRemoteHref: ostreeOstreeRemoteHref,
	}
}

// Execute executes the request
//  @return OstreeOstreeRemoteResponse
func (a *RemotesOstreeAPIService) RemotesOstreeOstreeReadExecute(r RemotesOstreeAPIRemotesOstreeOstreeReadRequest) (*OstreeOstreeRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *OstreeOstreeRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesOstreeAPIService.RemotesOstreeOstreeRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_remote_href"+"}", parameterValueToString(r.ostreeOstreeRemoteHref, "ostreeOstreeRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesOstreeAPIRemotesOstreeOstreeUpdateRequest struct {
	ctx context.Context
	ApiService *RemotesOstreeAPIService
	ostreeOstreeRemoteHref string
	ostreeOstreeRemote *OstreeOstreeRemote
}

func (r RemotesOstreeAPIRemotesOstreeOstreeUpdateRequest) OstreeOstreeRemote(ostreeOstreeRemote OstreeOstreeRemote) RemotesOstreeAPIRemotesOstreeOstreeUpdateRequest {
	r.ostreeOstreeRemote = &ostreeOstreeRemote
	return r
}

func (r RemotesOstreeAPIRemotesOstreeOstreeUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesOstreeOstreeUpdateExecute(r)
}

/*
RemotesOstreeOstreeUpdate Update an ostree remote

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRemoteHref
 @return RemotesOstreeAPIRemotesOstreeOstreeUpdateRequest
*/
func (a *RemotesOstreeAPIService) RemotesOstreeOstreeUpdate(ctx context.Context, ostreeOstreeRemoteHref string) RemotesOstreeAPIRemotesOstreeOstreeUpdateRequest {
	return RemotesOstreeAPIRemotesOstreeOstreeUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRemoteHref: ostreeOstreeRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesOstreeAPIService) RemotesOstreeOstreeUpdateExecute(r RemotesOstreeAPIRemotesOstreeOstreeUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesOstreeAPIService.RemotesOstreeOstreeUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_remote_href"+"}", parameterValueToString(r.ostreeOstreeRemoteHref, "ostreeOstreeRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ostreeOstreeRemote == nil {
		return localVarReturnValue, nil, reportError("ostreeOstreeRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ostreeOstreeRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
