/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.logging.event.ConfigTrustedPublicKeyEvent;
import com.netscape.certsrv.selftests.EMissingSelfTestException;
import com.netscape.certsrv.selftests.ESelfTestException;
import com.netscape.cms.selftests.SelfTest;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmscore.selftests.SelfTestSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.KeyPair;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtag.util.cert.CertUtil;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.symkey.SessionKey;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSAdminServlet
extends AdminServlet {
    public static Logger logger = LoggerFactory.getLogger(CMSAdminServlet.class);
    private static final long serialVersionUID = 714370238027440050L;
    private static final String INFO = "CMSAdminServlet";
    private static final String PROP_SMTP = "smtp";

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public String getServletInfo() {
        return INFO;
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        try {
            super.authenticate(req);
        }
        catch (IOException e) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHS_FAILED", new String[0]), null, resp);
            return;
        }
        String scope = req.getParameter("OP_SCOPE");
        String op = req.getParameter("OP_TYPE");
        try {
            AUTHZ_RES_NAME = "certServer.general.configuration";
            if (scope.equals("platform")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                this.getEnv(resp);
                return;
            }
            if (op.equals("OP_READ")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("ldap")) {
                    this.getDBConfig(req, resp);
                } else if (scope.equals(PROP_SMTP)) {
                    this.readSMTPConfig(resp);
                } else if (scope.equals("stat")) {
                    this.readStat(resp);
                } else if (scope.equals("encryption")) {
                    this.readEncryption(resp);
                } else if (scope.equals("token")) {
                    this.getAllTokenNames(resp);
                } else if (scope.equals("subjectName")) {
                    this.getSubjectName(req, resp);
                } else if (scope.equals("getNicknames")) {
                    this.getAllNicknames(resp);
                } else if (scope.equals("certPrint")) {
                    this.getCertPrettyPrint(req, resp);
                }
            } else if (op.equals("OP_MODIFY")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("ldap")) {
                    this.setDBConfig(req, resp);
                } else if (scope.equals(PROP_SMTP)) {
                    this.modifySMTPConfig(req, resp);
                } else if (scope.equals("tasks")) {
                    this.performTasks(req, resp);
                } else if (scope.equals("encryption")) {
                    this.modifyEncryption(req, resp);
                } else if (scope.equals("issueImportCert")) {
                    this.issueImportCert(req, resp);
                } else if (scope.equals("installCert")) {
                    this.installCert(req, resp);
                } else if (scope.equals("importXCert")) {
                    this.importXCert(req, resp);
                } else if (scope.equals("deleteCert")) {
                    this.deleteCerts(req, resp);
                } else if (scope.equals("trust")) {
                    this.trustCACert(req, resp);
                } else if (scope.equals("tokenLogon")) {
                    this.loggedInToken(req, resp);
                } else if (scope.equals("rootTrustBit")) {
                    this.setRootCertTrust(req, resp);
                }
            } else if (op.equals("OP_SEARCH")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("subsystem")) {
                    this.readSubsystem(resp);
                } else if (scope.equals("caCertList")) {
                    this.getCACerts(resp);
                } else if (scope.equals("allCertList")) {
                    this.getAllCertsManage(resp);
                } else if (scope.equals("userCertsList")) {
                    this.getUserCerts(resp);
                } else if (scope.equals("tksKeysList")) {
                    this.getTKSKeys(req, resp);
                } else if (scope.equals("token")) {
                    this.getAllTokenNames(resp);
                } else if (scope.equals("rootCertsList")) {
                    this.getRootCerts(resp);
                }
            } else if (op.equals("OP_DELETE")) {
                this.mOp = "delete";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("rootCertsList")) {
                    this.deleteRootCert(req, resp);
                } else if (scope.equals("userCertsList")) {
                    this.deleteUserCert(req, resp);
                }
            } else if (op.equals("OP_PROCESS")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("certRequest")) {
                    this.getCertRequest(req, resp);
                } else if (scope.equals("subjectName")) {
                    this.processSubjectName(req, resp);
                } else if (scope.equals("certInfo")) {
                    this.getCertInfo(req, resp);
                } else if (scope.equals("certPrint")) {
                    this.getCertPrettyPrint(req, resp);
                } else if (scope.equals("rootTrustBit")) {
                    this.getRootCertTrustBit(req, resp);
                } else if (scope.equals("tokenStatus")) {
                    this.checkTokenStatus(req, resp);
                } else if (scope.equals("selftests")) {
                    this.runSelfTestsOnDemand(req, resp);
                } else if (scope.equals("tksKeysList")) {
                    this.createMasterKey(req, resp);
                }
            } else if (op.equals("OP_VALIDATE")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("subjectName")) {
                    this.validateSubjectName(req, resp);
                } else if (scope.equals("keyLength")) {
                    this.validateKeyLength(resp);
                } else if (scope.equals("certificateExt")) {
                    this.validateCertExtension(req, resp);
                } else if (scope.equals("keyCurveName")) {
                    this.validateCurveName(req, resp);
                }
            }
        }
        catch (EBaseException e) {
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
            return;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.sendResponse(1, "operation failure", null, resp);
            return;
        }
    }

    private void getEnv(HttpServletResponse resp) throws IOException {
        NameValuePairs params = new NameValuePairs();
        if (File.separator.equals("\\")) {
            params.put((Object)"NT", (Object)"true");
        } else {
            params.put((Object)"NT", (Object)"false");
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getAllTokenNames(HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"tokenlist", (Object)jssSubsystem.getTokenList());
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getAllNicknames(HttpServletResponse resp) throws IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        params.put((Object)"allNicknames", (Object)jssSubsystem.getAllCerts());
        this.sendResponse(SUCCESS, null, params, resp);
    }

    public boolean isSubsystemInstalled(String subsystem) {
        return false;
    }

    public void readEncryption(NameValuePairs params) throws EBaseException {
    }

    private void readEncryption(HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"cipherversion", (Object)jssSubsystem.getCipherVersion());
        params.put((Object)"cipherfortezza", (Object)jssSubsystem.isCipherFortezza());
        params.put((Object)"cipherpref", (Object)jssSubsystem.getCipherPreferences());
        String tokenList = jssSubsystem.getTokenList();
        Object tokenNewList = "";
        StringTokenizer tokenizer = new StringTokenizer(tokenList, ",");
        while (tokenizer.hasMoreElements()) {
            String tokenName = (String)tokenizer.nextElement();
            String certs = jssSubsystem.getCertListWithoutTokenName(tokenName);
            if (certs.equals("")) continue;
            tokenNewList = ((String)tokenNewList).equals("") ? (String)tokenNewList + tokenName : (String)tokenNewList + "," + tokenName;
            tokenName = this.escapeString(tokenName);
            params.put((Object)("token_" + tokenName), (Object)certs);
        }
        params.put((Object)"tokenlist", tokenNewList);
        this.readEncryption(params);
        String nickName = engine.getServerCertNickname();
        params.put((Object)"SERVER", (Object)this.getCertNickname(nickName));
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private String escapeString(String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, " ");
        StringBuffer tokenname = new StringBuffer();
        if (tokenizer.countTokens() == 1) {
            return name;
        }
        while (tokenizer.hasMoreElements()) {
            if (tokenizer.countTokens() == 1) {
                tokenname.append((String)tokenizer.nextElement());
                continue;
            }
            tokenname.append((String)tokenizer.nextElement());
            tokenname.append("%20");
        }
        return tokenname.toString();
    }

    public String getCertNickname(String nickName) {
        if (!nickName.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(nickName, ":");
            String tokenName = "";
            tokenName = tokenizer.countTokens() > 1 ? (String)tokenizer.nextElement() : "internal";
            return tokenName + "," + (String)tokenizer.nextElement();
        }
        return "";
    }

    public void modifyCACert(HttpServletRequest request, String value) throws EBaseException {
    }

    public void modifyKRACert(String nickname) throws EBaseException {
    }

    public void modifyServerCert(String nickname) throws EBaseException {
    }

    private void modifyEncryption(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            Enumeration enum1 = req.getParameterNames();
            NameValuePairs params = new NameValuePairs();
            JssSubsystem jssSubsystem = engine.getJSSSubsystem();
            jssSubsystem.getInternalTokenName();
            while (enum1.hasMoreElements()) {
                String nickName;
                String name = (String)enum1.nextElement();
                String val = req.getParameter(name);
                if (name.equals("cipherpref")) {
                    jssSubsystem.setCipherPreferences(val);
                    continue;
                }
                if (name.equals("CA")) {
                    if (val == null || val.equals("")) continue;
                    this.modifyCACert(req, val);
                    continue;
                }
                if (name.equals("TRANS")) {
                    if (val == null || val.equals("")) continue;
                    nickName = this.getCertConfigNickname(val);
                    this.modifyKRACert(nickName);
                    continue;
                }
                if (!name.equals("SERVER") || val == null || val.equals("")) continue;
                nickName = this.getCertConfigNickname(val);
                this.modifyRADMCert(nickName);
                this.modifyAgentGatewayCert(nickName);
                this.modifyServerCert(nickName);
            }
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ENCRYPTION_3", auditSubjectID, "Success", this.auditParams(req));
            auditor.log(auditMessage);
            this.sendResponse(RESTART, null, params, resp);
            this.mConfig.commit(true);
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ENCRYPTION_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ENCRYPTION_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    public String getCertConfigNickname(String val) throws EBaseException {
        StringTokenizer tokenizer = new StringTokenizer(val, ",");
        if (tokenizer.countTokens() != 2) {
            throw new EBaseException(CMS.getLogMessage("BASE_INVALID_UI_INFO", new Object[0]));
        }
        Object tokenName = (String)tokenizer.nextElement();
        tokenName = CryptoUtil.isInternalToken((String)tokenName) ? "" : (String)tokenName + ":";
        return (String)tokenName + (String)tokenizer.nextElement();
    }

    public void modifyRADMCert(String nickName) {
        CMSEngine engine = this.getCMSEngine();
        engine.setServerCertNickname(nickName);
    }

    public void modifyAgentGatewayCert(String nickName) {
        CMSEngine engine = this.getCMSEngine();
        engine.setServerCertNickname(nickName);
    }

    public void modifyCAGatewayCert(String nickname) {
    }

    private void performTasks(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String restart = req.getParameter("restart");
        String stop = req.getParameter("stop");
        NameValuePairs params = new NameValuePairs();
        if (restart != null) {
            this.sendResponse(SUCCESS, null, params, resp);
            return;
        }
        if (stop != null) {
            this.sendResponse(SUCCESS, null, params, resp);
            logger.debug("CMSAdminServlet.performTasks(): shutdown server");
            CMSEngine engine = this.getCMSEngine();
            engine.shutdown();
            return;
        }
        this.sendResponse(ERROR, "Unknown operation", null, resp);
    }

    void readSubsystem(NameValuePairs params) {
    }

    private void readSubsystem(HttpServletResponse resp) throws IOException {
        NameValuePairs params = new NameValuePairs();
        this.readSubsystem(params);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void readStat(HttpServletResponse resp) throws IOException {
        NameValuePairs params = new NameValuePairs();
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        try {
            String installdate = cs.getString("installDate", "");
            params.put((Object)"installDate", (Object)installdate);
        }
        catch (Exception installdate) {
            // empty catch block
        }
        try {
            String version = cs.getString("cms.version", "");
            params.put((Object)"cms.version", (Object)version);
        }
        catch (Exception version) {
            // empty catch block
        }
        try {
            String instanceId = cs.getInstanceID();
            params.put((Object)"instanceId", (Object)instanceId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        params.put((Object)"startup", (Object)new Date(engine.getStartupTime()).toString());
        params.put((Object)"time", (Object)new Date(System.currentTimeMillis()).toString());
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void setDBConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        LDAPConfig dbConfig = this.mConfig.getInternalDBConfig();
        Enumeration enum1 = req.getParameterNames();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            if (key.equals("OP_TYPE") || key.equals("RS_ID") || key.equals("OP_SCOPE")) continue;
            dbConfig.putString(key, req.getParameter(key));
        }
        this.sendResponse(RESTART, null, null, resp);
        this.mConfig.commit(true);
    }

    private void createMasterKey(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration e = req.getParameterNames();
        String newKeyName = null;
        String selectedToken = null;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("keylist")) {
                newKeyName = req.getParameter(name);
            }
            if (!name.equals("tokenlist")) continue;
            selectedToken = req.getParameter(name);
        }
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        if (selectedToken != null && newKeyName != null) {
            SessionKey.GenMasterKey(selectedToken, (String)newKeyName);
            cs.putString("tks.defaultSlot", selectedToken);
            String masterKeyPrefix = cs.getString("tks.master_key_prefix", null);
            SessionKey.SetDefaultPrefix((String)masterKeyPrefix);
            params.put((Object)"keylist", (Object)newKeyName);
            params.put((Object)"tokenlist", (Object)selectedToken);
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getTKSKeys(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration e = req.getParameterNames();
        CMSEngine engine = this.getCMSEngine();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.equals("tokenlist")) continue;
            String selectedToken = req.getParameter(name);
            JssSubsystem jssSubsystem = engine.getJSSSubsystem();
            CryptoToken token = null;
            if (!jssSubsystem.isTokenLoggedIn(selectedToken)) {
                ConsolePasswordCallback cpcb = new ConsolePasswordCallback();
                while (true) {
                    try {
                        token = CryptoUtil.getKeyStorageToken((String)selectedToken);
                        token.login((PasswordCallback)cpcb);
                    }
                    catch (Exception e3) {
                        continue;
                    }
                    break;
                }
            }
            String symKeys = SessionKey.ListSymmetricKeys((String)selectedToken);
            params.put((Object)"tokenlist", (Object)symKeys);
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getDBConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        DatabaseConfig dbConfig = this.mConfig.getDatabaseConfig();
        ConfigStore ldapConfig = dbConfig.getSubStore("ldap", ConfigStore.class);
        NameValuePairs params = new NameValuePairs();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE")) continue;
            if (name.equals("ldapconn.secureConn")) {
                params.put((Object)name, (Object)ldapConfig.getString(name, "Constants.FALSE"));
                continue;
            }
            params.put((Object)name, (Object)ldapConfig.getString(name, ""));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void modifySMTPConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        String port;
        ConfigStore sConfig = this.mConfig.getSubStore(PROP_SMTP, ConfigStore.class);
        String host = req.getParameter("server");
        if (host != null) {
            sConfig.putString("host", host);
        }
        if ((port = req.getParameter("port")) != null) {
            sConfig.putString("port", port);
        }
        this.commit(true);
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void readSMTPConfig(HttpServletResponse resp) throws IOException, EBaseException {
        ConfigStore dbConfig = this.mConfig.getSubStore(PROP_SMTP, ConfigStore.class);
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"server", (Object)dbConfig.getString("host"));
        params.put((Object)"port", (Object)dbConfig.getString("port"));
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void loggedInToken(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        Enumeration enum1 = req.getParameterNames();
        String tokenName = "";
        String pwd = "";
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (key.equals("tokenName")) {
                tokenName = value;
                continue;
            }
            if (!key.equals("tokenPwd")) continue;
            pwd = value;
        }
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        jssSubsystem.loggedInToken(tokenName, pwd);
        engine.putPasswordCache(tokenName, pwd);
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void checkTokenStatus(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        Enumeration enum1 = req.getParameterNames();
        String key = "";
        String value = "";
        while (enum1.hasMoreElements()) {
            key = (String)enum1.nextElement();
            value = req.getParameter(key);
            if (!key.equals("tokenName")) continue;
        }
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        boolean status = jssSubsystem.isTokenLoggedIn(value);
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"isLoggedIn", (Object)("" + status));
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getCertRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        String auditPublicKey = "<null>";
        try {
            CryptoToken token;
            NameValuePairs params = new NameValuePairs();
            Enumeration enum1 = req.getParameterNames();
            String tokenName = "internal";
            String keyType = "";
            int keyLength = 512;
            String subjectName = "";
            String certType = "caSigningCert";
            Object dir = "";
            Object pathname = "";
            String otherNickname = "";
            String keyCurveName = "";
            while (enum1.hasMoreElements()) {
                String key = (String)enum1.nextElement();
                String value = req.getParameter(key);
                if (key.equals("tokenName")) {
                    if (CryptoUtil.isInternalToken((String)value)) continue;
                    tokenName = value;
                    continue;
                }
                if (key.equals("keyLength")) {
                    keyLength = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("keyType")) {
                    keyType = value;
                    continue;
                }
                if (key.equals("RS_ID")) {
                    certType = value;
                    continue;
                }
                if (key.equals("subjectName")) {
                    subjectName = value;
                    continue;
                }
                if (key.equals("nickname")) {
                    otherNickname = value;
                    continue;
                }
                if (!key.equals("keyCurveName")) continue;
                keyCurveName = value;
            }
            dir = pathname = CMS.getInstanceDir() + File.separator + "conf" + File.separator;
            JssSubsystem jssSubsystem = engine.getJSSSubsystem();
            KeyPair keypair = null;
            PQGParams pqgParams = null;
            String nickname = "";
            if (certType.equals("otherCert") && keyType.equals("")) {
                nickname = otherNickname;
            } else if (!certType.equals("otherCert")) {
                nickname = this.getNickname(certType);
            }
            String nicknameWithoutTokenName = "";
            if (nickname != null && !nickname.equals("")) {
                int index = nickname.indexOf(":");
                nicknameWithoutTokenName = nickname;
                if (index >= 0) {
                    nicknameWithoutTokenName = nickname.substring(index + 1);
                }
            }
            try {
                token = CryptoUtil.getKeyStorageToken((String)tokenName);
            }
            catch (NoSuchTokenException | NotInitializedException e) {
                throw new EBaseException("Unable to find token: " + tokenName, e);
            }
            if (keyType.equals("")) {
                if (nickname.equals("")) {
                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_KEY_GEN_ASYMMETRIC_3", auditSubjectID, "Failure", auditPublicKey);
                    auditor.log(auditMessage);
                    throw new EBaseException(CMS.getLogMessage("BASE_CERT_NOT_FOUND", new Object[0]));
                }
                keypair = jssSubsystem.getKeyPair(nickname);
            } else if (keyType.equals("ECC")) {
                keypair = jssSubsystem.getECCKeyPair(token, keyCurveName, certType);
            } else {
                if (keyType.equals("DSA")) {
                    pqgParams = jssSubsystem.getPQG(keyLength);
                }
                keypair = jssSubsystem.getKeyPair(token, keyType, keyLength, pqgParams);
            }
            auditPublicKey = this.auditPublicKey(keypair);
            if (certType.equals("caSigningCert")) {
                pathname = (String)pathname + File.separator + "cacsr.txt";
                if (!keyType.equals("")) {
                    this.setCANewnickname(tokenName, nicknameWithoutTokenName);
                }
            } else if (certType.equals("ocspSigningCert")) {
                pathname = (String)pathname + File.separator + "ocspcsr.txt";
                if (!keyType.equals("")) {
                    this.setOCSPNewnickname(tokenName, nicknameWithoutTokenName);
                }
            } else if (certType.equals("kraTransportCert")) {
                pathname = (String)pathname + File.separator + "kracsr.txt";
                if (!keyType.equals("")) {
                    this.setKRANewnickname(tokenName, nicknameWithoutTokenName);
                }
            } else if (certType.equals("serverCert")) {
                pathname = (String)pathname + File.separator + "sslcsr.txt";
                if (!keyType.equals("")) {
                    this.setAgentNewnickname(tokenName, nicknameWithoutTokenName);
                }
            } else if (certType.equals("serverCertRadm")) {
                pathname = (String)pathname + File.separator + "sslcsrradm.txt";
                if (!keyType.equals("")) {
                    this.setRADMNewnickname(tokenName, nicknameWithoutTokenName);
                }
            } else if (certType.equals("otherCert")) {
                pathname = (String)pathname + File.separator + "othercsr.txt";
            }
            String certReq = jssSubsystem.getCertRequest(subjectName, keypair);
            params.put((Object)"csr", (Object)certReq);
            params.put((Object)"certReqDir", dir);
            PrintStream ps = new PrintStream(new FileOutputStream((String)pathname));
            ps.println(certReq);
            ps.close();
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_KEY_GEN_ASYMMETRIC_3", auditSubjectID, "Success", auditPublicKey);
            auditor.log(auditMessage);
            this.mConfig.commit(true);
            this.sendResponse(SUCCESS, null, params, resp);
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_KEY_GEN_ASYMMETRIC_3", auditSubjectID, "Failure", auditPublicKey);
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_KEY_GEN_ASYMMETRIC_3", auditSubjectID, "Failure", auditPublicKey);
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    String getCANewnickname() throws EBaseException {
        return null;
    }

    void setCANewnickname(String tokenName, String nickname) throws EBaseException {
    }

    void setOCSPNewnickname(String tokenName, String nickname) throws EBaseException {
    }

    String getOCSPNewnickname() throws EBaseException {
        return null;
    }

    String getKRANewnickname() throws EBaseException {
        return null;
    }

    void setKRANewnickname(String tokenName, String nickname) throws EBaseException {
    }

    String getKRANickname() throws EBaseException {
        return null;
    }

    void setKRANickname(String nickname) throws EBaseException {
    }

    private void setRADMNewnickname(String tokenName, String nickName) {
        CMSEngine engine = this.getCMSEngine();
        engine.setServerCertNickname(tokenName, nickName);
    }

    private String getRADMNewnickname() {
        CMSEngine engine = this.getCMSEngine();
        return engine.getServerCertNickname();
    }

    private void setAgentNewnickname(String tokenName, String nickName) {
        CMSEngine engine = this.getCMSEngine();
        engine.setServerCertNickname(tokenName, nickName);
    }

    private String getAgentNewnickname() {
        CMSEngine engine = this.getCMSEngine();
        return engine.getServerCertNickname();
    }

    public void issueImportCert(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
    }

    public void installCASigningCert(String fullName, String nickname, String tokenName) throws EBaseException {
    }

    public void installOCSPSigningCert(String fullName, String nickname, String tokenName) throws EBaseException {
    }

    private void installCert(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            int index;
            Object nicknameWithoutTokenName;
            Object nickname;
            String certType;
            block39: {
                String tokenName = "internal";
                String pkcs = "";
                certType = "";
                nickname = "";
                Object pathname = "";
                String serverRoot = "";
                String serverID = "";
                String certpath = "";
                Enumeration enum1 = req.getParameterNames();
                while (enum1.hasMoreElements()) {
                    String key = (String)enum1.nextElement();
                    String value = req.getParameter(key);
                    if (key.equals("pkcs10")) {
                        pkcs = value;
                        continue;
                    }
                    if (key.equals("RS_ID")) {
                        certType = value;
                        continue;
                    }
                    if (key.equals("nickname")) {
                        nickname = value;
                        continue;
                    }
                    if (key.equals("pathname")) {
                        pathname = value;
                        continue;
                    }
                    if (key.equals("serverRoot")) {
                        serverRoot = value;
                        continue;
                    }
                    if (key.equals("serverID")) {
                        serverID = value;
                        continue;
                    }
                    if (!key.equals("certFilePath")) continue;
                    certpath = value;
                }
                logger.debug("CMSAdminServlet: installCert(" + (String)nickname + ")");
                try {
                    if (pkcs == null || pkcs.equals("")) {
                        if (certpath == null || certpath.equals("")) {
                            auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
                            EBaseException ex = new EBaseException(CMS.getLogMessage("BASE_INVALID_FILE_PATH", new Object[0]));
                            throw ex;
                        }
                        FileInputStream in = new FileInputStream(certpath);
                        BufferedReader d = new BufferedReader(new InputStreamReader(in));
                        String content = "";
                        pkcs = "";
                        StringBuffer sb = new StringBuffer();
                        while ((content = d.readLine()) != null) {
                            sb.append(content);
                            sb.append("\n");
                        }
                        pkcs = sb.toString();
                        if (d != null) {
                            d.close();
                        }
                        pkcs = pkcs.substring(0, pkcs.length() - 1);
                    }
                }
                catch (IOException ee) {
                    auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    throw new EBaseException(CMS.getLogMessage("BASE_OPEN_FILE_FAILED", new Object[0]));
                }
                pkcs = pkcs.trim();
                pathname = serverRoot + File.separator + serverID + File.separator + "config" + File.separator + (String)pathname;
                JssSubsystem jssSubsystem = engine.getJSSSubsystem();
                nicknameWithoutTokenName = "";
                index = ((String)nickname).indexOf(":");
                if (index == -1) {
                    nicknameWithoutTokenName = nickname;
                } else if (index > 0 && index < ((String)nickname).length() - 1) {
                    tokenName = ((String)nickname).substring(0, index);
                    nicknameWithoutTokenName = ((String)nickname).substring(index + 1);
                } else {
                    auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    throw new EBaseException(CMS.getLogMessage("BASE_CERT_NOT_FOUND", new Object[0]));
                }
                logger.debug("CMSAdminServlet.installCert(): About to try jssSubSystem.importCert: " + (String)nicknameWithoutTokenName);
                try {
                    jssSubsystem.importCert(pkcs, (String)nicknameWithoutTokenName, certType);
                }
                catch (EBaseException e) {
                    boolean certFound = false;
                    String eString = e.toString();
                    if (eString.contains("Failed to find certificate that was just imported")) {
                        logger.debug("CMSAdminServlet.installCert(): nickname=" + (String)nicknameWithoutTokenName + " TokenException: " + eString);
                        X509Certificate cert = null;
                        try {
                            cert = CryptoManager.getInstance().findCertByNickname((String)nickname);
                            if (cert != null) {
                                certFound = true;
                            }
                            logger.debug("CMSAdminServlet.installCert() Found cert just imported: " + (String)nickname);
                        }
                        catch (Exception ex) {
                            logger.warn("CMSAdminServlet.installCert() Can't find cert just imported: " + ex.toString());
                        }
                    }
                    if (certFound) break block39;
                    Date now = new Date();
                    String newNickname = (String)nicknameWithoutTokenName + "-" + now.getTime();
                    jssSubsystem.importCert(pkcs, newNickname, certType);
                    nicknameWithoutTokenName = newNickname;
                    nickname = tokenName.equals("internal") ? newNickname : tokenName + ":" + newNickname;
                    logger.debug("CMSAdminServlet: installCert():  After second install attempt following initial error: nickname=" + (String)nickname);
                }
            }
            String tokenname1 = ((String)nickname).substring(0, index);
            if (certType.equals("caSigningCert")) {
                this.installCASigningCert((String)nickname, (String)nicknameWithoutTokenName, tokenname1);
            } else if (certType.equals("ocspSigningCert")) {
                this.installOCSPSigningCert((String)nickname, (String)nicknameWithoutTokenName, tokenname1);
            } else if (certType.equals("kraTransportCert")) {
                this.setKRANewnickname("", "");
                this.setKRANickname((String)nickname);
            } else if (certType.equals("serverCert")) {
                this.setAgentNewnickname("", "");
                this.modifyAgentGatewayCert((String)nickname);
                this.modifyCAGatewayCert((String)nickname);
            } else if (certType.equals("serverCertRadm")) {
                this.setRADMNewnickname("", "");
                this.modifyRADMCert((String)nickname);
            }
            boolean verified = false;
            try {
                logger.debug("CMSAdminServlet: verifying system certificate " + (String)nickname);
                CertUtil.verifyCertificateUsage((String)nickname, null);
                verified = true;
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CIMC_CERT_VERIFICATION_3", auditSubjectID, "Success", nickname);
                auditor.log(auditMessage);
            }
            catch (Exception e) {
                logger.error("CMSAdminServlet: Unable to verify system certificate: " + e.getMessage(), (Throwable)e);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CIMC_CERT_VERIFICATION_3", auditSubjectID, "Failure", nickname);
                auditor.log(auditMessage);
            }
            auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Success", this.auditParams(req)));
            this.mConfig.commit(true);
            if (verified) {
                this.sendResponse(SUCCESS, null, null, resp);
            } else {
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_CERT_VALIDATE_FAILED", new String[0]), null, resp);
            }
        }
        catch (EBaseException eAudit1) {
            auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    protected void importXCert(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
    }

    String getCANickname() {
        return null;
    }

    String getOCSPNickname() {
        return null;
    }

    public String getNickname(String certType) throws EBaseException {
        String nickname = "";
        CMSEngine engine = this.getCMSEngine();
        if (certType.equals("caSigningCert")) {
            nickname = this.getCANickname();
        } else if (certType.equals("ocspSigningCert")) {
            nickname = this.getOCSPNickname();
        } else if (certType.equals("kraTransportCert")) {
            nickname = this.getKRANickname();
        } else if (certType.equals("serverCert")) {
            nickname = engine.getServerCertNickname();
        } else if (certType.equals("serverCertRadm")) {
            nickname = engine.getServerCertNickname();
        }
        return nickname;
    }

    private void getCertInfo(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        Enumeration enum1 = req.getParameterNames();
        NameValuePairs results = new NameValuePairs();
        String pkcs = "";
        String path = "";
        String certType = "";
        String otherNickname = "";
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (key.equals("pkcs10")) {
                pkcs = value;
                continue;
            }
            if (key.equals("RS_ID")) {
                certType = value;
                continue;
            }
            if (key.equals("certFilePath")) {
                path = value;
                continue;
            }
            if (!key.equals("nickname")) continue;
            otherNickname = value;
        }
        try {
            if (pkcs == null || pkcs.equals("")) {
                if (path == null || path.equals("")) {
                    EBaseException ex = new EBaseException(CMS.getLogMessage("BASE_INVALID_FILE_PATH", new Object[0]));
                    throw ex;
                }
                FileInputStream in = new FileInputStream(path);
                BufferedReader d = new BufferedReader(new InputStreamReader(in));
                String content = "";
                pkcs = "";
                StringBuffer sb = new StringBuffer();
                while ((content = d.readLine()) != null) {
                    sb.append(content);
                    sb.append("\n");
                }
                pkcs = sb.toString();
                if (d != null) {
                    d.close();
                }
                pkcs = pkcs.substring(0, pkcs.length() - 1);
            }
        }
        catch (IOException ee) {
            throw new EBaseException(CMS.getLogMessage("BASE_OPEN_FILE_FAILED", new Object[0]));
        }
        pkcs = pkcs.trim();
        int totalLen = pkcs.length();
        if (pkcs.indexOf("-----BEGIN CERTIFICATE-----") != 0 || pkcs.indexOf("-----END CERTIFICATE-----") != totalLen - 25) {
            throw new EBaseException(CMS.getLogMessage("BASE_INVALID_CERT_FORMAT", new Object[0]));
        }
        String nickname = "";
        if (certType.equals("caSigningCert")) {
            nickname = this.getCANewnickname();
        } else if (certType.equals("kraTransportCert")) {
            nickname = this.getKRANewnickname();
        } else if (certType.equals("serverCert")) {
            nickname = this.getAgentNewnickname();
        } else if (certType.equals("serverCertRadm")) {
            nickname = this.getRADMNewnickname();
        } else if (certType.equals("otherCert")) {
            nickname = otherNickname;
        } else if (certType.equals("ocspSigningCert")) {
            nickname = this.getOCSPNewnickname();
        }
        if (nickname.equals("")) {
            nickname = this.getNickname(certType);
        }
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        String content = jssSubsystem.getCertPrettyPrint(pkcs, super.getLocale(req));
        if (nickname != null && !nickname.equals("")) {
            results.put((Object)"nickname", (Object)nickname);
        }
        results.put((Object)"certContent", (Object)content);
        this.sendResponse(SUCCESS, null, results, resp);
    }

    private void getCertPrettyPrint(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        Enumeration enum1 = req.getParameterNames();
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        String nickname = "";
        String serialno = "";
        String issuername = "";
        Locale locale = super.getLocale(req);
        NameValuePairs pairs = new NameValuePairs();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (key.equals("OP_TYPE") || key.equals("RS_ID") || key.equals("OP_SCOPE")) continue;
            if (key.equals("nickName")) {
                nickname = value;
                continue;
            }
            if (key.equals("serialNumber")) {
                serialno = value;
                continue;
            }
            if (!key.equals("issuerName")) continue;
            issuername = value;
        }
        String print = jssSubsystem.getCertPrettyPrintAndFingerPrint(nickname, serialno, issuername, locale);
        pairs.put((Object)nickname, (Object)print);
        this.sendResponse(SUCCESS, null, pairs, resp);
    }

    private void getRootCertTrustBit(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        Enumeration enum1 = req.getParameterNames();
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        String nickname = "";
        String serialno = "";
        String issuername = "";
        NameValuePairs pairs = new NameValuePairs();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (key.equals("OP_TYPE") || key.equals("RS_ID") || key.equals("OP_SCOPE")) continue;
            if (key.equals("nickName")) {
                nickname = value;
                continue;
            }
            if (key.equals("serialNumber")) {
                serialno = value;
                continue;
            }
            if (!key.equals("issuerName")) continue;
            issuername = value;
        }
        String trustbit = jssSubsystem.getRootCertTrustBit(nickname, serialno, issuername);
        pairs.put((Object)nickname, (Object)trustbit);
        this.sendResponse(SUCCESS, null, pairs, resp);
    }

    private void getCACerts(HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        NameValuePairs pairs = jssSubsystem.getCACerts();
        this.sendResponse(SUCCESS, null, pairs, resp);
    }

    private void deleteRootCert(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        int mindex = id.indexOf(":SERIAL#<");
        String nickname = id.substring(0, mindex);
        String sstr1 = id.substring(mindex);
        int lindex = sstr1.indexOf(">");
        String serialno = sstr1.substring(9, lindex);
        String issuername = sstr1.substring(lindex + 1);
        jssSubsystem.deleteRootCert(nickname, serialno, issuername);
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void deleteUserCert(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        int mindex = id.indexOf(":SERIAL#<");
        String nickname = id.substring(0, mindex);
        String sstr1 = id.substring(mindex);
        int lindex = sstr1.indexOf(">");
        String serialno = sstr1.substring(9, lindex);
        String issuername = sstr1.substring(lindex + 1);
        jssSubsystem.deleteUserCert(nickname, serialno, issuername);
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void getRootCerts(HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        NameValuePairs pairs = jssSubsystem.getRootCerts();
        this.sendResponse(SUCCESS, null, pairs, resp);
    }

    private void getAllCertsManage(HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        NameValuePairs pairs = jssSubsystem.getAllCertsManage();
        this.sendResponse(SUCCESS, null, pairs, resp);
    }

    private void getUserCerts(HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        NameValuePairs pairs = jssSubsystem.getUserCerts();
        this.sendResponse(SUCCESS, null, pairs, resp);
    }

    private void deleteCerts(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        Enumeration enum1 = req.getParameterNames();
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        String nickname = "";
        String date = "";
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (key.equals("OP_TYPE") || key.equals("RS_ID") || key.equals("OP_SCOPE")) continue;
            int index = value.indexOf(";");
            nickname = value.substring(0, index);
            date = value.substring(index + 1);
            jssSubsystem.deleteCert(nickname, date);
        }
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void validateSubjectName(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Enumeration enum1 = req.getParameterNames();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (!key.equals("subjectName")) continue;
            JssSubsystem jssSubsystem = engine.getJSSSubsystem();
            jssSubsystem.isX500DN(value);
        }
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void validateKeyLength(HttpServletResponse resp) throws IOException {
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void validateCurveName(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        Enumeration enum1 = req.getParameterNames();
        String curveName = null;
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (!key.equals("keyCurveName")) continue;
            curveName = value;
        }
        String curveList = this.mConfig.getString("keys.ecc.curve.list", "nistp521");
        String[] curves = curveList.split(",");
        boolean match = false;
        for (int i = 0; i < curves.length; ++i) {
            if (!curves[i].equals(curveName)) continue;
            match = true;
        }
        if (!match) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ECC_CURVE_NAME", new String[0]));
        }
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void validateCertExtension(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        Enumeration enum1 = req.getParameterNames();
        String certExt = "";
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (!key.equals("certificateExtension")) continue;
            certExt = value;
            break;
        }
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        jssSubsystem.checkCertificateExt(certExt);
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void getSubjectName(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration enum1 = req.getParameterNames();
        String nickname = "";
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (!key.equals("RS_ID")) continue;
            nickname = this.getNickname(value);
            break;
        }
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        String subjectName = jssSubsystem.getSubjectDN(nickname);
        params.put((Object)"subjectName", (Object)subjectName);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void processSubjectName(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration enum1 = req.getParameterNames();
        String nickname = "";
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (!key.equals("nickname")) continue;
            nickname = value;
        }
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        String subjectName = jssSubsystem.getSubjectDN(nickname);
        params.put((Object)"subjectName", (Object)subjectName);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    public void setRootCertTrust(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String nickname = req.getParameter("nickName");
        String serialno = req.getParameter("serialNumber");
        String issuername = req.getParameter("issuerName");
        String trust = req.getParameter("trustbit");
        logger.debug("CMSAdminServlet: setRootCertTrust()");
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        try {
            jssSubsystem.setRootCertTrust(nickname, serialno, issuername, trust);
        }
        catch (EBaseException e) {
            auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw e;
        }
        auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Success", this.auditParams(req)));
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void trustCACert(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        logger.debug("CMSAdminServlet: trustCACert()");
        try {
            Enumeration enum1 = req.getParameterNames();
            JssSubsystem jssSubsystem = engine.getJSSSubsystem();
            String trust = "";
            while (enum1.hasMoreElements()) {
                String key = (String)enum1.nextElement();
                String value = req.getParameter(key);
                if (key.equals("RS_ID")) {
                    trust = value;
                    continue;
                }
                if (!key.equals("certName0")) continue;
                int index = value.indexOf(";");
                String nickname = value.substring(0, index);
                String date = value.substring(index + 1);
                jssSubsystem.trustCert(nickname, date, trust);
            }
            auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Success", this.auditParams(req)));
            this.sendResponse(RESTART, null, null, resp);
        }
        catch (EBaseException eAudit1) {
            auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private synchronized void runSelfTestsOnDemand(HttpServletRequest req, HttpServletResponse resp) throws ESelfTestException, IOException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            logger.debug("CMSAdminServlet: runSelfTestsOnDemand()");
            Enumeration enum1 = req.getParameterNames();
            String request = "";
            NameValuePairs results = new NameValuePairs();
            Object content = "";
            String instanceName = null;
            String instanceFullName = null;
            String logMessage = null;
            while (enum1.hasMoreElements()) {
                String key = (String)enum1.nextElement();
                String value = req.getParameter(key);
                if (!key.equals("run")) continue;
                request = value;
            }
            SelfTestSubsystem mSelfTestSubsystem = (SelfTestSubsystem)engine.getSubsystem("selftests");
            if (request == null || request.equals("")) {
                logMessage = CMS.getLogMessage("SELFTESTS_RUN_ON_DEMAND_REQUEST", this.getServletInfo(), "run");
                mSelfTestSubsystem.log(mSelfTestSubsystem.getSelfTestLogger(), logMessage);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", auditSubjectID, "Failure");
                auditor.log(auditMessage);
                content = (String)content + logMessage + "\n";
                this.sendResponse(ERROR, (String)content, null, resp);
                throw new ESelfTestException(logMessage);
            }
            String[] selftests = mSelfTestSubsystem.listSelfTestsEnabledOnDemand();
            if (selftests != null && selftests.length > 0) {
                logMessage = CMS.getLogMessage("SELFTESTS_RUN_ON_DEMAND", this.getServletInfo());
                mSelfTestSubsystem.log(mSelfTestSubsystem.getSelfTestLogger(), logMessage);
                content = (String)content + logMessage + "\n";
                for (int i = 0; i < selftests.length; ++i) {
                    if (selftests[i] == null) {
                        logMessage = CMS.getLogMessage("SELFTESTS_PARAMETER_WAS_NULL", this.getServletInfo());
                        mSelfTestSubsystem.log(mSelfTestSubsystem.getSelfTestLogger(), logMessage);
                        auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", auditSubjectID, "Failure");
                        auditor.log(auditMessage);
                        content = (String)content + logMessage + "\n";
                        this.sendResponse(ERROR, (String)content, null, resp);
                        throw new EMissingSelfTestException();
                    }
                    instanceName = selftests[i].trim();
                    instanceFullName = "selftests.container.instance." + instanceName;
                    SelfTest test = mSelfTestSubsystem.getSelfTest(instanceName);
                    if (test == null) {
                        logMessage = CMS.getLogMessage("SELFTESTS_MISSING_NAME", this.getServletInfo(), instanceFullName);
                        mSelfTestSubsystem.log(mSelfTestSubsystem.getSelfTestLogger(), logMessage);
                        auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", auditSubjectID, "Failure");
                        auditor.log(auditMessage);
                        content = (String)content + logMessage + "\n";
                        this.sendResponse(ERROR, (String)content, null, resp);
                        throw new EMissingSelfTestException(instanceFullName);
                    }
                    try {
                        logger.debug("CMSAdminServlet: runSelfTestsOnDemand(): running \"" + test.getSelfTestName() + "\"");
                        content = (String)content + "CMSAdminServlet: runSelfTestsOnDemand(): running \"" + test.getSelfTestName() + "\" . . .\n";
                        test.runSelfTest(mSelfTestSubsystem.getSelfTestLogger());
                        content = (String)content + "COMPLETED SUCCESSFULLY\n";
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("CMSAdminServlet: Selftest failure: " + e.getMessage(), (Throwable)e);
                        if (mSelfTestSubsystem.isSelfTestCriticalOnDemand(instanceName)) {
                            logMessage = CMS.getLogMessage("SELFTESTS_RUN_ON_DEMAND_FAILED", this.getServletInfo(), instanceFullName);
                            mSelfTestSubsystem.log(mSelfTestSubsystem.getSelfTestLogger(), logMessage);
                            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", auditSubjectID, "Failure");
                            auditor.log(auditMessage);
                            content = (String)content + "FAILED WITH CRITICAL ERROR\n";
                            content = (String)content + logMessage + "\n";
                            this.sendResponse(ERROR, (String)content, null, resp);
                            logger.error("CMSAdminServlet: Disabling subsystem due to selftest failure: " + e.getMessage());
                            engine.disableSubsystem();
                            throw new ESelfTestException("Selftest failure: " + e.getMessage(), (Throwable)e);
                        }
                        content = (String)content + "FAILED WITH NON-CRITICAL ERROR\n";
                    }
                }
                logMessage = CMS.getLogMessage("SELFTESTS_RUN_ON_DEMAND_SUCCEEDED", this.getServletInfo());
                mSelfTestSubsystem.log(mSelfTestSubsystem.getSelfTestLogger(), logMessage);
                content = (String)content + logMessage + "\n";
            } else {
                logMessage = CMS.getLogMessage("SELFTESTS_NOT_RUN_ON_DEMAND", this.getServletInfo());
                mSelfTestSubsystem.log(mSelfTestSubsystem.getSelfTestLogger(), logMessage);
                content = (String)content + logMessage + "\n";
            }
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", auditSubjectID, "Success");
            auditor.log(auditMessage);
            results.put((Object)"class", (Object)CMSAdminServlet.class.getName());
            results.put((Object)"runContent", content);
            this.sendResponse(SUCCESS, null, results, resp);
        }
        catch (EMissingSelfTestException eAudit1) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", auditSubjectID, "Failure");
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (ESelfTestException eAudit2) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", auditSubjectID, "Failure");
            auditor.log(auditMessage);
            throw eAudit2;
        }
        catch (IOException eAudit3) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", auditSubjectID, "Failure");
            auditor.log(auditMessage);
            throw eAudit3;
        }
    }

    private String auditPublicKey(KeyPair object) {
        if (object == null) {
            return "<null>";
        }
        byte[] rawData = null;
        rawData = object.getPublic().getEncoded();
        String key = null;
        if (rawData != null) {
            String base64Data = null;
            base64Data = Utils.base64encode((byte[])rawData, (boolean)true).trim();
            key = base64Data.replace("\r", "").replace("\n", "");
        }
        if (key == null) {
            return "<null>";
        }
        return (key = key.trim()).equals("") ? "<null>" : key;
    }
}

