/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class GetConfigEntries
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GetConfigEntries.class);
    private static final long serialVersionUID = -7418561215631752315L;
    private static final String SUCCESS = "0";
    private static final String AUTH_FAILURE = "2";

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        AuthToken authToken = null;
        logger.info("GetConfigEntries: Authenticating request");
        try {
            authToken = this.authenticate(cmsReq);
        }
        catch (Exception e) {
            logger.error("GetConfigEntries: Authentication failed: " + e.getMessage(), (Throwable)e);
            logger.error(CMS.getLogMessage("CMSGW_ERR_BAD_SERV_OUT_STREAM", "", e.toString()));
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        ArgBlock args = cmsReq.getHttpParams();
        String op = args.getValueAsString("op", null);
        logger.info("GetConfigEntries: Operation: " + op);
        XMLObject xmlObj = null;
        try {
            xmlObj = new XMLObject();
        }
        catch (Exception e) {
            String message = "Unable to create XMLObject: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new EBaseException(message, (Throwable)e);
        }
        Node root = xmlObj.createRoot("XMLResponse");
        logger.info("GetConfigEntries: Authorizing request");
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
            this.outputError(httpResp, "Error: Not authorized");
            return;
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
            this.outputError(httpResp, "Error: Encountered problem during authorization.");
            return;
        }
        if (authzToken == null) {
            this.outputError(httpResp, "Error: Not authorized");
            return;
        }
        if (op != null) {
            logger.info("GetConfigEntries: Processing substores");
            EngineConfig config = engine.getConfig();
            String substores = args.getValueAsString("substores", "");
            StringTokenizer t = new StringTokenizer(substores, ",");
            while (t.hasMoreTokens()) {
                String name1 = t.nextToken();
                ConfigStore cs = config.getSubStore(name1, ConfigStore.class);
                Enumeration<String> enum1 = cs.getPropertyNames();
                while (enum1.hasMoreElements()) {
                    String name = name1 + "." + enum1.nextElement();
                    logger.info("- " + name);
                    String value = config.getString(name, null);
                    if ("localhost".equals(value)) {
                        value = config.getHostname();
                    }
                    Node container = xmlObj.createContainer(root, "Config");
                    xmlObj.addItemToContainer(container, "name", name);
                    xmlObj.addItemToContainer(container, "value", value);
                }
            }
            logger.info("GetConfigEntries: Processing names");
            String names = args.getValueAsString("names", "");
            StringTokenizer t1 = new StringTokenizer(names, ",");
            while (t1.hasMoreTokens()) {
                String value;
                String name = t1.nextToken();
                logger.info("- " + name);
                if (name.equals("internaldb.ldapauth.password")) {
                    value = this.getLDAPPassword();
                } else if (name.equals("internaldb.replication.password")) {
                    value = this.getReplicationPassword();
                } else {
                    value = config.getString(name, null);
                    if ("localhost".equals(value)) {
                        value = config.getHostname();
                    }
                }
                if (value == null) continue;
                Node container = xmlObj.createContainer(root, "Config");
                xmlObj.addItemToContainer(container, "name", name);
                xmlObj.addItemToContainer(container, "value", value);
            }
        }
        try {
            xmlObj.addItemToContainer(root, "Status", SUCCESS);
            byte[] cb = xmlObj.toByteArray();
            this.outputResult(httpResp, "application/xml", cb);
        }
        catch (Exception e) {
            logger.warn("Failed to send the XML output: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }

    @Override
    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    private String getLDAPPassword() throws EBaseException {
        CMSEngine engine = this.getCMSEngine();
        PasswordStore pwdStore = engine.getPasswordStore();
        return pwdStore.getPassword("internaldb", 0);
    }

    private String getReplicationPassword() throws EBaseException {
        CMSEngine engine = this.getCMSEngine();
        PasswordStore pwdStore = engine.getPasswordStore();
        return pwdStore.getPassword("replicationdb", 0);
    }
}

