/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminRequestFilter
implements Filter {
    public static Logger logger = LoggerFactory.getLogger(AdminRequestFilter.class);
    private static final String HTTPS_SCHEME = "https";
    private static final String HTTPS_PORT = "https_port";
    private static final String HTTPS_ROLE = "Admin";
    private static final String PROXY_PORT = "proxy_port";
    private FilterConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String filterName = this.getClass().getName();
        String scheme = null;
        int port = 0;
        String request_port = null;
        String param_https_port = null;
        String param_proxy_port = null;
        Object msg = null;
        String param_active = null;
        param_active = this.config.getInitParameter("active");
        if (request instanceof HttpServletRequest) {
            HttpServletResponse resp = (HttpServletResponse)response;
            scheme = request.getScheme();
            if (!scheme.equals(HTTPS_SCHEME)) {
                msg = "The scheme MUST be 'https', NOT '" + scheme + "'!";
                logger.warn(filterName + ":  " + (String)msg);
                resp.sendError(401, (String)msg);
                return;
            }
            port = request.getLocalPort();
            request_port = Integer.toString(port);
            param_https_port = this.config.getInitParameter(HTTPS_PORT);
            if (param_https_port == null) {
                msg = "The <param-name> 'https_port' </param-name> MUST be specified in 'web.xml'!";
                logger.warn(filterName + ":  " + (String)msg);
                resp.sendError(501, (String)msg);
                return;
            }
            param_proxy_port = this.config.getInitParameter(PROXY_PORT);
            boolean bad_port = false;
            if (!param_https_port.equals(request_port)) {
                String uri = ((HttpServletRequest)request).getRequestURI();
                if (param_proxy_port != null) {
                    if (!param_proxy_port.equals(request_port)) {
                        msg = "Use HTTPS port '" + param_https_port + "' or proxy port '" + param_proxy_port + "' instead of '" + request_port + "' when performing Admin tasks!";
                        bad_port = true;
                    }
                } else {
                    msg = "Use HTTPS port '" + param_https_port + "' instead of '" + request_port + "' when performing Admin tasks!";
                    bad_port = true;
                }
                if (bad_port) {
                    logger.warn(filterName + ":  " + (String)msg);
                    logger.debug(filterName + ": uri is " + uri);
                    if (param_active != null && param_active.equals("false")) {
                        logger.debug("Filter is disabled .. continuing");
                    } else {
                        resp.sendError(404, (String)msg);
                        return;
                    }
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

