/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.authentication;

import java.math.BigInteger;
import java.util.Date;

public class VerifiedCert {
    public static final int CHECKED = 4;
    public static final int EXPIRED = 3;
    public static final int NOT_REVOKED = 2;
    public static final int REVOKED = 1;
    public static final int UNKNOWN = 0;
    private int mStatus = 0;
    private Date mCreated = null;
    private BigInteger mSerialNumber = null;
    private byte[] mCertEncoded = null;

    public VerifiedCert(BigInteger serialNumber, byte[] certEncoded, int status) {
        this.mStatus = status;
        this.mSerialNumber = serialNumber;
        this.mCertEncoded = certEncoded;
        this.mCreated = new Date();
    }

    public int check(BigInteger serialNumber, byte[] certEncoded, long interval, long unknownStateInterval) {
        int status = 0;
        if (this.mSerialNumber.equals(serialNumber)) {
            if (this.mCertEncoded != null) {
                if (certEncoded != null && this.mCertEncoded.length == certEncoded.length) {
                    int i;
                    for (i = 0; i < this.mCertEncoded.length && this.mCertEncoded[i] == certEncoded[i]; ++i) {
                    }
                    if (i >= this.mCertEncoded.length) {
                        Date now = new Date();
                        Date expires = new Date(this.mCreated.getTime() + interval * 1000L);
                        if (now.after(expires)) {
                            this.mStatus = 3;
                        }
                        status = this.mStatus;
                    }
                }
            } else if (unknownStateInterval > 0L) {
                Date now = new Date();
                Date expires = new Date(this.mCreated.getTime() + unknownStateInterval * 1000L);
                if (now.after(expires)) {
                    this.mStatus = 3;
                }
                status = this.mStatus;
            }
        }
        return status;
    }
}

