/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBVirtualList;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.ElementProcessor;
import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertRecordList {
    public static Logger logger = LoggerFactory.getLogger(CertRecordList.class);
    private DBVirtualList<CertRecord> mVlist = null;

    public CertRecordList(DBVirtualList<CertRecord> vlist) {
        this.mVlist = vlist;
    }

    public int getCurrentIndex() {
        return this.mVlist.getCurrentIndex();
    }

    public int getSize() {
        return this.mVlist.getSize();
    }

    public int getSizeBeforeJumpTo() {
        return this.mVlist.getSizeBeforeJumpTo();
    }

    public int getSizeAfterJumpTo() {
        return this.mVlist.getSizeAfterJumpTo();
    }

    public void processCertRecords(int startidx, int endidx, ElementProcessor ep) throws EBaseException {
        for (int i = 0; i < this.mVlist.getSize(); ++i) {
            CertRecord element = this.mVlist.getElementAt(i);
            if (element == null || element instanceof String) continue;
            ep.process(element);
        }
    }

    public Enumeration<CertRecord> getCertRecords(int startidx, int endidx) throws EBaseException {
        Vector<CertRecord> entries = new Vector<CertRecord>();
        for (int i = startidx; i <= endidx; ++i) {
            CertRecord element = this.mVlist.getElementAt(i);
            if (element == null) continue;
            entries.addElement(element);
        }
        return entries.elements();
    }

    public CertRecord getCertRecord(int index) throws EBaseException {
        return this.mVlist.getElementAt(index);
    }
}

