/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.Repository;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaIDRepository
extends Repository {
    public static Logger logger = LoggerFactory.getLogger(ReplicaIDRepository.class);

    public ReplicaIDRepository(DBSubsystem dbSubsystem) {
        super(dbSubsystem, 10);
    }

    @Override
    public void init() throws Exception {
        String incrementNo;
        logger.info("ReplicaIDRepository: Initializing replica ID repository");
        DatabaseConfig dbConfig = this.dbSubsystem.getDBConfigStore();
        this.mBaseDN = dbConfig.getReplicaDN() + "," + this.dbSubsystem.getBaseDN();
        logger.info("ReplicaIDRepository: - base DN: " + this.mBaseDN);
        this.rangeDN = dbConfig.getReplicaRangeDN() + "," + this.dbSubsystem.getBaseDN();
        logger.info("ReplicaIDRepository: - range DN: " + this.rangeDN);
        this.minSerialName = "beginReplicaNumber";
        String minSerial = dbConfig.getBeginReplicaNumber();
        if (minSerial != null) {
            this.mMinSerialNo = new BigInteger(minSerial, this.mRadix);
        }
        logger.info("ReplicaIDRepository: - min serial: " + this.mMinSerialNo);
        this.maxSerialName = "endReplicaNumber";
        String maxSerial = dbConfig.getEndReplicaNumber();
        if (maxSerial != null) {
            this.mMaxSerialNo = new BigInteger(maxSerial, this.mRadix);
        }
        logger.info("ReplicaIDRepository: - max serial: " + this.mMaxSerialNo);
        this.nextMinSerialName = "nextBeginReplicaNumber";
        String nextMinSerial = dbConfig.getNextBeginReplicaNumber();
        this.mNextMinSerialNo = nextMinSerial == null || nextMinSerial.equals("-1") ? null : new BigInteger(nextMinSerial, this.mRadix);
        logger.info("ReplicaIDRepository: - next min serial: " + this.mNextMinSerialNo);
        this.nextMaxSerialName = "nextEndReplicaNumber";
        String nextMaxSerial = dbConfig.getNextEndReplicaNumber();
        this.mNextMaxSerialNo = nextMaxSerial == null || nextMaxSerial.equals("-1") ? null : new BigInteger(nextMaxSerial, this.mRadix);
        logger.info("ReplicaIDRepository: - next max serial: " + this.mNextMaxSerialNo);
        String lowWaterMark = dbConfig.getReplicaLowWaterMark();
        if (lowWaterMark != null) {
            this.mLowWaterMarkNo = new BigInteger(lowWaterMark, this.mRadix);
        }
        if ((incrementNo = dbConfig.getReplicaIncrement()) != null) {
            this.mIncrementNo = new BigInteger(incrementNo, this.mRadix);
        }
    }

    @Override
    public BigInteger getLastSerialNumberInRange(BigInteger serial_low_bound, BigInteger serial_upper_bound) throws EBaseException {
        logger.debug("ReplicaIDReposoitory: in getLastSerialNumberInRange: low " + serial_low_bound + " high " + serial_upper_bound);
        if (serial_low_bound == null || serial_upper_bound == null || serial_low_bound.compareTo(serial_upper_bound) >= 0) {
            return null;
        }
        BigInteger ret = this.getMinSerial();
        if (ret == null || ret.compareTo(serial_upper_bound) > 0 || ret.compareTo(serial_low_bound) < 0) {
            return null;
        }
        return ret;
    }
}

