/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.jobs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.jobs.CronItem;
import com.netscape.cmscore.jobs.CronRange;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobCron {
    public static Logger logger = LoggerFactory.getLogger(JobCron.class);
    public static final String PROP_CRON = "cron";
    public static final String CRON_MINUTE = "minute";
    public static final String CRON_HOUR = "hour";
    public static final String CRON_DAY_OF_MONTH = "dom";
    public static final String CRON_MONTH_OF_YEAR = "moy";
    public static final String CRON_DAY_OF_WEEK = "dow";
    String mCronString = null;
    CronItem cMinute = null;
    CronItem cHour = null;
    CronItem cDOM = null;
    CronItem cMOY = null;
    CronItem cDOW = null;

    public JobCron(String cronString) throws EBaseException {
        this.mCronString = cronString;
        this.cMinute = new CronItem(0, 59);
        this.cHour = new CronItem(0, 23);
        this.cDOM = new CronItem(1, 31);
        this.cMOY = new CronItem(1, 12);
        this.cDOW = new CronItem(0, 6);
        this.cronToVals(this.mCronString);
    }

    private void cronToVals(String cronString) throws EBaseException {
        StringTokenizer st = new StringTokenizer(cronString);
        String sMinute = null;
        String sHour = null;
        String sDayOMonth = null;
        String sMonthOYear = null;
        String sDayOWeek = null;
        try {
            if (st.hasMoreTokens()) {
                sMinute = st.nextToken();
                this.cMinute.set(sMinute);
            }
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_MIN", e.toString()));
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]));
        }
        try {
            if (st.hasMoreTokens()) {
                sHour = st.nextToken();
                this.cHour.set(sHour);
            }
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_HOUR", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]), (Throwable)e);
        }
        if (st.hasMoreTokens()) {
            sDayOMonth = st.nextToken();
        }
        try {
            if (st.hasMoreTokens()) {
                sMonthOYear = st.nextToken();
                this.cMOY.set(sMonthOYear);
            }
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_MONTH", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]), (Throwable)e);
        }
        if (st.hasMoreTokens()) {
            sDayOWeek = st.nextToken();
        }
        if (sDayOMonth != null && sDayOMonth.equals("*") && sDayOWeek != null && !sDayOWeek.equals("*")) {
            try {
                this.cDOW.set(sDayOWeek);
            }
            catch (EBaseException e) {
                logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_DAY_OF_WEEK", e.toString()), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]), (Throwable)e);
            }
        }
        if (sDayOMonth != null && !sDayOMonth.equals("*") && sDayOWeek != null && sDayOWeek.equals("*")) {
            try {
                this.cDOM.set(sDayOMonth);
            }
            catch (EBaseException e) {
                logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_DAY_OF_MONTH", e.toString()), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]), (Throwable)e);
            }
        }
        try {
            if (sDayOWeek != null) {
                this.cDOW.set(sDayOWeek);
            }
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_DAY_OF_WEEK", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]), (Throwable)e);
        }
        try {
            if (sDayOMonth != null) {
                this.cDOM.set(sDayOMonth);
            }
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_DAY_OF_MONTH", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]), (Throwable)e);
        }
    }

    public CronItem getItem(String item) {
        if (item.equals(CRON_MINUTE)) {
            return this.cMinute;
        }
        if (item.equals(CRON_HOUR)) {
            return this.cHour;
        }
        if (item.equals(CRON_DAY_OF_MONTH)) {
            return this.cDOM;
        }
        if (item.equals(CRON_MONTH_OF_YEAR)) {
            return this.cMOY;
        }
        if (item.equals(CRON_DAY_OF_WEEK)) {
            return this.cDOW;
        }
        return null;
    }

    boolean isElement(int element, Vector<CronRange> item) {
        Enumeration<CronRange> e = item.elements();
        while (e.hasMoreElements()) {
            CronRange cElement = e.nextElement();
            if (!(cElement.getBegin() == cElement.getEnd() ? element == cElement.getBegin() : element >= cElement.getBegin() && element <= cElement.getEnd())) continue;
            return true;
        }
        return false;
    }

    public int DOW_cal2cron(Calendar time) {
        int calDow = time.get(7);
        int cronDow = 0;
        switch (calDow) {
            case 1: {
                cronDow = 0;
                break;
            }
            case 2: {
                cronDow = 1;
                break;
            }
            case 3: {
                cronDow = 2;
                break;
            }
            case 4: {
                cronDow = 3;
                break;
            }
            case 5: {
                cronDow = 4;
                break;
            }
            case 6: {
                cronDow = 5;
                break;
            }
            case 7: {
                cronDow = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return cronDow;
    }

    public int MOY_cal2cron(Calendar time) {
        int calMoy = time.get(2);
        int cronMoy = 0;
        switch (calMoy) {
            case 0: {
                cronMoy = 1;
                break;
            }
            case 1: {
                cronMoy = 2;
                break;
            }
            case 2: {
                cronMoy = 3;
                break;
            }
            case 3: {
                cronMoy = 4;
                break;
            }
            case 4: {
                cronMoy = 5;
                break;
            }
            case 5: {
                cronMoy = 6;
                break;
            }
            case 6: {
                cronMoy = 7;
                break;
            }
            case 7: {
                cronMoy = 8;
                break;
            }
            case 8: {
                cronMoy = 9;
                break;
            }
            case 9: {
                cronMoy = 10;
                break;
            }
            case 10: {
                cronMoy = 11;
                break;
            }
            case 11: {
                cronMoy = 12;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return cronMoy;
    }
}

