/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.system.DomainInfo;
import com.netscape.certsrv.system.InstallToken;
import com.netscape.certsrv.system.SecurityDomainHost;
import com.netscape.certsrv.system.SecurityDomainResource;
import com.netscape.certsrv.system.SecurityDomainSubsystem;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cms.servlet.csadmin.SecurityDomainProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityDomainService
extends PKIService
implements SecurityDomainResource {
    public static Logger logger = LoggerFactory.getLogger(SecurityDomainService.class);

    public boolean isEnabled() {
        return true;
    }

    public Response getInstallToken(String hostname, String subsystem) {
        if (!this.isEnabled()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        logger.debug("SecurityDomainService.getInstallToken(" + hostname + ", " + subsystem + ")");
        try {
            String user = this.servletRequest.getUserPrincipal().getName();
            SecurityDomainProcessor processor = new SecurityDomainProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            InstallToken installToken = processor.getInstallToken(user, hostname, subsystem);
            return this.createOKResponse(installToken);
        }
        catch (PKIException e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response getDomainInfo() {
        if (!this.isEnabled()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        try {
            SecurityDomainProcessor processor = new SecurityDomainProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            DomainInfo domainInfo = processor.getDomainInfo();
            return this.createOKResponse(domainInfo);
        }
        catch (PKIException e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response getHosts() {
        if (!this.isEnabled()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        logger.info("SecurityDomainService: Getting all security domain hosts");
        try {
            ArrayList<SecurityDomainHost> hosts = new ArrayList<SecurityDomainHost>();
            SecurityDomainProcessor processor = new SecurityDomainProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            DomainInfo domainInfo = processor.getDomainInfo();
            logger.debug("SecurityDomainService: domain: " + domainInfo.getName());
            for (SecurityDomainSubsystem subsystem : domainInfo.getSubsystems().values()) {
                for (SecurityDomainHost host : subsystem.getHosts().values()) {
                    logger.debug("SecurityDomainService: - " + host.getId());
                    hosts.add(host);
                }
            }
            GenericEntity<Collection<SecurityDomainHost>> entity = new GenericEntity<Collection<SecurityDomainHost>>(hosts){};
            return this.createOKResponse(entity);
        }
        catch (PKIException e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response getHost(String hostID) {
        if (!this.isEnabled()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        logger.info("SecurityDomainService: Getting security domain host \"" + hostID + "\"");
        try {
            SecurityDomainProcessor processor = new SecurityDomainProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            DomainInfo domainInfo = processor.getDomainInfo();
            logger.debug("SecurityDomainService: domain: " + domainInfo.getName());
            for (SecurityDomainSubsystem subsystem : domainInfo.getSubsystems().values()) {
                for (SecurityDomainHost host : subsystem.getHosts().values()) {
                    logger.debug("SecurityDomainService: - " + host.getId());
                    if (!host.getId().equals(hostID)) continue;
                    logger.debug("SecurityDomainService: Found security domain host " + hostID);
                    return this.createOKResponse(host);
                }
            }
            throw new ResourceNotFoundException("Security domain host not found: " + hostID);
        }
        catch (PKIException e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response addHost(SecurityDomainHost host) {
        if (!this.isEnabled()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String hostID = host.getId();
        logger.info("SecurityDomainService: Adding security domain host \"" + hostID + "\"");
        try {
            Pattern pattern = Pattern.compile("^(\\S+) (\\S+) (\\d+)$");
            Matcher matcher = pattern.matcher(hostID);
            if (!matcher.find()) {
                throw new BadRequestException("Invalid security domain host: " + hostID);
            }
            String type = matcher.group(1);
            logger.debug("SecurityDomainService: type: " + type);
            String hostname = matcher.group(2);
            logger.debug("SecurityDomainService: hostname: " + hostname);
            String securePort = matcher.group(3);
            logger.debug("SecurityDomainService: secure port: " + securePort);
            String unsecurePort = host.getPort();
            logger.debug("SecurityDomainService: unsecure port: " + unsecurePort);
            String eeCAPort = host.getSecureEEClientAuthPort();
            logger.debug("SecurityDomainService: secure EE port: " + eeCAPort);
            if (!securePort.equals(eeCAPort)) {
                throw new BadRequestException("Invalid secure (EE) port: " + eeCAPort);
            }
            String adminSecurePort = host.getSecureAdminPort();
            logger.debug("SecurityDomainService: secure admin port: " + adminSecurePort);
            if (!securePort.equals(adminSecurePort)) {
                throw new BadRequestException("Invalid secure (admin) port: " + adminSecurePort);
            }
            String agentSecurePort = host.getSecureAgentPort();
            logger.debug("SecurityDomainService: secure agent port: " + agentSecurePort);
            if (!securePort.equals(agentSecurePort)) {
                throw new BadRequestException("Invalid secure (agent) port: " + agentSecurePort);
            }
            String domainManager = host.getDomainManager();
            logger.debug("SecurityDomainService: domain manager: " + domainManager);
            String clone = host.getClone();
            logger.debug("SecurityDomainService: clone: " + clone);
            SecurityDomainProcessor processor = new SecurityDomainProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            String status = processor.addHost(hostID, type, hostname, securePort, unsecurePort, eeCAPort, adminSecurePort, agentSecurePort, domainManager, clone);
            logger.debug("SecurityDomainService: status: " + status);
            if (!"0".equals(status)) {
                throw new PKIException("Unable to add security domain host: " + hostID);
            }
            return this.createNoContentResponse();
        }
        catch (PKIException e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response removeHost(String hostID) {
        if (!this.isEnabled()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        logger.info("SecurityDomainService: Removing security domain host \"" + hostID + "\"");
        try {
            Pattern pattern = Pattern.compile("^(\\S+) (\\S+) (\\d+)$");
            Matcher matcher = pattern.matcher(hostID);
            if (!matcher.find()) {
                throw new BadRequestException("Invalid security domain host: " + hostID);
            }
            String type = matcher.group(1);
            logger.debug("SecurityDomainService: type: " + type);
            String hostname = matcher.group(2);
            logger.debug("SecurityDomainService: hostname: " + hostname);
            String port = matcher.group(3);
            logger.debug("SecurityDomainService: port: " + port);
            SecurityDomainProcessor processor = new SecurityDomainProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            String status = processor.removeHost(hostID, type, hostname, port);
            logger.debug("SecurityDomainService: status: " + status);
            if (!"0".equals(status)) {
                throw new PKIException("Unable to remove security domain host: " + hostID);
            }
            return this.createNoContentResponse();
        }
        catch (PKIException e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("SecurityDomainService: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }
}

