/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.kra.EKRAException;
import com.netscape.certsrv.kra.IJoinShares;
import com.netscape.certsrv.kra.IShare;
import com.netscape.certsrv.security.Credential;
import com.netscape.certsrv.security.IStorageKeyUnit;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.kra.EncryptionUnit;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenCertificate;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageKeyUnit
extends EncryptionUnit
implements IStorageKeyUnit {
    public static Logger logger = LoggerFactory.getLogger(StorageKeyUnit.class);
    private ConfigStore mConfig;
    private ConfigStore mStorageConfig;
    private String mTokenFile = null;
    private X509Certificate mCert = null;
    private CryptoManager mManager = null;
    private CryptoToken mToken = null;
    private PrivateKey mPrivateKey = null;
    private byte[] mPrivateKeyData = null;
    private boolean mKeySplitting = false;
    private boolean useOAEPKeyWrap = false;
    private static final String PROP_N = "n";
    private static final String PROP_M = "m";
    private static final String PROP_UID = "uid";
    private static final String PROP_SHARE = "share";
    private static final String PROP_HARDWARE = "hardware";
    private static final String PROP_LOGOUT = "logout";
    public static final String PROP_NICKNAME = "nickName";
    public static final String PROP_KEYDB = "keydb";
    public static final String PROP_CERTDB = "certdb";
    public static final String PROP_MN = "mn";
    public static final String PROP_WRAPPING_CHOICE = "wrapping.choice";

    public String getId() {
        return "storageKeyUnit";
    }

    public void setId(String id) throws EBaseException {
        throw new EBaseException(CMS.getUserMessage((String)"CMS_INVALID_OPERATION", (String[])new String[0]));
    }

    public WrappingParams getWrappingParams(boolean encrypt) throws Exception {
        String choice = null;
        try {
            choice = this.mConfig.getString(PROP_WRAPPING_CHOICE);
        }
        catch (EBaseException e) {
            return this.getOldWrappingParams();
        }
        ConfigStore config = this.mConfig.getSubStore("wrapping." + choice, ConfigStore.class);
        if (config == null) {
            throw new EBaseException("Invalid config: Wrapping parameters not defined");
        }
        WrappingParams params = new WrappingParams();
        params.setSkType(config.getString("sessionKeyType"));
        params.setSkLength(config.getInteger("sessionKeyLength", 0));
        String keyWrapAlg = config.getString("sessionKeyWrapAlgorithm");
        if ("RSA".equals(keyWrapAlg) && this.useOAEPKeyWrap) {
            keyWrapAlg = "RSAES-OAEP";
        }
        params.setSkWrapAlgorithm(keyWrapAlg);
        params.setSkKeyGenAlgorithm(config.getString("sessionKeyKeyGenAlgorithm"));
        params.setPayloadWrapAlgorithm(config.getString("payloadWrapAlgorithm"));
        if (config.getString("payloadEncryptionOID", null) != null) {
            String oidString = config.getString("payloadEncryptionOID");
            params.setPayloadEncryptionAlgorithm(EncryptionAlgorithm.fromOID((OBJECT_IDENTIFIER)new OBJECT_IDENTIFIER(oidString)));
        } else {
            params.setPayloadEncryptionAlgorithm(config.getString("payloadEncryptionAlgorithm"), config.getString("payloadEncryptionMode"), config.getString("payloadEncryptionPadding"), config.getInteger("sessionKeyLength"));
        }
        byte[] iv = this.getConfigIV(config, "payloadEncryptionIV", "payloadEncryptionIVLen");
        if (iv != null) {
            params.setPayloadEncryptionIV(new IVParameterSpec(iv));
        }
        if ((iv = this.getConfigIV(config, "payloadWrapIV", "payloadWrapIVLen")) != null) {
            params.setPayloadWrappingIV(new IVParameterSpec(iv));
        }
        if (encrypt && (params.getPayloadWrapAlgorithm().equals(KeyWrapAlgorithm.AES_KEY_WRAP) || params.getPayloadWrapAlgorithm().equals(KeyWrapAlgorithm.AES_KEY_WRAP_PAD))) {
            params.setPayloadWrapAlgorithm(KeyWrapAlgorithm.AES_CBC_PAD);
            iv = CryptoUtil.getNonceData((int)16);
            params.setPayloadWrappingIV(new IVParameterSpec(iv));
        }
        return params;
    }

    private byte[] getConfigIV(ConfigStore config, String iv_label, String len_label) throws Exception {
        String iv_string = config.getString(iv_label, null);
        String iv_len = config.getString(len_label, null);
        if (iv_string != null) {
            return Base64.decodeBase64((String)iv_string);
        }
        if (iv_len != null) {
            return CryptoUtil.getNonceData((int)Integer.parseInt(iv_len));
        }
        return null;
    }

    private boolean byteArraysMatch(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ConfigStore config, boolean keySplitting) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        this.mConfig = config;
        this.mKeySplitting = keySplitting;
        KRAEngineConfig kraCfg = null;
        kraCfg = engine.getConfig();
        this.useOAEPKeyWrap = kraCfg.getUseOAEPKeyWrap();
        logger.debug("StorageKeyUnit.init: keyWrap.useOAEP" + this.useOAEPKeyWrap);
        try {
            this.mManager = CryptoManager.getInstance();
            this.mToken = this.getToken();
        }
        catch (NotInitializedException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_INIT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}));
        }
        if (this.mConfig.getString(PROP_HARDWARE, null) != null) {
            System.setProperty("cms.skip_token", this.mConfig.getString(PROP_HARDWARE));
            if (this.mKeySplitting) {
                byte[] certFileData = null;
                FileInputStream fi = null;
                try {
                    File certFile = new File(this.mConfig.getString(PROP_CERTDB));
                    certFileData = new byte[Long.valueOf(certFile.length()).intValue()];
                    fi = new FileInputStream(certFile);
                    fi.read(certFileData);
                }
                catch (IOException e) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_READ_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}));
                }
                finally {
                    try {
                        if (fi != null) {
                            fi.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    X509Certificate[] certs = this.getToken().getCryptoStore().getCertificates();
                    for (int i = 0; i < certs.length; ++i) {
                        if (!this.byteArraysMatch(certs[i].getEncoded(), certFileData)) continue;
                        this.mCert = certs[i];
                    }
                    if (this.mCert == null) {
                        logger.error("Storage Cert could not be initialized. No cert in token matched kra-cert file");
                        throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{"mCert == null"}));
                    }
                    logger.info("Using Storage Cert " + this.mCert.getSubjectDN());
                }
                catch (CertificateEncodingException e) {
                    logger.error("Error encoding cert: " + e.getMessage(), (Throwable)e);
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}));
                }
                catch (TokenException e) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_READ_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}));
                }
            }
        } else {
            byte[] certData = null;
            FileInputStream fi = null;
            try {
                if (this.mKeySplitting) {
                    File certFile = new File(this.mConfig.getString(PROP_CERTDB));
                    certData = new byte[Long.valueOf(certFile.length()).intValue()];
                    fi = new FileInputStream(certFile);
                    fi.read(certData);
                    this.mCert = this.mManager.findCertByNickname(config.getString(PROP_NICKNAME));
                } else {
                    this.mCert = this.mManager.findCertByNickname(config.getString(PROP_NICKNAME));
                }
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_READ_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
            }
            catch (TokenException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_READ_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
            }
            catch (ObjectNotFoundException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_READ_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                try {
                    this.mCert = this.mManager.importCertPackage(certData, "kraStorageCert");
                }
                catch (Exception ex) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_IMPORT_CERT", (Object[])new Object[]{e.toString()}), (Throwable)ex);
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{ex.toString()}));
                }
            }
            finally {
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.mKeySplitting) {
                try {
                    File priFile = new File(this.mConfig.getString(PROP_KEYDB));
                    this.mPrivateKeyData = new byte[Long.valueOf(priFile.length()).intValue()];
                    fi = new FileInputStream(priFile);
                    fi.read(this.mPrivateKeyData);
                }
                catch (IOException e) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_READ_PRIVATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{e.toString()}));
                }
                finally {
                    if (fi != null) {
                        try {
                            fi.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (this.mKeySplitting) {
            this.mTokenFile = this.mConfig.getString(PROP_MN);
            try {
                this.mStorageConfig = engine.loadConfigStore(this.mTokenFile);
            }
            catch (EBaseException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_READ_MN", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_OPERATION", (String[])new String[0]), (Throwable)e);
            }
        }
        try {
            if (this.mCert == null) {
                logger.debug("mCert is null...retrieving " + config.getString(PROP_NICKNAME));
                this.mCert = this.mManager.findCertByNickname(config.getString(PROP_NICKNAME));
                logger.debug("mCert = " + this.mCert);
            }
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_READ_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    public void startup() throws EBaseException {
    }

    public void shutdown() {
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public static SymmetricKey buildSymmetricKeyWithInternalStorage(String pin) throws EBaseException {
        try {
            return StorageKeyUnit.buildSymmetricKey(CryptoManager.getInstance().getInternalKeyStorageToken(), pin);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static SymmetricKey buildSymmetricKey(CryptoToken token, String pin) throws EBaseException {
        Password pass = new Password(pin.toCharArray());
        try {
            KeyGenerator kg = token.getKeyGenerator((KeyGenAlgorithm)PBEAlgorithm.PBE_SHA1_DES3_CBC);
            byte[] salt = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
            PBEKeyGenParams kgp = new PBEKeyGenParams(pass, salt, 5);
            kg.initialize((AlgorithmParameterSpec)kgp);
            SymmetricKey symmetricKey = kg.generate();
            return symmetricKey;
        }
        catch (TokenException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{"buildSymmetricKey:" + e.toString()}));
        }
        catch (NoSuchAlgorithmException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{"buildSymmetricKey:" + e.toString()}));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{"buildSymmetricKey:" + e.toString()}));
        }
        catch (CharConversionException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{"buildSymmetricKey:" + e.toString()}));
        }
        finally {
            pass.clear();
        }
    }

    public PrivateKey unwrapStorageKey(CryptoToken token, SymmetricKey sk, byte[] wrapped, PublicKey pubKey) throws EBaseException {
        try {
            logger.debug("StorageKeyUnit.unwrapStorageKey.");
            KeyWrapper wrapper = token.getKeyWrapper(KeyWrapAlgorithm.DES3_CBC_PAD);
            wrapper.initUnwrap(sk, (AlgorithmParameterSpec)IV);
            PrivateKey pk = wrapper.unwrapTemporaryPrivate(wrapped, PrivateKey.RSA, pubKey);
            return pk;
        }
        catch (TokenException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{"unwrapStorageKey:" + e.toString()}));
        }
        catch (NoSuchAlgorithmException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{"unwrapStorageKey:" + e.toString()}));
        }
        catch (InvalidKeyException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{"unwrapStorageKey:" + e.toString()}));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{"unwrapStorageKey:" + e.toString()}));
        }
    }

    public byte[] wrapStorageKey(CryptoToken token, SymmetricKey sk, PrivateKey pri) throws EBaseException {
        logger.debug("StorageKeyUnit.wrapStorageKey.");
        try {
            return CryptoUtil.wrapUsingSymmetricKey((CryptoToken)token, (SymmetricKey)sk, (PrivateKey)pri, (IVParameterSpec)IV, (KeyWrapAlgorithm)KeyWrapAlgorithm.DES3_CBC_PAD);
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{"wrapStorageKey:" + e.toString()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String pin) throws EBaseException {
        if (this.mConfig.getString(PROP_HARDWARE, null) != null) {
            Password password = new Password(pin.toCharArray());
            try {
                this.getToken().login((PasswordCallback)password);
                PrivateKey[] pk = this.getToken().getCryptoStore().getPrivateKeys();
                for (int i = 0; i < pk.length; ++i) {
                    if (!StorageKeyUnit.arraysEqual(pk[i].getUniqueID(), ((TokenCertificate)this.mCert).getUniqueID())) continue;
                    this.mPrivateKey = pk[i];
                }
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_LOGIN", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            finally {
                password.clear();
            }
        } else {
            try {
                SymmetricKey sk = StorageKeyUnit.buildSymmetricKey(this.mToken, pin);
                this.mPrivateKey = this.unwrapStorageKey(this.mToken, sk, this.mPrivateKeyData, this.getPublicKey());
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_LOGIN", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (this.mPrivateKey == null) {
                this.mPrivateKey = this.getPrivateKey();
            }
        }
    }

    public void login(Credential[] creds) throws EBaseException {
        String pwd = this.constructPassword(creds);
        this.login(pwd);
    }

    public void logout() {
        try {
            if (this.mConfig.getString(PROP_HARDWARE, null) != null && this.mConfig.getBoolean(PROP_LOGOUT, false)) {
                this.getToken().logout();
            }
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_LOGOUT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        this.mPrivateKey = null;
    }

    public Enumeration<String> getAgentIdentifiers() {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (true) {
            try {
                String uid = this.mStorageConfig.getString(PROP_UID + i);
                if (uid == null) break;
                v.addElement(uid);
            }
            catch (EBaseException e) {
                break;
            }
            ++i;
        }
        return v.elements();
    }

    public boolean changeAgentPassword(String id, String oldpwd, String newpwd) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        byte[] share = null;
        int i = 0;
        while (true) {
            try {
                String uid = this.mStorageConfig.getString(PROP_UID + i);
                if (uid == null) break;
                if (id.equals(uid)) {
                    share = this.decryptShareWithInternalStorage(this.mStorageConfig.getString(PROP_SHARE + i), oldpwd);
                    this.mStorageConfig.putString(PROP_SHARE + i, this.encryptShareWithInternalStorage(share, newpwd));
                    this.mStorageConfig.commit(false);
                    jssSubsystem.obscureBytes(share);
                    return true;
                }
            }
            catch (Exception e) {
                jssSubsystem.obscureBytes(share);
                break;
            }
            ++i;
        }
        return false;
    }

    public boolean changeAgentMN(int new_n, int new_m, Credential[] oldcreds, Credential[] newcreds) throws EBaseException {
        int i;
        if (new_n != newcreds.length) {
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_N", (String[])new String[0]));
        }
        String secret = this.constructPassword(oldcreds);
        for (int j = new_n; j < this.getNoOfAgents(); ++j) {
            this.mStorageConfig.remove(PROP_UID + j);
            this.mStorageConfig.remove(PROP_SHARE + j);
        }
        byte[][] shares = new byte[newcreds.length][];
        IShare s = null;
        try {
            String className = this.mConfig.getString("share_class", "com.netscape.cms.shares.OldShare");
            s = (IShare)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Loading Shares error " + e.getMessage(), (Throwable)e);
        }
        if (s == null) {
            logger.warn("Share plugin is not found");
            return false;
        }
        try {
            s.initialize(secret.getBytes(), new_m);
        }
        catch (Exception e) {
            logger.warn("Failed to initialize Share plugin: " + e.getMessage(), (Throwable)e);
            return false;
        }
        for (i = 0; i < newcreds.length; ++i) {
            byte[] share = s.createShare(i + 1);
            shares[i] = share;
        }
        this.mStorageConfig.putInteger(PROP_N, new_n);
        this.mStorageConfig.putInteger(PROP_M, new_m);
        for (i = 0; i < newcreds.length; ++i) {
            this.mStorageConfig.putString(PROP_UID + i, newcreds[i].getIdentifier());
            this.mStorageConfig.putString(PROP_SHARE + i, this.encryptShareWithInternalStorage(shares[i], newcreds[i].getPassword()));
        }
        try {
            this.mStorageConfig.commit(false);
            return true;
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_CHANGE_MN", (Object[])new Object[]{e.toString()}), (Throwable)e);
            return false;
        }
    }

    public int getNoOfAgents() throws EBaseException {
        return this.mStorageConfig.getInteger(PROP_N);
    }

    public int getNoOfRequiredAgents() throws EBaseException {
        return this.mStorageConfig.getInteger(PROP_M);
    }

    public void setNoOfRequiredAgents(int number) {
        this.mStorageConfig.putInteger(PROP_M, number);
    }

    @Override
    public CryptoToken getInternalToken() {
        try {
            return CryptoManager.getInstance().getInternalKeyStorageToken();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public CryptoToken getToken() {
        try {
            String tokenName = this.mConfig.getString(PROP_HARDWARE, null);
            return CryptoUtil.getKeyStorageToken((String)tokenName);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public CryptoToken getToken(X509Certificate cert) {
        return this.getToken();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.mCert.getPublicKey();
    }

    @Override
    public PrivateKey getPrivateKey() {
        if (this.mKeySplitting) {
            return this.mPrivateKey;
        }
        try {
            PrivateKey[] pk = this.getToken().getCryptoStore().getPrivateKeys();
            for (int i = 0; i < pk.length; ++i) {
                if (!StorageKeyUnit.arraysEqual(pk[i].getUniqueID(), ((TokenCertificate)this.mCert).getUniqueID())) continue;
                return pk[i];
            }
        }
        catch (TokenException tokenException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(X509Certificate cert) {
        return this.getPrivateKey();
    }

    public void verify(byte[] publicKey, PrivateKey privateKey) throws EBaseException {
    }

    public String encryptShareWithInternalStorage(byte[] share, String pwd) throws EBaseException {
        try {
            return this.encryptShare(CryptoManager.getInstance().getInternalKeyStorageToken(), share, pwd);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String encryptShare(CryptoToken token, byte[] share, String pwd) throws EBaseException {
        try {
            logger.debug("StorageKeyUnit.encryptShare");
            Cipher cipher = token.getCipherContext(EncryptionAlgorithm.DES3_CBC_PAD);
            SymmetricKey sk = StorageKeyUnit.buildSymmetricKey(token, pwd);
            cipher.initEncrypt(sk, (AlgorithmParameterSpec)IV);
            byte[] prev = StorageKeyUnit.preVerify(share);
            byte[] enc = cipher.doFinal(prev);
            return Utils.base64encode((byte[])enc, (boolean)true).trim();
        }
        catch (NoSuchAlgorithmException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{e.toString()}));
        }
        catch (TokenException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{e.toString()}));
        }
        catch (InvalidKeyException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{e.toString()}));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{e.toString()}));
        }
        catch (BadPaddingException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{e.toString()}));
        }
        catch (IllegalBlockSizeException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEY_1", (String[])new String[]{e.toString()}));
        }
    }

    public static byte[] preVerify(byte[] share) {
        byte[] data = new byte[share.length + 2];
        data[0] = 0;
        data[1] = 0;
        for (int i = 0; i < share.length; ++i) {
            data[2 + i] = share[i];
        }
        return data;
    }

    public static boolean verifyShare(byte[] share) {
        return share[0] == 0 && share[1] == 0;
    }

    public static byte[] postVerify(byte[] share) {
        byte[] data = new byte[share.length - 2];
        for (int i = 2; i < share.length; ++i) {
            data[i - 2] = share[i];
        }
        return data;
    }

    public void checkPassword(String userid, String pwd) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        int i = 0;
        while (true) {
            String uid = null;
            try {
                uid = this.mStorageConfig.getString(PROP_UID + i);
                if (uid == null) {
                }
            }
            catch (Exception e) {}
            break;
            if (uid.equals(userid)) {
                byte[] data = this.decryptShareWithInternalStorage(this.mStorageConfig.getString(PROP_SHARE + i), pwd);
                if (data == null) {
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
                }
                jssSubsystem.obscureBytes(data);
                return;
            }
            ++i;
        }
        throw new EBaseException(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
    }

    public byte[] decryptShareWithInternalStorage(String encoding, String pwd) throws EBaseException {
        try {
            return this.decryptShare(CryptoManager.getInstance().getInternalKeyStorageToken(), encoding, pwd);
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] decryptShare(CryptoToken token, String encoding, String pwd) throws EBaseException {
        try {
            logger.debug("StorageKeyUnit.decryptShare");
            byte[] share = Utils.base64decode((String)encoding);
            Cipher cipher = token.getCipherContext(EncryptionAlgorithm.DES3_CBC_PAD);
            SymmetricKey sk = StorageKeyUnit.buildSymmetricKey(token, pwd);
            cipher.initDecrypt(sk, (AlgorithmParameterSpec)IV);
            byte[] dec = cipher.doFinal(share);
            if (dec == null || !StorageKeyUnit.verifyShare(dec)) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
            }
            return StorageKeyUnit.postVerify(dec);
        }
        catch (OutOfMemoryError e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PASSWORD", (String[])new String[]{e.toString()}));
        }
        catch (TokenException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PASSWORD", (String[])new String[]{e.toString()}));
        }
        catch (NoSuchAlgorithmException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PASSWORD", (String[])new String[]{e.toString()}));
        }
        catch (InvalidKeyException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PASSWORD", (String[])new String[]{e.toString()}));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PASSWORD", (String[])new String[]{e.toString()}));
        }
        catch (IllegalBlockSizeException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PASSWORD", (String[])new String[]{e.toString()}));
        }
        catch (BadPaddingException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PASSWORD", (String[])new String[]{e.toString()}));
        }
    }

    private String constructPassword(Credential[] creds) throws EBaseException {
        Object pwd;
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        Hashtable<String, byte[]> v = new Hashtable<String, byte[]>();
        int i = 0;
        while (true) {
            String uid = null;
            try {
                uid = this.mStorageConfig.getString(PROP_UID + i);
                if (uid == null) {
                }
            }
            catch (Exception e) {}
            break;
            for (int j = 0; j < creds.length; ++j) {
                if (!uid.equals(creds[j].getIdentifier())) continue;
                pwd = this.decryptShareWithInternalStorage(this.mStorageConfig.getString(PROP_SHARE + i), creds[j].getPassword());
                if (pwd == null) {
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
                }
                v.put(Integer.toString(i), (byte[])pwd);
                jssSubsystem.obscureBytes(pwd);
                break;
            }
            ++i;
        }
        if (v.size() < 0) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
        }
        if (v.size() != creds.length) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
        }
        IJoinShares j = null;
        try {
            String className = this.mConfig.getString("joinshares_class", "com.netscape.cms.shares.OldJoinShares");
            j = (IJoinShares)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.warn("JoinShares error " + e.getMessage(), (Throwable)e);
        }
        if (j == null) {
            logger.error("JoinShares plugin is not found");
            throw new EBaseException(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
        }
        try {
            j.initialize(v.size());
        }
        catch (Exception e) {
            logger.error("Failed to initialize JoinShares: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
        }
        Enumeration e = v.keys();
        while (e.hasMoreElements()) {
            String next = (String)e.nextElement();
            j.addShare(Integer.parseInt(next) + 1, (byte[])v.get(next));
        }
        try {
            byte[] secret = j.recoverSecret();
            pwd = new String(secret);
            jssSubsystem.obscureBytes(secret);
            return pwd;
        }
        catch (Exception ee) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_STORAGE_RECONSTRUCT", (Object[])new Object[]{e.toString()}), (Throwable)ee);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PASSWORD", (String[])new String[]{ee.toString()}), (Throwable)ee);
        }
    }

    public static boolean arraysEqual(byte[] bytes, byte[] ints) {
        if (bytes == null || ints == null) {
            return false;
        }
        if (bytes.length != ints.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == ints[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] encryptInternalPrivate(byte[] priKey, WrappingParams params) throws Exception {
        try (DerOutputStream out = new DerOutputStream();){
            logger.debug("StorageKeyUnit.encryptInternalPrivate");
            CryptoToken internalToken = this.getInternalToken();
            SymmetricKey sk = CryptoUtil.generateKey((CryptoToken)internalToken, (KeyGenAlgorithm)params.getSkKeyGenAlgorithm(), (int)params.getSkLength(), null, (boolean)false);
            byte[] pri = CryptoUtil.encryptUsingSymmetricKey((CryptoToken)internalToken, (SymmetricKey)sk, (byte[])priKey, (EncryptionAlgorithm)params.getPayloadEncryptionAlgorithm(), (IVParameterSpec)params.getPayloadEncryptionIV());
            byte[] session = CryptoUtil.wrapUsingPublicKey((CryptoToken)internalToken, (PublicKey)this.getPublicKey(), (SymmetricKey)sk, (KeyWrapAlgorithm)params.getSkWrapAlgorithm());
            DerOutputStream tmp = new DerOutputStream();
            tmp.putOctetString(session);
            tmp.putOctetString(pri);
            out.write((byte)48, tmp);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public byte[] wrap(PrivateKey privKey, WrappingParams params) throws Exception {
        return this._wrap(privKey, null, params);
    }

    public byte[] wrap(SymmetricKey symmKey, WrappingParams params) throws Exception {
        return this._wrap(null, symmKey, params);
    }

    private byte[] _wrap(PrivateKey priKey, SymmetricKey symmKey, WrappingParams params) throws Exception {
        try (DerOutputStream out = new DerOutputStream();){
            if (priKey == null && symmKey == null || priKey != null && symmKey != null) {
                byte[] byArray = null;
                return byArray;
            }
            logger.debug("StorageKeyUnit.wrap interal.");
            CryptoToken token = this.getToken();
            SymmetricKey.Usage[] usages = new SymmetricKey.Usage[]{SymmetricKey.Usage.WRAP, SymmetricKey.Usage.UNWRAP};
            SymmetricKey sk = CryptoUtil.generateKey((CryptoToken)token, (KeyGenAlgorithm)params.getSkKeyGenAlgorithm(), (int)params.getSkLength(), (SymmetricKey.Usage[])usages, (boolean)true);
            byte[] pri = null;
            if (priKey != null) {
                pri = CryptoUtil.wrapUsingSymmetricKey((CryptoToken)token, (SymmetricKey)sk, (PrivateKey)priKey, (IVParameterSpec)params.getPayloadWrappingIV(), (KeyWrapAlgorithm)params.getPayloadWrapAlgorithm());
            } else if (symmKey != null) {
                pri = CryptoUtil.wrapUsingSymmetricKey((CryptoToken)token, (SymmetricKey)sk, (SymmetricKey)symmKey, (IVParameterSpec)params.getPayloadWrappingIV(), (KeyWrapAlgorithm)params.getPayloadWrapAlgorithm());
            }
            logger.debug("StorageKeyUnit:wrap() privKey wrapped");
            byte[] session = CryptoUtil.wrapUsingPublicKey((CryptoToken)token, (PublicKey)this.getPublicKey(), (SymmetricKey)sk, (KeyWrapAlgorithm)params.getSkWrapAlgorithm());
            logger.debug("StorageKeyUnit:wrap() session key wrapped");
            DerOutputStream tmp = new DerOutputStream();
            tmp.putOctetString(session);
            tmp.putOctetString(pri);
            out.write((byte)48, tmp);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public byte[] decryptInternalPrivate(byte[] wrappedKeyData, WrappingParams params) throws Exception {
        logger.debug("StorageKeyUnit.decryptInternalPrivate");
        DerValue val = new DerValue(wrappedKeyData);
        DerInputStream in = val.data;
        DerValue dSession = in.getDerValue();
        byte[] session = dSession.getOctetString();
        DerValue dPri = in.getDerValue();
        byte[] pri = dPri.getOctetString();
        CryptoToken token = this.getToken();
        logger.debug("decryptInternalPrivate(): getting key wrapper on slot:" + token.getName());
        SymmetricKey sk = this.unwrap_session_key(token, session, SymmetricKey.Usage.DECRYPT, params);
        return CryptoUtil.decryptUsingSymmetricKey((CryptoToken)token, (IVParameterSpec)params.getPayloadEncryptionIV(), (byte[])pri, (SymmetricKey)sk, (EncryptionAlgorithm)params.getPayloadEncryptionAlgorithm());
    }

    public SymmetricKey unwrap(byte[] wrappedKeyData, SymmetricKey.Type algorithm, int keySize, WrappingParams params) throws Exception {
        DerValue val = new DerValue(wrappedKeyData);
        DerInputStream in = val.data;
        DerValue dSession = in.getDerValue();
        byte[] session = dSession.getOctetString();
        DerValue dPri = in.getDerValue();
        byte[] pri = dPri.getOctetString();
        CryptoToken token = this.getToken();
        SymmetricKey sk = this.unwrap_session_key(token, session, SymmetricKey.Usage.UNWRAP, params);
        return CryptoUtil.unwrap((CryptoToken)token, (SymmetricKey.Type)algorithm, (int)keySize, (SymmetricKey.Usage)SymmetricKey.Usage.UNWRAP, (SymmetricKey)sk, (byte[])pri, (KeyWrapAlgorithm)params.getPayloadWrapAlgorithm(), (IVParameterSpec)params.getPayloadWrappingIV());
    }

    public PrivateKey unwrap(byte[] wrappedKeyData, PublicKey pubKey, boolean temporary, WrappingParams params) throws Exception {
        DerValue val = new DerValue(wrappedKeyData);
        DerInputStream in = val.data;
        DerValue dSession = in.getDerValue();
        byte[] session = dSession.getOctetString();
        DerValue dPri = in.getDerValue();
        byte[] pri = dPri.getOctetString();
        CryptoToken token = this.getToken();
        SymmetricKey sk = this.unwrap_session_key(token, session, SymmetricKey.Usage.UNWRAP, params);
        return CryptoUtil.unwrap((CryptoToken)token, (PublicKey)pubKey, (boolean)temporary, (SymmetricKey)sk, (byte[])pri, (KeyWrapAlgorithm)params.getPayloadWrapAlgorithm(), (IVParameterSpec)params.getPayloadWrappingIV());
    }
}

