/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.system;

import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.system.DomainInfo;
import com.netscape.certsrv.system.InstallToken;
import com.netscape.certsrv.system.SecurityDomainHost;
import java.util.Collection;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;

public class SecurityDomainClient
extends Client {
    public SecurityDomainClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "securityDomain");
    }

    public InstallToken getInstallToken(String hostname, String subsystem) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (hostname != null) {
            params.put("hostname", hostname);
        }
        if (subsystem != null) {
            params.put("subsystem", subsystem);
        }
        return this.get("installToken", params, InstallToken.class);
    }

    public DomainInfo getDomainInfo() throws Exception {
        return this.get("domainInfo", DomainInfo.class);
    }

    public Collection<SecurityDomainHost> getHosts() throws Exception {
        GenericType<Collection<SecurityDomainHost>> responseType = new GenericType<Collection<SecurityDomainHost>>(){};
        return this.get("hosts", null, responseType);
    }

    public SecurityDomainHost getHost(String hostID) throws Exception {
        return this.get("hosts/" + hostID, null, SecurityDomainHost.class);
    }

    public void addHost(SecurityDomainHost host) throws Exception {
        Entity<SecurityDomainHost> entity = this.client.entity(host);
        this.put("hosts", null, entity, Void.class);
    }

    public void removeHost(String hostID) throws Exception {
        this.delete("hosts/" + hostID, Void.class);
    }
}

