/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.util;

import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.util.CryptoProvider;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class NSSCryptoProvider
extends CryptoProvider {
    private CryptoManager manager;
    private CryptoToken token;
    private File certDBDir;
    private String certDBPassword;

    public CryptoManager getManager() {
        return this.manager;
    }

    public void setManager(CryptoManager manager) {
        this.manager = manager;
    }

    public CryptoToken getToken() {
        return this.token;
    }

    public void setToken(CryptoToken token) {
        this.token = token;
    }

    public NSSCryptoProvider(ClientConfig config) throws Exception {
        if (config == null) {
            throw new IllegalArgumentException("ClientConfig object must be specified.");
        }
        if (config.getNSSDatabase() == null) {
            throw new IllegalArgumentException("Missing NSS database directory");
        }
        this.certDBDir = new File(config.getNSSDatabase());
        this.certDBPassword = config.getNSSPassword();
        this.initialize();
    }

    @Override
    public void initialize() throws Exception {
        try {
            CryptoManager.initialize((String)this.certDBDir.getAbsolutePath());
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            // empty catch block
        }
        this.manager = CryptoManager.getInstance();
        this.token = this.manager.getInternalKeyStorageToken();
        if (this.certDBPassword != null) {
            Password password = new Password(this.certDBPassword.toCharArray());
            try {
                this.token.login((PasswordCallback)password);
            }
            catch (TokenException | IncorrectPasswordException e) {
                if (!this.token.isLoggedIn()) {
                    this.token.initPassword((PasswordCallback)password, (PasswordCallback)password);
                }
            }
            finally {
                password.clear();
            }
        }
    }

    @Override
    public SymmetricKey generateSymmetricKey(String keyAlgorithm, int keySize) throws Exception {
        if (this.token == null) {
            throw new NotInitializedException();
        }
        return CryptoUtil.generateKey(this.token, this.getKeyGenAlgorithm(keyAlgorithm), keySize, null, false);
    }

    @Override
    public SymmetricKey generateSessionKey() throws Exception {
        return this.generateSymmetricKey("AES", 128);
    }

    @Override
    public SymmetricKey generateSessionKey(EncryptionAlgorithm algorithm) throws Exception {
        return this.generateSymmetricKey(algorithm.getAlg().toString(), algorithm.getKeyStrength());
    }

    @Override
    public byte[] wrapSymmetricKey(SymmetricKey symmetricKey, PublicKey wrappingKey) throws Exception {
        if (this.manager == null || this.token == null) {
            throw new NotInitializedException();
        }
        return CryptoUtil.wrapSymmetricKey(this.token, wrappingKey, symmetricKey);
    }

    @Override
    public byte[] wrapSymmetricKey(SymmetricKey symmetricKey, PublicKey wrappingKey, KeyWrapAlgorithm alg) throws Exception {
        if (this.manager == null || this.token == null) {
            throw new NotInitializedException();
        }
        return CryptoUtil.wrapUsingPublicKey(this.token, wrappingKey, symmetricKey, alg);
    }

    @Override
    public byte[] encryptSecret(byte[] secret, byte[] iv, SymmetricKey key, String encryptionAlgorithm) throws Exception {
        return this.encryptSecret(secret, iv, key, this.getEncryptionAlgorithm(encryptionAlgorithm));
    }

    @Override
    public byte[] encryptSecret(byte[] secret, byte[] iv, SymmetricKey key, EncryptionAlgorithm encryptionAlgorithm) throws Exception {
        if (this.token == null) {
            throw new NotInitializedException();
        }
        return CryptoUtil.encryptSecret(this.token, secret, new IVParameterSpec(iv), key, encryptionAlgorithm);
    }

    @Override
    public byte[] unwrapWithSessionKey(byte[] wrappedRecoveredKey, SymmetricKey recoveryKey, String encryptionAlgorithm, byte[] nonceData) throws Exception {
        return this.unwrapWithSessionKey(wrappedRecoveredKey, recoveryKey, this.getEncryptionAlgorithm(encryptionAlgorithm), nonceData);
    }

    @Override
    public byte[] unwrapWithSessionKey(byte[] wrappedRecoveredKey, SymmetricKey recoveryKey, EncryptionAlgorithm encryptionAlgorithm, byte[] nonceData) throws Exception {
        if (this.token == null) {
            throw new NotInitializedException();
        }
        IVParameterSpec ivps = null;
        if (nonceData != null) {
            ivps = new IVParameterSpec(nonceData);
        }
        return CryptoUtil.decryptUsingSymmetricKey(this.token, ivps, wrappedRecoveredKey, recoveryKey, encryptionAlgorithm);
    }

    @Override
    public byte[] unwrapSymmetricKeyWithSessionKey(byte[] wrappedRecoveredKey, SymmetricKey recoveryKey, KeyWrapAlgorithm wrapAlgorithm, byte[] nonceData, String algorithm, int size) throws Exception {
        if (this.token == null) {
            throw new NotInitializedException();
        }
        IVParameterSpec ivps = null;
        if (nonceData != null) {
            ivps = new IVParameterSpec(nonceData);
        }
        SymmetricKey key = CryptoUtil.unwrap(this.token, SymmetricKey.Type.fromName((String)algorithm), size, SymmetricKey.Usage.DECRYPT, recoveryKey, wrappedRecoveredKey, wrapAlgorithm, ivps);
        return key.getEncoded();
    }

    @Override
    public byte[] unwrapAsymmetricKeyWithSessionKey(byte[] wrappedRecoveredKey, SymmetricKey recoveryKey, KeyWrapAlgorithm wrapAlgorithm, byte[] nonceData, PublicKey pubKey) throws Exception {
        if (this.token == null) {
            throw new NotInitializedException();
        }
        IVParameterSpec ivps = null;
        if (nonceData != null) {
            ivps = new IVParameterSpec(nonceData);
        }
        PrivateKey key = CryptoUtil.unwrap(this.token, pubKey, true, recoveryKey, wrappedRecoveredKey, wrapAlgorithm, ivps);
        return key.getEncoded();
    }

    @Override
    public byte[] unwrapWithPassphrase(byte[] wrappedRecoveredKey, String recoveryPassphrase) throws Exception {
        return CryptoUtil.unwrapUsingPassphrase(wrappedRecoveredKey, recoveryPassphrase);
    }

    public KeyGenAlgorithm getKeyGenAlgorithm(String keyAlgorithm) throws NoSuchAlgorithmException {
        if (keyAlgorithm == null) {
            return KeyGenAlgorithm.DES3;
        }
        KeyGenAlgorithm alg = null;
        switch (keyAlgorithm) {
            case "AES": {
                alg = KeyGenAlgorithm.AES;
                break;
            }
            case "DES": {
                alg = KeyGenAlgorithm.DES;
                break;
            }
            case "DESede": {
                alg = KeyGenAlgorithm.DESede;
                break;
            }
            case "RC2": {
                alg = KeyGenAlgorithm.RC2;
                break;
            }
            case "RC4": {
                alg = KeyGenAlgorithm.RC4;
                break;
            }
            case "DES3": {
                alg = KeyGenAlgorithm.DES3;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("No Algorithm named: " + keyAlgorithm);
            }
        }
        return alg;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm(String encryptionAlgorithm) throws NoSuchAlgorithmException {
        if (encryptionAlgorithm == null) {
            return EncryptionAlgorithm.DES3_CBC_PAD;
        }
        EncryptionAlgorithm alg = null;
        switch (encryptionAlgorithm) {
            case "AES": {
                alg = EncryptionAlgorithm.AES_CBC_PAD;
                break;
            }
            case "DES": {
                alg = EncryptionAlgorithm.DES_CBC_PAD;
                break;
            }
            case "RC2": {
                alg = EncryptionAlgorithm.RC2_CBC_PAD;
                break;
            }
            case "RC4": {
                alg = EncryptionAlgorithm.RC4;
                break;
            }
            case "DES3": {
                alg = EncryptionAlgorithm.DES3_CBC_PAD;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("No Algorithm named: " + encryptionAlgorithm);
            }
        }
        return alg;
    }

    @Override
    public byte[] wrapWithSessionKey(SymmetricKey secret, SymmetricKey sessionKey, byte[] iv) throws Exception {
        return CryptoUtil.wrapUsingSymmetricKey(this.token, sessionKey, secret, null, KeyWrapAlgorithm.AES_KEY_WRAP_PAD);
    }

    @Override
    public byte[] wrapWithSessionKey(SymmetricKey secret, SymmetricKey sessionKey, byte[] iv, KeyWrapAlgorithm wrapAlg) throws Exception {
        IVParameterSpec ivps = null;
        if (iv != null) {
            ivps = new IVParameterSpec(iv);
        }
        return CryptoUtil.wrapUsingSymmetricKey(this.token, sessionKey, secret, ivps, wrapAlg);
    }
}

