/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.nss;

import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HexFormat;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.dogtag.util.cert.CertUtil;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.extensions.AuthInfoAccessExtension;
import org.mozilla.jss.netscape.security.extensions.ExtendedKeyUsageExtension;
import org.mozilla.jss.netscape.security.extensions.OCSPNoCheckExtension;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AuthorityKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CPSuri;
import org.mozilla.jss.netscape.security.x509.CertificatePoliciesExtension;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyId;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyInfo;
import org.mozilla.jss.netscape.security.x509.DNSName;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.PolicyQualifierInfo;
import org.mozilla.jss.netscape.security.x509.PolicyQualifiers;
import org.mozilla.jss.netscape.security.x509.Qualifier;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSExtensionGenerator {
    public static Logger logger = LoggerFactory.getLogger(NSSExtensionGenerator.class);
    public static final HexFormat HEX_FORMAT = HexFormat.ofDelimiter(":");
    private Map<String, String> parameters = new LinkedHashMap<String, String>();

    public void init(String filename) throws Exception {
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(filename);){
            properties.load(is);
        }
        this.parameters.clear();
        for (String name : properties.stringPropertyNames()) {
            String value = properties.getProperty(name);
            this.parameters.put(name, value);
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public Collection<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public Collection<String> getParameterNames(String parent) {
        String prefix = parent + ".";
        int length = prefix.length();
        return this.parameters.keySet().stream().filter(name -> name.startsWith(prefix)).map(name -> name.substring(length)).collect(Collectors.toSet());
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String removeParameter(String name) {
        return this.parameters.remove(name);
    }

    public BasicConstraintsExtension createBasicConstraintsExtension() throws Exception {
        String basicConstraints = this.getParameter("basicConstraints");
        if (basicConstraints == null) {
            return null;
        }
        logger.info("Creating basic constraint extension:");
        boolean critical = false;
        boolean ca = false;
        int pathLength = -1;
        List<String> options = Arrays.asList(basicConstraints.split("\\s*,\\s*"));
        for (String option : options) {
            if (option.equals("critical")) {
                logger.info("- critical");
                critical = true;
                continue;
            }
            if (option.startsWith("CA:")) {
                ca = Boolean.parseBoolean(option.substring(3));
                logger.info("- CA: " + ca);
                continue;
            }
            if (option.startsWith("pathlen:")) {
                pathLength = Integer.parseInt(option.substring(8));
                logger.info("- path length: " + pathLength);
                continue;
            }
            throw new Exception("Unsupported option: " + option);
        }
        return new BasicConstraintsExtension(ca, critical, pathLength);
    }

    public AuthorityKeyIdentifierExtension createAKIDExtension(X509Certificate issuer) throws Exception {
        if (issuer == null) {
            return null;
        }
        String authorityKeyIdentifier = this.getParameter("authorityKeyIdentifier");
        if (authorityKeyIdentifier == null) {
            return null;
        }
        logger.info("Creating AKID extension:");
        List<String> options = Arrays.asList(authorityKeyIdentifier.split("\\s*,\\s*"));
        for (String option : options) {
            option = option.trim();
            logger.info("- " + option);
            if (option.equals("keyid") || option.equals("keyid:always")) continue;
            throw new Exception("Unsupported option: " + option);
        }
        X509CertImpl issuerImpl = new X509CertImpl(issuer.getEncoded());
        SubjectKeyIdentifierExtension skidExtension = (SubjectKeyIdentifierExtension)issuerImpl.getExtension("2.5.29.14");
        KeyIdentifier keyID = (KeyIdentifier)skidExtension.get("key_id");
        String akid = "0x" + Utils.HexEncode((byte[])keyID.getIdentifier());
        logger.info("- AKID: " + akid);
        return new AuthorityKeyIdentifierExtension(keyID, null, null);
    }

    public SubjectKeyIdentifierExtension createSKIDExtension(X509Key subjectKey) throws Exception {
        if (subjectKey == null) {
            return null;
        }
        String subjectKeyIdentifier = this.getParameter("subjectKeyIdentifier");
        if (subjectKeyIdentifier == null) {
            return null;
        }
        logger.info("Creating SKID extension:");
        boolean critical = false;
        byte[] bytes = null;
        List<String> values = Arrays.asList(subjectKeyIdentifier.split(","));
        for (String value : values) {
            value = value.trim();
            logger.info("- " + value);
            if (value.equals("critical")) {
                critical = true;
                continue;
            }
            if (value.equals("hash")) {
                bytes = CryptoUtil.generateKeyIdentifier(subjectKey.getKey());
                continue;
            }
            try {
                bytes = HEX_FORMAT.parseHex(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported subject key identifier: " + value + ": " + e.getMessage(), e);
            }
        }
        String skid = "0x" + Utils.HexEncode(bytes);
        logger.info("- SKID: " + skid);
        return new SubjectKeyIdentifierExtension(critical, bytes);
    }

    public AuthInfoAccessExtension createAIAExtension() throws Exception {
        String authorityInfoAccess = this.getParameter("authorityInfoAccess");
        if (authorityInfoAccess == null) {
            return null;
        }
        logger.info("Creating AIA extension:");
        AuthInfoAccessExtension extension = new AuthInfoAccessExtension(false);
        List<String> options = Arrays.asList(authorityInfoAccess.split("\\s*,\\s*"));
        for (int i = 0; i < options.size(); ++i) {
            ObjectIdentifier method;
            String value;
            String option = options.get(i).trim();
            if (option.startsWith("caIssuers;")) {
                value = option.substring(10);
                logger.info("- CA issuers");
                method = AuthInfoAccessExtension.METHOD_CA_ISSUERS;
            } else if (option.startsWith("OCSP;")) {
                value = option.substring(5);
                logger.info("- OCSP");
                method = AuthInfoAccessExtension.METHOD_OCSP;
            } else {
                throw new Exception("Unsupported AIA method: " + option);
            }
            if (!value.startsWith("URI:")) {
                throw new Exception("Unsupported AIA location: " + value);
            }
            String uri = value.substring(4);
            logger.info("  - URI: " + uri);
            GeneralName location = new GeneralName((GeneralNameInterface)new URIName(uri));
            extension.addAccessDescription(method, location);
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            extension.encode((OutputStream)os);
        }
        return extension;
    }

    public KeyUsageExtension createKeyUsageExtension() throws Exception {
        String keyUsage = this.getParameter("keyUsage");
        if (keyUsage == null) {
            return null;
        }
        logger.info("Creating key usage extension:");
        KeyUsageExtension extension = new KeyUsageExtension(false, new boolean[0]);
        List<String> options = Arrays.asList(keyUsage.split("\\s*,\\s*"));
        for (String option : options) {
            logger.info("- " + option);
            if ("critical".equals(option)) {
                extension.setCritical(true);
                continue;
            }
            if ("digitalSignature".equals(option)) {
                extension.set("digital_signature", (Object)true);
                continue;
            }
            if ("nonRepudiation".equals(option)) {
                extension.set("non_repudiation", (Object)true);
                continue;
            }
            if ("keyEncipherment".equals(option)) {
                extension.set("key_encipherment", (Object)true);
                continue;
            }
            if ("dataEncipherment".equals(option)) {
                extension.set("data_encipherment", (Object)true);
                continue;
            }
            if ("keyAgreement".equals(option)) {
                extension.set("key_agreement", (Object)true);
                continue;
            }
            if ("keyCertSign".equals(option)) {
                extension.set("key_certsign", (Object)true);
                continue;
            }
            if ("cRLSign".equals(option)) {
                extension.set("crl_sign", (Object)true);
                continue;
            }
            if ("encipherOnly".equals(option)) {
                extension.set("encipher_only", (Object)true);
                continue;
            }
            if ("decipherOnly".equals(option)) {
                extension.set("decipher_only", (Object)true);
                continue;
            }
            throw new Exception("Unsupported key usage: " + option);
        }
        return extension;
    }

    public ExtendedKeyUsageExtension createExtendedKeyUsageExtension() throws Exception {
        String extendedKeyUsage = this.getParameter("extendedKeyUsage");
        if (extendedKeyUsage == null) {
            return null;
        }
        logger.info("Creating extended key usage extension:");
        boolean critical = false;
        Vector<ObjectIdentifier> oids = new Vector<ObjectIdentifier>();
        List<String> options = Arrays.asList(extendedKeyUsage.split("\\s*,\\s*"));
        for (String option : options) {
            logger.info("- " + option);
            if ("critical".equals(option)) {
                critical = true;
                continue;
            }
            if ("serverAuth".equals(option)) {
                oids.add(ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.1"));
                continue;
            }
            if ("clientAuth".equals(option)) {
                oids.add(ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.2"));
                continue;
            }
            if ("emailProtection".equals(option)) {
                oids.add(ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.4"));
                continue;
            }
            if ("OCSPSigning".equals(option)) {
                oids.add(ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.9"));
                continue;
            }
            throw new Exception("Unsupported extended key usage: " + option);
        }
        return new ExtendedKeyUsageExtension(critical, oids);
    }

    public CertificatePoliciesExtension createCertificatePoliciesExtension() throws Exception {
        String certificatePolicies = this.getParameter("certificatePolicies");
        if (certificatePolicies == null) {
            return null;
        }
        logger.info("Creating certificate policies extension:");
        Vector<CertificatePolicyInfo> infos = new Vector<CertificatePolicyInfo>();
        List<String> options = Arrays.asList(certificatePolicies.split("\\s*,\\s*"));
        for (int i = 0; i < options.size(); ++i) {
            CertificatePolicyInfo info;
            String option = options.get(i);
            if (option.startsWith("@")) {
                String section = option.substring(1);
                String oid = this.getParameter(section + ".id");
                logger.info("- " + oid);
                CertificatePolicyId policyID = new CertificatePolicyId(ObjectIdentifier.getObjectIdentifier((String)oid));
                PolicyQualifiers qualifiers = new PolicyQualifiers();
                String cpsProperty = section + ".CPS";
                ArrayList<String> cpsIDs = new ArrayList<String>(this.getParameterNames(cpsProperty));
                for (int j = 0; j < cpsIDs.size(); ++j) {
                    String cpsID = (String)cpsIDs.get(j);
                    String uri = this.getParameter(cpsProperty + "." + cpsID);
                    logger.info("  - CPS: " + uri);
                    CPSuri cpsURI = new CPSuri(uri);
                    PolicyQualifierInfo cpsQualifierInfo = new PolicyQualifierInfo(PolicyQualifierInfo.QT_CPS, (Qualifier)cpsURI);
                    qualifiers.add(cpsQualifierInfo);
                }
                if (qualifiers.size() == 0) {
                    qualifiers = null;
                }
                info = new CertificatePolicyInfo(policyID, qualifiers);
            } else {
                logger.info("- " + option);
                CertificatePolicyId policyID = new CertificatePolicyId(ObjectIdentifier.getObjectIdentifier((String)option));
                info = new CertificatePolicyInfo(policyID);
            }
            infos.add(info);
        }
        return new CertificatePoliciesExtension(infos);
    }

    public OCSPNoCheckExtension createOCSPNoCheckExtension() throws Exception {
        String noCheck = this.getParameter("noCheck");
        if (noCheck == null) {
            return null;
        }
        logger.info("Creating OCSP No Check extension");
        return new OCSPNoCheckExtension();
    }

    public SubjectAlternativeNameExtension createSANExtension(PKCS10 pkcs10) throws Exception {
        String subjectAltName = this.getParameter("subjectAltName");
        if (subjectAltName == null) {
            return null;
        }
        logger.info("Creating subject alternative name extension:");
        List<String> options = Arrays.asList(subjectAltName.split("\\s*,\\s*"));
        boolean critical = false;
        LinkedHashSet<String> dnsNames = new LinkedHashSet<String>();
        for (String option : options) {
            if (option.equals("critical")) {
                logger.info("- critical");
                critical = true;
                continue;
            }
            if (option.equals("DNS:request_subject_cn") && pkcs10 != null) {
                X500Name subjectName = pkcs10.getSubjectName();
                logger.info("Getting CN from subject name: " + subjectName);
                String cn = CertUtil.getCommonName(subjectName);
                if (cn == null) continue;
                cn = cn.toLowerCase();
                logger.info("- DNS:" + cn);
                dnsNames.add(cn);
                continue;
            }
            if (option.equals("DNS:request_san_ext") && pkcs10 != null) {
                logger.info("Getting SAN extension from CSR");
                SubjectAlternativeNameExtension sanExtension = CertUtil.getSANExtension(pkcs10);
                if (sanExtension == null) continue;
                logger.info("Getting DNS names from SAN extension");
                Set<String> names = CertUtil.getDNSNames(sanExtension);
                for (String name : names) {
                    name = name.toLowerCase();
                    logger.info("- DNS:" + name);
                    dnsNames.add(name);
                }
                continue;
            }
            if (!option.startsWith("DNS:")) continue;
            String name = option.substring(4);
            name = name.toLowerCase();
            logger.info("- DNS:" + name);
            dnsNames.add(name);
        }
        GeneralNames generalNames = new GeneralNames();
        for (String name : dnsNames) {
            generalNames.add((Object)new DNSName(name));
        }
        return new SubjectAlternativeNameExtension(critical, generalNames);
    }

    public Collection<Extension> createGenericExtensions() throws Exception {
        String genericExtensions = this.getParameter("genericExtensions");
        if (genericExtensions == null) {
            return null;
        }
        List<String> oids = Arrays.asList(genericExtensions.split("\\s*,\\s*"));
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (String oid : oids) {
            Extension extension = this.createGenericExtension(oid);
            extensions.add(extension);
        }
        return extensions;
    }

    public Extension createGenericExtension(String oid) throws Exception {
        logger.info("Creating " + oid + " extension:");
        String value = this.getParameter(oid);
        List<String> options = Arrays.asList(value.split("\\s*,\\s*"));
        byte[] extValue = null;
        boolean critical = false;
        for (String option : options) {
            if (option.equals("critical")) {
                logger.info("- critical");
                critical = true;
                continue;
            }
            if (option.startsWith("DER:")) {
                String hexValues = option.substring(4);
                logger.info("- DER: " + hexValues);
                String[] bytes = hexValues.split(":");
                byte[] data = new byte[bytes.length];
                for (int i = 0; i < bytes.length; ++i) {
                    data[i] = (byte)Integer.parseInt(bytes[i], 16);
                }
                DerOutputStream os = new DerOutputStream();
                try {
                    os.putOctetString(data);
                    extValue = os.toByteArray();
                    continue;
                }
                finally {
                    os.close();
                    continue;
                }
            }
            throw new Exception("Unsupported option: " + option);
        }
        return new Extension(new ObjectIdentifier(oid), critical, extValue);
    }

    public Extensions createExtensions() throws Exception {
        return this.createExtensions(null, null, null);
    }

    public Extensions createExtensions(X509Key subjectKey) throws Exception {
        return this.createExtensions(subjectKey, null, null);
    }

    public Extensions createExtensions(X509Certificate issuer, PKCS10 pkcs10) throws Exception {
        X509Key subjectKey = pkcs10.getSubjectPublicKeyInfo();
        return this.createExtensions(subjectKey, issuer, pkcs10);
    }

    public Extensions createExtensions(X509Key subjectKey, X509Certificate issuer, PKCS10 pkcs10) throws Exception {
        Collection<Extension> genericExtensions;
        SubjectAlternativeNameExtension sanExtension;
        OCSPNoCheckExtension ocspNoCheckExtension;
        CertificatePoliciesExtension certificatePoliciesExtension;
        ExtendedKeyUsageExtension extendedKeyUsageExtension;
        KeyUsageExtension keyUsageExtension;
        AuthInfoAccessExtension aiaExtension;
        SubjectKeyIdentifierExtension skidExtension;
        AuthorityKeyIdentifierExtension akidExtension;
        Extensions extensions = new Extensions();
        BasicConstraintsExtension basicConstraintsExtension = this.createBasicConstraintsExtension();
        if (basicConstraintsExtension != null) {
            extensions.parseExtension((Extension)basicConstraintsExtension);
        }
        if ((akidExtension = this.createAKIDExtension(issuer)) != null) {
            extensions.parseExtension((Extension)akidExtension);
        }
        if ((skidExtension = this.createSKIDExtension(subjectKey)) != null) {
            extensions.parseExtension((Extension)skidExtension);
        }
        if ((aiaExtension = this.createAIAExtension()) != null) {
            extensions.parseExtension((Extension)aiaExtension);
        }
        if ((keyUsageExtension = this.createKeyUsageExtension()) != null) {
            extensions.parseExtension((Extension)keyUsageExtension);
        }
        if ((extendedKeyUsageExtension = this.createExtendedKeyUsageExtension()) != null) {
            extensions.parseExtension((Extension)extendedKeyUsageExtension);
        }
        if ((certificatePoliciesExtension = this.createCertificatePoliciesExtension()) != null) {
            extensions.parseExtension((Extension)certificatePoliciesExtension);
        }
        if ((ocspNoCheckExtension = this.createOCSPNoCheckExtension()) != null) {
            extensions.parseExtension((Extension)ocspNoCheckExtension);
        }
        if ((sanExtension = this.createSANExtension(pkcs10)) != null) {
            extensions.parseExtension((Extension)sanExtension);
        }
        if ((genericExtensions = this.createGenericExtensions()) != null) {
            for (Extension extension : genericExtensions) {
                extensions.parseExtension(extension);
            }
        }
        return extensions;
    }
}

