/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.database;

import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.controls.LDAPPersistSearchControl;
import org.dogtagpki.acme.database.LDAPDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPConfigMonitor
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(LDAPConfigMonitor.class);
    LDAPDatabase database;
    LDAPPersistSearchControl searchControl = new LDAPPersistSearchControl(4, false, true, true);
    boolean running;

    public LDAPDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(LDAPDatabase database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            LDAPConnection conn = null;
            try {
                conn = this.database.connFactory.getConn();
                LDAPSearchConstraints searchConstraints = conn.getSearchConstraints();
                searchConstraints.setServerControls((LDAPControl)this.searchControl);
                searchConstraints.setBatchSize(1);
                searchConstraints.setServerTimeLimit(0);
                logger.info("Start monitoring ACME configuration");
                LDAPSearchResults results = conn.search("ou=config," + this.database.baseDN, 0, "(objectClass=*)", null, false, searchConstraints);
                while (this.running && results.hasMoreElements()) {
                    LDAPEntry entry = results.next();
                    logger.info("Updating ACME configuration");
                    LDAPAttribute acmeEnabled = entry.getAttribute("acmeEnabled");
                    if (acmeEnabled == null) {
                        this.database.enabled = null;
                    } else {
                        String value = acmeEnabled.getStringValueArray()[0];
                        this.database.enabled = Boolean.parseBoolean(value);
                    }
                    logger.info("- enabled: " + this.database.enabled);
                }
                logger.info("Stop monitoring ACME configuration");
            }
            catch (Throwable e) {
                logger.error("Unable to monitor ACME configuration: " + e.getMessage(), e);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                if (conn == null) continue;
                this.database.connFactory.returnConn(conn);
            }
        }
    }

    public void stop() throws Exception {
        this.running = false;
    }
}

