/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthTokenSubjectNameDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(AuthTokenSubjectNameDefault.class);
    public static final String VAL_NAME = "name";

    public AuthTokenSubjectNameDefault() {
        this.addValueName(VAL_NAME);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        logger.debug("AuthTokenSubjectNameDefault: begins");
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NAME)) {
            X500Name x500name = null;
            try {
                x500name = new X500Name(value);
                logger.debug("AuthTokenSubjectNameDefault: setValue x500name=" + x500name);
            }
            catch (IOException e) {
                logger.warn("AuthTokenSubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
            }
            logger.debug("AuthTokenSubjectNameDefault: setValue name=" + x500name);
            try {
                info.set("subject", (Object)new CertificateSubjectName(x500name));
            }
            catch (Exception e) {
                logger.warn("AuthTokenSubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
            }
        } else {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException("Invalid name " + name);
        }
        if (name.equals(VAL_NAME)) {
            CertificateSubjectName sn = null;
            try {
                sn = (CertificateSubjectName)info.get("subject");
                return sn.toString();
            }
            catch (Exception e) {
                logger.warn("AuthTokenSubjectNameDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_AUTHTOKEN_SUBJECT_NAME", (String[])new String[0]);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        try {
            X500Name name = new X500Name(request.getExtDataInString("authenticatedName"));
            logger.debug("AuthTokenSubjectNameDefault: X500Name=" + name.getName());
            info.set("subject", (Object)new CertificateSubjectName(name));
        }
        catch (Exception e) {
            logger.error("AuthTokenSubjectNameDefault: " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_FOUND", (String[])new String[0]));
        }
    }
}

