/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.PolicyConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyConstraintsExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(PolicyConstraintsExtDefault.class);
    public static final String CONFIG_CRITICAL = "policyConstraintsCritical";
    public static final String CONFIG_REQ_EXPLICIT_POLICY = "policyConstraintsReqExplicitPolicy";
    public static final String CONFIG_INHIBIT_POLICY_MAPPING = "policyConstraintsInhibitPolicyMapping";
    public static final String VAL_CRITICAL = "policyConstraintsCritical";
    public static final String VAL_REQ_EXPLICIT_POLICY = "policyConstraintsReqExplicitPolicy";
    public static final String VAL_INHIBIT_POLICY_MAPPING = "policyConstraintsInhibitPolicyMapping";

    public PolicyConstraintsExtDefault() {
        this.addValueName("policyConstraintsCritical");
        this.addValueName("policyConstraintsReqExplicitPolicy");
        this.addValueName("policyConstraintsInhibitPolicyMapping");
        this.addConfigName("policyConstraintsCritical");
        this.addConfigName("policyConstraintsReqExplicitPolicy");
        this.addConfigName("policyConstraintsInhibitPolicyMapping");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("policyConstraintsCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("policyConstraintsReqExplicitPolicy")) {
            return new Descriptor("integer", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_REQUIRED_EXPLICIT_POLICY", (String[])new String[0]));
        }
        if (name.equals("policyConstraintsInhibitPolicyMapping")) {
            return new Descriptor("integer", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INHIBIT_POLICY_MAPPING", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("policyConstraintsCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("policyConstraintsReqExplicitPolicy")) {
            return new Descriptor("integer", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_REQUIRED_EXPLICIT_POLICY", (String[])new String[0]));
        }
        if (name.equals("policyConstraintsInhibitPolicyMapping")) {
            return new Descriptor("integer", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INHIBIT_POLICY_MAPPING", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            PolicyConstraintsExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (PolicyConstraintsExtension)this.getExtension(PKIXExtensions.PolicyConstraints_Id.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("policyConstraintsCritical")) {
                ext = (PolicyConstraintsExtension)this.getExtension(PKIXExtensions.PolicyConstraints_Id.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else if (name.equals("policyConstraintsReqExplicitPolicy")) {
                ext = (PolicyConstraintsExtension)this.getExtension(PKIXExtensions.PolicyConstraints_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Integer num = Integer.valueOf(value);
                ext.set("require", (Object)num);
            } else if (name.equals("policyConstraintsInhibitPolicyMapping")) {
                ext = (PolicyConstraintsExtension)this.getExtension(PKIXExtensions.PolicyConstraints_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Integer num = Integer.valueOf(value);
                ext.set("inhibit", (Object)num);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(PKIXExtensions.PolicyConstraints_Id.toString(), (Extension)ext, info);
        }
        catch (EProfileException e) {
            logger.error("PolicyConstraintsExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (IOException e) {
            logger.error("PolicyConstraintsExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        PolicyConstraintsExtension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        ext = (PolicyConstraintsExtension)this.getExtension(PKIXExtensions.PolicyConstraints_Id.toString(), info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("policyConstraintsCritical")) {
            ext = (PolicyConstraintsExtension)this.getExtension(PKIXExtensions.PolicyConstraints_Id.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals("policyConstraintsReqExplicitPolicy")) {
            ext = (PolicyConstraintsExtension)this.getExtension(PKIXExtensions.PolicyConstraints_Id.toString(), info);
            if (ext == null) {
                return "";
            }
            int num = ext.getRequireExplicitMapping();
            return "" + num;
        }
        if (name.equals("policyConstraintsInhibitPolicyMapping")) {
            ext = (PolicyConstraintsExtension)this.getExtension(PKIXExtensions.PolicyConstraints_Id.toString(), info);
            if (ext == null) {
                return "";
            }
            int num = ext.getInhibitPolicyMapping();
            return "" + num;
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig("policyConstraintsCritical"), this.getConfig("policyConstraintsReqExplicitPolicy"), this.getConfig("policyConstraintsInhibitPolicyMapping")};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_POLICY_CONSTRAINTS_EXT", (String[])params);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        PolicyConstraintsExtension ext = this.createExtension();
        if (ext == null) {
            return;
        }
        this.addExtension(PKIXExtensions.PolicyConstraints_Id.toString(), (Extension)ext, info);
    }

    public PolicyConstraintsExtension createExtension() {
        PolicyConstraintsExtension ext = null;
        try {
            String inhibit;
            boolean critical = this.getConfigBoolean("policyConstraintsCritical");
            int reqNum = -1;
            int inhibitNum = -1;
            String req = this.getConfig("policyConstraintsReqExplicitPolicy");
            if (req != null && req.length() > 0) {
                reqNum = Integer.parseInt(req);
            }
            if ((inhibit = this.getConfig("policyConstraintsInhibitPolicyMapping")) != null && inhibit.length() > 0) {
                inhibitNum = Integer.parseInt(inhibit);
            }
            ext = new PolicyConstraintsExtension(critical, reqNum, inhibitNum);
        }
        catch (Exception e) {
            logger.warn("PolicyConstraintsExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

